/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.core;

import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.DataBuffer;
import com.koteinik.chunksfadein.extensions.ChunkShaderInterfaceExt;
import com.koteinik.chunksfadein.extensions.RenderSectionExt;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlBuffer;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlMutableBuffer;
import net.caffeinemc.mods.sodium.client.gl.device.CommandList;

public class ChunkFadeInController {
    private final DataBuffer chunkFadeDatasBuffer = new DataBuffer(256, 4);
    private GlMutableBuffer chunkGlFadeDataBuffer;
    private boolean dirty = true;

    public ChunkFadeInController(CommandList commandList) {
        this.chunkGlFadeDataBuffer = commandList.createMutableBuffer();
        for (int i = 0; i < 256; ++i) {
            this.completeChunkFade(i, true);
        }
    }

    public float[] getChunkData(int chunkId) {
        float x = this.chunkFadeDatasBuffer.get(chunkId, 0);
        float y = this.chunkFadeDatasBuffer.get(chunkId, 1);
        float z = this.chunkFadeDatasBuffer.get(chunkId, 2);
        float w = this.chunkFadeDatasBuffer.get(chunkId, 3);
        return new float[]{x, y, z, w};
    }

    public void completeChunkFade(int chunkId, boolean completeFade) {
        this.chunkFadeDatasBuffer.put(chunkId, 0, 0.0f);
        this.chunkFadeDatasBuffer.put(chunkId, 1, 0.0f);
        this.chunkFadeDatasBuffer.put(chunkId, 2, 0.0f);
        if (completeFade) {
            this.chunkFadeDatasBuffer.put(chunkId, 3, 1.0f);
        }
    }

    public void resetFadeForChunk(int chunkId) {
        this.chunkFadeDatasBuffer.put(chunkId, 0, 0.0f);
        this.chunkFadeDatasBuffer.put(chunkId, 1, Config.isAnimationEnabled ? Config.animationOffset : 0.0f);
        this.chunkFadeDatasBuffer.put(chunkId, 2, 0.0f);
        this.chunkFadeDatasBuffer.put(chunkId, 3, Config.isFadeEnabled ? 0.0f : 1.0f);
    }

    public void uploadToBuffer(ChunkShaderInterfaceExt shader, CommandList commandList) {
        if (this.dirty) {
            this.chunkFadeDatasBuffer.uploadData(commandList, this.chunkGlFadeDataBuffer);
            this.dirty = false;
        }
        shader.setFadeDatas(this.chunkGlFadeDataBuffer);
    }

    public void processChunk(RenderSectionExt section, int sectionIndex) {
        long delta = section.calculateAndGetDelta();
        if (Config.isFadeEnabled) {
            this.dirty |= section.incrementFadeCoeff(delta, sectionIndex, this.chunkFadeDatasBuffer);
        } else if (this.chunkFadeDatasBuffer.get(sectionIndex, 3) != 1.0f) {
            this.chunkFadeDatasBuffer.put(sectionIndex, 3, 1.0f);
        }
        if (Config.isAnimationEnabled) {
            this.dirty |= section.incrementAnimationOffset(delta, sectionIndex, this.chunkFadeDatasBuffer);
        } else {
            for (int i = 0; i < 3; ++i) {
                if (this.chunkFadeDatasBuffer.get(sectionIndex, i) == 0.0f) continue;
                this.chunkFadeDatasBuffer.put(sectionIndex, i, 0.0f);
            }
        }
        section.setRenderedBefore();
    }

    public void delete(CommandList commandList) {
        this.chunkFadeDatasBuffer.delete();
        if (this.chunkGlFadeDataBuffer != null) {
            commandList.deleteBuffer((GlBuffer)this.chunkGlFadeDataBuffer);
        }
    }
}

