/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.core;

import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.AnimationType;
import com.koteinik.chunksfadein.core.FadeType;
import java.util.ArrayList;
import java.util.List;

public class FadeShader {
    private List<String> lines = new ArrayList<String>();

    public FadeShader vertOutUniforms() {
        this.newLine("struct ChunkFadeData { vec4 fadeData; };");
        this.newLine("layout(std140) uniform ubo_ChunkFadeDatas { ChunkFadeData Chunk_FadeDatas[256]; };");
        if (!Config.isModEnabled || !Config.isFadeEnabled) {
            return this;
        }
        this.newLine("flat out float cfi_FadeCoeff;");
        if (Config.fadeType == FadeType.BLOCK) {
            this.newLine("out vec3 cfi_Pos;");
        }
        if (Config.fadeType == FadeType.LINED) {
            this.newLine("out float cfi_LocalHeight;");
        }
        return this;
    }

    public FadeShader fragInVars() {
        if (!Config.isModEnabled || !Config.isFadeEnabled) {
            return this;
        }
        this.newLine("flat in float cfi_FadeCoeff;");
        if (Config.fadeType == FadeType.BLOCK) {
            this.newLine("in vec3 cfi_Pos;");
        }
        if (Config.fadeType == FadeType.LINED) {
            this.newLine("in float cfi_LocalHeight;");
        }
        return this;
    }

    public FadeShader vertMod(String localPos, String position, boolean modifyLocal, String drawId) {
        if (!Config.isModEnabled) {
            return this;
        }
        if (Config.isAnimationEnabled || Config.isFadeEnabled) {
            this.newLine("vec4 chunkFadeData = Chunk_FadeDatas[%s].fadeData;".formatted(drawId));
            if (Config.animationType == AnimationType.JAGGED || Config.animationType == AnimationType.DISPLACEMENT || Config.fadeType == FadeType.VERTEX) {
                this.rand("rand", "%s + vec3(%s)".formatted(localPos, drawId));
            }
        }
        if (Config.isFadeEnabled) {
            if (Config.fadeType == FadeType.BLOCK) {
                this.newLine("cfi_Pos = %s + vec3(%s);".formatted(localPos, drawId));
            }
            this.newLine("cfi_FadeCoeff = chunkFadeData.w");
            if (Config.fadeType == FadeType.VERTEX) {
                this.append(" > rand ? 1.0 : chunkFadeData.w / rand");
            }
            this.append(";");
            if (Config.fadeType == FadeType.LINED) {
                this.newLine("cfi_LocalHeight = %s.y;".formatted(localPos));
            }
        }
        if (Config.isAnimationEnabled) {
            switch (Config.animationType) {
                case DISPLACEMENT: {
                    this.newLine("if (%s.x != 0.0 && %s.y != 0.0 && %s.z != 0.0 && %s.x != 16.0 && %s.y != 16.0 && %s.z != 16.0) {".replace("%s", localPos));
                    this.randAppend("rand2", "%s - vec3(%s)".formatted(localPos, drawId));
                    this.randAppend("rand3", "%s + vec3(%s * uint(2))".formatted(localPos, drawId));
                    this.append("%s.xyz += vec3(rand - 0.5, rand2 - 0.5, rand3 - 0.5) * vec3(chunkFadeData.y);".formatted(modifyLocal ? localPos : position));
                    this.append("}");
                }
                case FULL: 
                case JAGGED: {
                    this.newLine("%s += chunkFadeData.xyz".formatted(modifyLocal ? localPos : position));
                    if (Config.animationType == AnimationType.JAGGED) {
                        this.append(" * rand");
                    }
                    this.append(";");
                    break;
                }
                case SCALE: {
                    if (modifyLocal) {
                        this.newLine("%s = mix(vec3(8.0), %s, 1.0 - chunkFadeData.y);".formatted(localPos, localPos));
                        break;
                    }
                    this.newLine("%s += vec3(8.0) - mix(vec3(8.0), %s, chunkFadeData.y);".formatted(position, localPos));
                }
            }
        }
        if (Config.isCurvatureEnabled) {
            this.newLine("%s.y -= dot(%s, %s) / %s;".formatted(modifyLocal ? localPos : position, position, position, Config.worldCurvature));
        }
        return this;
    }

    public FadeShader fragColorMod(String color, String fog) {
        if (!Config.isModEnabled || !Config.isFadeEnabled) {
            return this;
        }
        this.newLine("if (cfi_FadeCoeff >= 0.0 && cfi_FadeCoeff < 1.0) {");
        if (Config.fadeType == FadeType.LINED) {
            this.newLine("float fade = cfi_LocalHeight <= cfi_FadeCoeff * 16.0 ? 1.0 : 0.0;");
        }
        if (Config.fadeType == FadeType.BLOCK) {
            this.rand("rand", "floor(cfi_Pos)");
            this.newLine("float fade = cfi_FadeCoeff > rand ? 1.0 : cfi_FadeCoeff / rand;");
        }
        this.newLine("%s = mix(%s, %s, %s);".formatted(color, fog, color, Config.fadeType == FadeType.FULL || Config.fadeType == FadeType.VERTEX ? "cfi_FadeCoeff" : "fade"));
        this.newLine("}");
        return this;
    }

    public String dumpMultiline() {
        return String.join((CharSequence)"\n", this.dumpList());
    }

    public String dumpSingleLine() {
        return String.join((CharSequence)" ", this.dumpList());
    }

    public String[] dumpArray() {
        return (String[])this.dumpList().toArray(String[]::new);
    }

    public List<String> dumpList() {
        List<String> lines = this.lines;
        this.lines = new ArrayList<String>();
        return lines;
    }

    public FadeShader newLine(String line) {
        this.lines.add(line);
        return this;
    }

    public FadeShader append(String value) {
        int last = this.lines.size() - 1;
        this.lines.set(last, this.lines.get(last) + value);
        return this;
    }

    private void rand(String name, String vector) {
        this.newLine("float %s = fract(sin(dot(%s, vec3(12.9898, 78.233, 132.383))) * 43758.5453);".formatted(name, vector));
        this.newLine("if (%s == 0.0) %s = 0.001;".formatted(name, name));
    }

    private void randAppend(String name, String vector) {
        this.append("float %s = fract(sin(dot(%s, vec3(12.9898, 78.233, 132.383))) * 43758.5453);".formatted(name, vector));
        this.append("if (%s == 0.0) %s = 0.001;".formatted(name, name));
    }
}

