/*
 * Decompiled with CFR 0.152.
 */
package com.necro.fireworkcapsules.common.entity;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.necro.fireworkcapsules.common.components.FireworkCapsuleComponents;
import com.necro.fireworkcapsules.common.entity.FireworkCapsuleEntities;
import com.necro.fireworkcapsules.common.item.FireworkCapsuleItems;
import com.necro.fireworkcapsules.common.stickers.StickerExplosion;
import com.necro.fireworkcapsules.common.stickers.Stickers;
import com.necro.fireworkcapsules.common.util.IParticleCreator;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class CapsuleEntity
extends Entity
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> DATA_ID_CAPSULE_ITEM = SynchedEntityData.defineId(CapsuleEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<OptionalInt> DATA_OWNER_ENTITY = SynchedEntityData.defineId(CapsuleEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UNSIGNED_INT);
    private PokemonEntity owner;

    public CapsuleEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public CapsuleEntity(Level level, double x, double y, double z, ItemStack itemStack, PokemonEntity entity) {
        this((EntityType)FireworkCapsuleEntities.CAPSULE_ENTITY.value(), level);
        this.owner = entity;
        this.setPos(x, y, z);
        this.entityData.set(DATA_ID_CAPSULE_ITEM, (Object)itemStack.copy());
        this.entityData.set(DATA_OWNER_ENTITY, (Object)OptionalInt.of(entity.getId()));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ID_CAPSULE_ITEM, (Object)CapsuleEntity.getDefaultItem());
        builder.define(DATA_OWNER_ENTITY, (Object)OptionalInt.empty());
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        if (compoundTag.contains("CapsuleItem", 10)) {
            this.entityData.set(DATA_ID_CAPSULE_ITEM, (Object)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compoundTag.getCompound("CapsuleItem")).orElseGet(CapsuleEntity::getDefaultItem));
        } else {
            this.entityData.set(DATA_ID_CAPSULE_ITEM, (Object)CapsuleEntity.getDefaultItem());
        }
        if (compoundTag.contains("EntityId")) {
            this.entityData.set(DATA_OWNER_ENTITY, (Object)OptionalInt.of(compoundTag.getInt("EntityId")));
            this.owner = (PokemonEntity)this.level().getEntity(compoundTag.getInt("EntityId"));
        }
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.put("CapsuleItem", this.getItem().save((HolderLookup.Provider)this.registryAccess()));
        if (this.owner != null) {
            compoundTag.putInt("EntityId", this.owner.getId());
        }
    }

    public void handleEntityEvent(byte b) {
        if (b == 17 && this.level().isClientSide) {
            OptionalInt entityId = (OptionalInt)this.entityData.get(DATA_OWNER_ENTITY);
            if (entityId.isEmpty()) {
                return;
            }
            Entity entity = this.level().getEntity(entityId.getAsInt());
            if (!(entity instanceof PokemonEntity)) {
                return;
            }
            PokemonEntity pokemonEntity = (PokemonEntity)entity;
            float scale = this.getScale(pokemonEntity);
            ((IParticleCreator)this.level()).createCapsuleParticles(this.getX(), this.getY(), this.getZ(), pokemonEntity.yBodyRot, this.getExplosions(), scale);
        }
        super.handleEntityEvent(b);
    }

    private List<StickerExplosion> getExplosions() {
        ItemStack itemStack = (ItemStack)this.entityData.get(DATA_ID_CAPSULE_ITEM);
        Stickers stickers = (Stickers)itemStack.get((DataComponentType)FireworkCapsuleComponents.STICKERS.value());
        return stickers != null ? stickers.explosions() : List.of();
    }

    @NotNull
    public ItemStack getItem() {
        return (ItemStack)this.entityData.get(DATA_ID_CAPSULE_ITEM);
    }

    private static ItemStack getDefaultItem() {
        return new ItemStack(FireworkCapsuleItems.BALL_CAPSULE);
    }

    public void explode() {
        this.level().broadcastEntityEvent((Entity)this, (byte)17);
        this.discard();
    }

    private float getScale(PokemonEntity entity) {
        AABB boundingBox = entity.getBoundingBox();
        return (float)Math.pow((boundingBox.getXsize() + boundingBox.getYsize() + boundingBox.getZsize()) / 3.0, 0.6);
    }
}

