/*
 * Decompiled with CFR 0.152.
 */
package com.necro.fireworkcapsules.common.gui;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.gui.summary.widgets.ModelWidget;
import com.cobblemon.mod.common.client.storage.ClientParty;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.necro.fireworkcapsules.common.gui.CapsuleStationMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CapsuleStationScreen
extends AbstractContainerScreen<CapsuleStationMenu> {
    private static final ResourceLocation SCREEN_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"fireworkcapsules", (String)"textures/gui/container/capsule_station.png");
    private static final int PORTRAIT_SIZE = 28;

    public CapsuleStationScreen(CapsuleStationMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        this.imageWidth = 176;
        this.imageHeight = 181;
        this.titleLabelX = 8;
        this.titleLabelY = 6;
        this.inventoryLabelX = 8;
        this.inventoryLabelY = this.imageHeight - 93;
    }

    protected void init() {
        super.init();
        ClientParty party = CobblemonClient.INSTANCE.getStorage().getMyParty();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        for (int i = 0; i < 6; ++i) {
            Pokemon pokemon = party.get(i);
            if (pokemon == null) continue;
            ModelWidget modelWidget = new ModelWidget(x + 9 + 55 * (i % 3), y + 19 + 35 * (i / 3), 28, 28, pokemon.asRenderablePokemon(), 0.85f, 325.0f, -4.0, false);
            this.addRenderableOnly((Renderable)modelWidget);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
        int k = this.leftPos;
        int l = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(SCREEN_LOCATION, k, l, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        this.renderTooltip(guiGraphics, i, j);
    }

    public void onClose() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)CobblemonSounds.PC_OFF, (float)1.0f));
        super.onClose();
    }
}

