/*
 * Decompiled with CFR 0.152.
 */
package com.necro.fireworkcapsules.neoforge.events;

import com.necro.fireworkcapsules.common.gui.CapsuleStationScreen;
import com.necro.fireworkcapsules.common.gui.FireworkCapsuleMenus;
import com.necro.fireworkcapsules.common.particles.FireworkCapsuleParticles;
import com.necro.fireworkcapsules.common.particles.custom.FlashParticle;
import com.necro.fireworkcapsules.common.particles.custom.StickerParticle;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.registries.RegisterEvent;

public class ModEvents {

    @EventBusSubscriber(modid="fireworkcapsules", bus=EventBusSubscriber.Bus.MOD)
    public static class CommonEvents {
        @SubscribeEvent
        public static void registerParticles(RegisterEvent event) {
            CommonEvents.registerParticle("capsule_particle", FireworkCapsuleParticles.CAPSULE_PARTICLE, event);
            CommonEvents.registerParticle("bug_sticker", FireworkCapsuleParticles.BUG_STICKER, event);
            CommonEvents.registerParticle("dark_sticker", FireworkCapsuleParticles.DARK_STICKER, event);
            CommonEvents.registerParticle("dragon_sticker", FireworkCapsuleParticles.DRAGON_STICKER, event);
            CommonEvents.registerParticle("electric_sticker", FireworkCapsuleParticles.ELECTRIC_STICKER, event);
            CommonEvents.registerParticle("fairy_sticker", FireworkCapsuleParticles.FAIRY_STICKER, event);
            CommonEvents.registerParticle("fighting_sticker", FireworkCapsuleParticles.FIGHTING_STICKER, event);
            CommonEvents.registerParticle("fire_sticker", FireworkCapsuleParticles.FIRE_STICKER, event);
            CommonEvents.registerParticle("flying_sticker", FireworkCapsuleParticles.FLYING_STICKER, event);
            CommonEvents.registerParticle("ghost_sticker", FireworkCapsuleParticles.GHOST_STICKER, event);
            CommonEvents.registerParticle("grass_sticker", FireworkCapsuleParticles.GRASS_STICKER, event);
            CommonEvents.registerParticle("ground_sticker", FireworkCapsuleParticles.GROUND_STICKER, event);
            CommonEvents.registerParticle("ice_sticker", FireworkCapsuleParticles.ICE_STICKER, event);
            CommonEvents.registerParticle("normal_sticker", FireworkCapsuleParticles.NORMAL_STICKER, event);
            CommonEvents.registerParticle("poison_sticker", FireworkCapsuleParticles.POISON_STICKER, event);
            CommonEvents.registerParticle("psychic_sticker", FireworkCapsuleParticles.PSYCHIC_STICKER, event);
            CommonEvents.registerParticle("steel_sticker", FireworkCapsuleParticles.STEEL_STICKER, event);
            CommonEvents.registerParticle("rock_sticker", FireworkCapsuleParticles.ROCK_STICKER, event);
            CommonEvents.registerParticle("water_sticker", FireworkCapsuleParticles.WATER_STICKER, event);
        }

        private static void registerParticle(String name, ParticleType<?> particle, RegisterEvent event) {
            event.register(Registries.PARTICLE_TYPE, helper -> helper.register(ResourceLocation.fromNamespaceAndPath((String)"fireworkcapsules", (String)name), (Object)particle));
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)FireworkCapsuleMenus.CAPSULE_STATION_MENU.value(), CapsuleStationScreen::new);
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="fireworkcapsules", bus=EventBusSubscriber.Bus.MOD)
    public static class ClientEvents {
        @SubscribeEvent
        public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)FireworkCapsuleParticles.BUG_STICKER, StickerParticle.VariedStickerProvider::new);
            event.registerSpriteSet((ParticleType)FireworkCapsuleParticles.DARK_STICKER, StickerParticle.StickerProvider::new);
            event.registerSpriteSet((ParticleType)FireworkCapsuleParticles.DRAGON_STICKER, sprite -> new StickerParticle.ColoredStickerProvider(sprite, 9327353));
            event.registerSpriteSet((ParticleType)FireworkCapsuleParticles.ELECTRIC_STICKER, FlashParticle.FlashProvider::new);
            event.registerSpriteSet((ParticleType)FireworkCapsuleParticles.FAIRY_STICKER, StickerParticle.StickerProvider::new);
            event.registerSpriteSet((ParticleType)FireworkCapsuleParticles.FIGHTING_STICKER, FlashParticle.VariedFlashProvider::new);
            event.registerSpriteSet((ParticleType)FireworkCapsuleParticles.FIRE_STICKER, StickerParticle.StickerProvider::new);
            event.registerSpriteSet((ParticleType)FireworkCapsuleParticles.FLYING_STICKER, sprite -> new StickerParticle.ColoredStickerProvider(sprite, 12972793));
            event.registerSpriteSet((ParticleType)FireworkCapsuleParticles.GHOST_STICKER, StickerParticle.StickerProvider::new);
            event.registerSpriteSet((ParticleType)FireworkCapsuleParticles.GRASS_STICKER, sprite -> new StickerParticle.VariedColoredStickerProvider(sprite, 7194922));
            event.registerSpriteSet((ParticleType)FireworkCapsuleParticles.GROUND_STICKER, sprite -> new StickerParticle.ColoredStickerProvider(sprite, 14139023));
            event.registerSpriteSet((ParticleType)FireworkCapsuleParticles.ICE_STICKER, StickerParticle.VariedStickerProvider::new);
            event.registerSpriteSet((ParticleType)FireworkCapsuleParticles.NORMAL_STICKER, StickerParticle.StickerProvider::new);
            event.registerSpriteSet((ParticleType)FireworkCapsuleParticles.POISON_STICKER, StickerParticle.StickerProvider::new);
            event.registerSpriteSet((ParticleType)FireworkCapsuleParticles.PSYCHIC_STICKER, sprite -> new StickerParticle.ColoredStickerProvider(sprite, 14637291));
            event.registerSpriteSet((ParticleType)FireworkCapsuleParticles.STEEL_STICKER, StickerParticle.StickerProvider::new);
            event.registerSpriteSet((ParticleType)FireworkCapsuleParticles.ROCK_STICKER, StickerParticle.VariedStickerProvider::new);
            event.registerSpriteSet((ParticleType)FireworkCapsuleParticles.WATER_STICKER, StickerParticle.StickerProvider::new);
        }
    }
}

