/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.screen.container;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import owmii.powah.api.energy.endernetwork.IEnderExtender;
import owmii.powah.block.ender.AbstractEnderTile;
import owmii.powah.client.screen.Textures;
import owmii.powah.inventory.EnderCellContainer;
import owmii.powah.lib.client.screen.Texture;
import owmii.powah.lib.client.screen.container.AbstractEnergyScreen;
import owmii.powah.lib.client.screen.widget.IconButton;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.network.Network;
import owmii.powah.network.packet.SetChannelPacket;
import owmii.powah.util.Util;

public class EnderCellScreen
extends AbstractEnergyScreen<AbstractEnderTile<?>, EnderCellContainer> {
    private final IconButton[] iconButtons;

    public EnderCellScreen(EnderCellContainer container, Inventory inv, Component title) {
        super(container, inv, title, Textures.ENDER_CELL);
        this.iconButtons = new IconButton[((AbstractEnderTile)this.te).getMaxChannels()];
    }

    @Override
    protected void init() {
        super.init();
        for (int i = 0; i < this.iconButtons.length; ++i) {
            int channel = i;
            this.iconButtons[i] = (IconButton)this.addRenderableWidget((GuiEventListener)new IconButton(this.leftPos + 5 + i * 14, this.topPos + 55, i == ((AbstractEnderTile)this.te).getChannel().get() ? Textures.ENDER_CELL_BTN_0 : Textures.ENDER_CELL_BTN_1, button -> {
                Network.toServer(new SetChannelPacket(((AbstractEnderTile)this.te).getBlockPos(), channel));
                ((AbstractEnderTile)this.te).getChannel().set(channel);
            }, (Screen)this));
        }
    }

    @Override
    public void containerTick() {
        super.containerTick();
        for (int i = 0; i < this.iconButtons.length; ++i) {
            this.iconButtons[i].setTexture(i == ((AbstractEnderTile)this.te).getChannel().get() ? Textures.ENDER_CELL_BTN_0 : Textures.ENDER_CELL_BTN_1);
        }
    }

    @Override
    protected void drawBackground(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.drawBackground(guiGraphics, partialTicks, mouseX, mouseY);
        Textures.ENDER_CELL_GAUGE.drawScalableW(guiGraphics, ((AbstractEnderTile)this.te).getEnergy().subSized(), this.leftPos + 31, this.topPos + 6);
    }

    @Override
    protected void drawForeground(GuiGraphics gui, int mouseX, int mouseY) {
        super.drawForeground(gui, mouseX, mouseY);
        gui.pose().pushPose();
        RenderSystem.enableBlend();
        int a = 0x72000000;
        Energy e = ((AbstractEnderTile)this.te).getEnergy();
        String s = Util.addCommas(e.getStored()) + "/" + Util.numFormat(e.getCapacity()) + " FE";
        gui.drawString(this.font, s, 38, 13, a + 4915166, false);
        gui.drawString(this.font, Util.numFormat(e.getMaxExtract()) + " FE/t", 38, 27, a + 4915166, false);
        gui.pose().scale(0.5f, 0.5f, 1.0f);
        for (int i = 1; i < 13; ++i) {
            int f;
            int n = f = i > 9 ? -2 : 0;
            if (i > 1) {
                gui.pose().translate(14.0f, 0.0f, 0.0f);
            }
            gui.drawString(this.font, "" + i, 19 + i * 14 - 14 + f, 119, i <= ((AbstractEnderTile)this.te).getMaxChannels() ? 4096135 : a + 4096135, false);
        }
        RenderSystem.disableBlend();
        gui.pose().popPose();
    }

    @Override
    public void renderSlot(GuiGraphics matrix, Slot slot) {
        ItemStack stack = slot.getItem();
        if (((AbstractEnderTile)this.te).isExtender() && stack.getItem() instanceof IEnderExtender && EnderCellScreen.hasShiftDown()) {
            Energy energy = ((AbstractEnderTile)this.te).getEnergy();
            IEnderExtender e = (IEnderExtender)stack.getItem();
            long cap = e.getExtendedCapacity(stack);
            long newCap = energy.getCapacity() + cap;
            if (cap > 0L && cap <= 9000000000000000000L && newCap > 0L && newCap <= 9000000000000000000L) {
                Texture.SLOT_HIGHLIGHT_BG.draw(matrix, slot.x, slot.y);
            }
        }
        super.renderSlot(matrix, slot);
    }
}

