/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.block;

import com.google.common.primitives.Ints;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;
import owmii.powah.block.Tier;
import owmii.powah.config.IEnergyConfig;
import owmii.powah.lib.block.AbstractEnergyBlock;
import owmii.powah.lib.block.AbstractTickableTile;
import owmii.powah.lib.logistics.IRedstoneInteract;
import owmii.powah.lib.logistics.Transfer;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.energy.SideConfig;
import owmii.powah.lib.registry.IVariant;
import owmii.powah.util.ChargeUtil;
import owmii.powah.util.Util;

public abstract class AbstractEnergyStorage<C extends IEnergyConfig<Tier>, B extends AbstractEnergyBlock<C, B>>
extends AbstractTickableTile<Tier, B>
implements IRedstoneInteract {
    protected final SideConfig sideConfig = new SideConfig(this);
    protected final Energy energy = Energy.create(0L);
    @Nullable
    private final IEnergyStorage[] externalAdapters = new IEnergyStorage[Direction.values().length + 1];
    private final BlockCapabilityCache<IEnergyStorage, @Nullable Direction>[] capabilityCaches = new BlockCapabilityCache[6];

    public AbstractEnergyStorage(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, (Tier)IVariant.getEmpty());
    }

    public AbstractEnergyStorage(BlockEntityType<?> type, BlockPos pos, BlockState state, Tier variant) {
        super(type, pos, state, variant);
    }

    @Override
    public void readSync(CompoundTag nbt, HolderLookup.Provider registries) {
        this.sideConfig.read(nbt);
        if (!this.keepEnergy()) {
            this.energy.read(nbt, true, false);
        }
        super.readSync(nbt, registries);
    }

    @Override
    public CompoundTag writeSync(CompoundTag nbt, HolderLookup.Provider registries) {
        this.sideConfig.write(nbt);
        if (!this.keepEnergy()) {
            this.energy.write(nbt, true, false);
        }
        return super.writeSync(nbt, registries);
    }

    @Override
    public void readStorable(CompoundTag nbt, HolderLookup.Provider registries) {
        if (this.keepEnergy()) {
            this.energy.read(nbt, false, false);
        }
        super.readStorable(nbt, registries);
    }

    @Override
    public CompoundTag writeStorable(CompoundTag nbt, HolderLookup.Provider registries) {
        if (this.keepEnergy()) {
            this.energy.write(nbt, false, false);
        }
        return super.writeStorable(nbt, registries);
    }

    public boolean keepEnergy() {
        return false;
    }

    @Override
    protected void onFirstTick(Level world) {
        super.onFirstTick(world);
        this.energy.setCapacity(this.getEnergyCapacity());
        this.energy.setTransfer(this.getEnergyTransfer());
        this.getSideConfig().init();
        this.sync();
    }

    protected long extractFromSides(Level world) {
        long extracted = 0L;
        if (!this.isRemote()) {
            for (Direction side : Direction.values()) {
                if (!this.canExtractEnergy(side)) continue;
                if (this.capabilityCaches[side.ordinal()] == null) {
                    this.capabilityCaches[side.ordinal()] = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)((ServerLevel)world), (BlockPos)this.worldPosition.relative(side), (Object)side.getOpposite());
                }
                long amount = Math.min(this.getEnergyTransfer(), this.getEnergy().getStored());
                IEnergyStorage cap = (IEnergyStorage)this.capabilityCaches[side.ordinal()].getCapability();
                long toExtract = cap == null ? 0L : (long)cap.receiveEnergy(Ints.saturatedCast((long)amount), false);
                extracted += this.extractEnergy(Util.safeInt(toExtract), false, side);
            }
        }
        return extracted;
    }

    protected long chargeItems(int i) {
        return this.chargeItems(0, i);
    }

    protected long chargeItems(int i, int j) {
        Energy energy = this.getEnergy();
        long charged = ChargeUtil.chargeItemsInInventory(this.inv, i, j, this.getEnergyTransfer(), energy.getStored());
        energy.consume(charged);
        return charged;
    }

    public long extractEnergy(long maxExtract, boolean simulate, @Nullable Direction side) {
        if (!this.canExtractEnergy(side)) {
            return 0L;
        }
        Energy energy = this.getEnergy();
        long extracted = Math.min(energy.getStored(), Math.min(energy.getMaxExtract(), maxExtract));
        if (!simulate && extracted > 0L) {
            energy.consume(extracted);
            this.sync(10);
        }
        return extracted;
    }

    public long receiveEnergy(long maxReceive, boolean simulate, @Nullable Direction side) {
        if (!this.canReceiveEnergy(side)) {
            return 0L;
        }
        Energy energy = this.getEnergy();
        long received = Math.min(energy.getEmpty(), Math.min(energy.getMaxReceive(), maxReceive));
        if (!simulate && received > 0L) {
            energy.produce(received);
            this.sync(10);
        }
        return received;
    }

    public boolean canExtractEnergy(@Nullable Direction side) {
        return side == null || this.isEnergyPresent(side) && this.sideConfig.getType((Direction)side).canExtract;
    }

    public boolean canReceiveEnergy(@Nullable Direction side) {
        return side == null || this.isEnergyPresent(side) && this.sideConfig.getType((Direction)side).canReceive;
    }

    public boolean isEnergyPresent(@Nullable Direction side) {
        return true;
    }

    @Override
    public void onAdded(Level world, BlockState state, BlockState oldState, boolean isMoving) {
        super.onAdded(world, state, oldState, isMoving);
        if (state.getBlock() != oldState.getBlock()) {
            this.getSideConfig().init();
        }
    }

    protected long getEnergyCapacity() {
        return this.getConfig().getCapacity((Tier)((Tier)this.getVariant()));
    }

    protected long getEnergyTransfer() {
        return this.getConfig().getTransfer((Tier)((Tier)this.getVariant()));
    }

    protected C getConfig() {
        return (C)((IEnergyConfig)((AbstractEnergyBlock)this.getBlock()).getConfig());
    }

    public Energy getEnergy() {
        return this.energy;
    }

    public Transfer getTransferType() {
        return Transfer.ALL;
    }

    public SideConfig getSideConfig() {
        return this.sideConfig;
    }

    @Nullable
    public IEnergyStorage getExternalStorage(@Nullable Direction side) {
        int index;
        if (!this.isEnergyPresent(side)) {
            return null;
        }
        int n = index = side != null ? side.ordinal() : Direction.values().length;
        if (this.externalAdapters[index] == null) {
            this.externalAdapters[index] = new ExternalAdapter(side);
        }
        return this.externalAdapters[index];
    }

    private final class ExternalAdapter
    implements IEnergyStorage {
        @Nullable
        private final Direction side;

        public ExternalAdapter(Direction side) {
            this.side = side;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return Util.safeInt(AbstractEnergyStorage.this.extractEnergy(maxExtract, simulate, this.side));
        }

        public int getEnergyStored() {
            return Util.safeInt(AbstractEnergyStorage.this.getEnergy().getStored());
        }

        public int getMaxEnergyStored() {
            return Ints.saturatedCast((long)AbstractEnergyStorage.this.getEnergy().getMaxEnergyStored());
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return Util.safeInt(AbstractEnergyStorage.this.receiveEnergy(maxReceive, simulate, this.side));
        }

        public boolean canReceive() {
            return AbstractEnergyStorage.this.canReceiveEnergy(this.side);
        }

        public boolean canExtract() {
            return AbstractEnergyStorage.this.canExtractEnergy(this.side);
        }
    }
}

