/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores;

import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    static final ModConfigSpec commonSpec;
    public static final Common COMMON;
    static final ModConfigSpec serverSpec;
    public static final Server SERVER;
    public static int finiteAmountBase;
    public static int maxExtractorsPerVein;
    public static int veinFinderNear;
    public static int veinFinderFar;
    public static int veinFinderCd;
    public static boolean defaultInfinite;

    public static void load(ModConfig modConfig) {
        if (modConfig.getType() == ModConfig.Type.SERVER) {
            finiteAmountBase = (Integer)Config.SERVER.finiteAmountBase.get();
            defaultInfinite = (Boolean)Config.SERVER.defaultInfinite.get();
            maxExtractorsPerVein = (Integer)Config.SERVER.maxExtractorsPerVein.get();
            veinFinderNear = (Integer)Config.SERVER.veinFinderNear.get();
            veinFinderFar = (Integer)Config.SERVER.veinFinderFar.get();
            veinFinderCd = (Integer)Config.SERVER.veinFinderCd.get();
        }
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(Server::new);
        serverSpec = (ModConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public ModConfigSpec.IntValue finiteAmountBase;
        public ModConfigSpec.BooleanValue defaultInfinite;
        public ModConfigSpec.IntValue maxExtractorsPerVein;
        public ModConfigSpec.IntValue veinFinderNear;
        public ModConfigSpec.IntValue veinFinderFar;
        public ModConfigSpec.IntValue veinFinderCd;

        private Server(ModConfigSpec.Builder builder) {
            builder.comment(new String[]{"IMPORTANT NOTICE:", "You can add more entries using KubeJS", "https://github.com/tom5454/Create-Ore-Excavation#kubejs"}).define("importantInfo", true);
            this.finiteAmountBase = builder.comment("Finite vein base amount").translation("config.coe.finiteAmountBase").defineInRange("finiteAmountBase", 1000, 1, Integer.MAX_VALUE);
            this.defaultInfinite = builder.comment("Veins infinite by default").translation("config.coe.defaultInfinite").define("defaultInfinite", true);
            this.maxExtractorsPerVein = builder.comment("Max number of extractor per ore vein, Set to 0 for infinite").translation("config.coe.maxExtractorsPerVein").defineInRange("maxExtractorsPerVein", 0, 0, 64);
            this.veinFinderNear = builder.comment("Vein Finder 'Found Nearby' range in chunks").translation("config.coe.veinFinderNear").defineInRange("veinFinderNear", 1, 1, 8);
            this.veinFinderFar = builder.comment("Vein Finder accuracy for 'Found traces of ...'").translation("config.coe.veinFinderFar").defineInRange("veinFinderFar", 25, 1, 1000);
            this.veinFinderCd = builder.comment("Vein Finder use cooldown in ticks").translation("config.coe.veinFinderCd").defineInRange("veinFinderCd", 100, 10, 1000);
        }
    }

    public static class Common {
        public Common(ModConfigSpec.Builder builder) {
            builder.comment(new String[]{"IMPORTANT NOTICE:", "THIS IS ONLY THE COMMON CONFIG. It does not contain all the values adjustable for Create Ore Excavation", "The settings have been moved to createoreexcavation-server.toml", "That file is PER WORLD, meaning you have to go into 'saves/<world name>/serverconfig' to adjust it. Those changes will then only apply for THAT WORLD.", "You can then take that config file and put it in the 'defaultconfigs' folder to make it apply automatically to all NEW worlds you generate FROM THERE ON.", "This may appear confusing to many of you, but it is a new sensible way to handle configuration, because the server configuration is synced when playing multiplayer."}).define("importantInfo", true);
        }
    }
}

