/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.jei;

import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.tom.createores.Registration;
import com.tom.createores.jei.AnimatedBlock;
import com.tom.createores.jei.ExcavatingCategory;
import com.tom.createores.jei.JEIRecipes;
import com.tom.createores.recipe.DrillingRecipe;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.createmod.catnip.layout.LayoutHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class DrillingCategory
extends ExcavatingCategory<DrillingRecipe> {
    public DrillingCategory() {
        this.block = new AnimatedBlock(Registration.DRILL_BLOCK.getDefaultState(), 11.0f);
        this.icon = new DoubleItemIcon(() -> Registration.DRILL_BLOCK.asStack(), () -> new ItemStack((ItemLike)Registration.NORMAL_DRILL_ITEM.get()));
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.coe.recipe.drilling");
    }

    public RecipeType<RecipeHolder<DrillingRecipe>> getRecipeType() {
        return JEIRecipes.DRILLING;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<DrillingRecipe> recipe, IFocusGroup focuses) {
        super.setRecipe(builder, recipe, focuses);
        int xOffset = this.getWidth() / 2;
        int yOffset = 86;
        this.layoutOutput((DrillingRecipe)recipe.value()).forEach(layoutEntry -> ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, xOffset + layoutEntry.posX() + 1, yOffset + layoutEntry.posY() + 1).setBackground(CreateRecipeCategory.getRenderedSlot((ProcessingOutput)layoutEntry.output()), -1, -1).addItemStack(layoutEntry.output().getStack())).addRichTooltipCallback(CreateRecipeCategory.addStochasticTooltip((ProcessingOutput)layoutEntry.output())));
    }

    private List<LayoutEntry> layoutOutput(DrillingRecipe recipe) {
        int size = recipe.getOutput().size();
        ArrayList<LayoutEntry> positions = new ArrayList<LayoutEntry>(size);
        LayoutHelper layout = LayoutHelper.centeredHorizontal((int)size, (int)1, (int)18, (int)18, (int)1);
        for (ProcessingOutput result : recipe.getOutput()) {
            positions.add(new LayoutEntry(result, layout.getX(), layout.getY()));
            layout.next();
        }
        return positions;
    }

    private record LayoutEntry(ProcessingOutput output, int posX, int posY) {
    }
}

