/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.corelib.death.Death;
import de.maxhenkel.gravestone.entity.DummyPlayer;
import de.maxhenkel.gravestone.gui.PageList;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;

public class ObituaryScreen
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"gravestone", (String)"textures/gui/info.png");
    protected static final int TEXTURE_X = 163;
    protected static final int TEXTURE_Y = 165;
    protected static final int ITEM_OFFSET_LEFT = 40;
    protected static final int OFFSET_LEFT = 7;
    protected static final int OFFSET_RIGHT = 14;
    protected static final int ITEM_SIZE_OFFSET_LEFT = 15;
    private DummyPlayer player;
    private Death death;
    private Button buttonPrev;
    private Button buttonNext;
    private int page;
    private PageList pageList;
    private int guiLeft;
    private int guiTop;

    public ObituaryScreen(Death death) {
        super((Component)Component.translatable((String)"gui.obituary.title"));
        this.death = death;
        this.page = 0;
        this.pageList = new PageList(death.getAllItems(), this);
    }

    protected void init() {
        super.init();
        this.guiLeft = (this.width - 163) / 2;
        this.guiTop = (this.height - 165) / 2;
        int left = (this.width - 163) / 2;
        this.buttonPrev = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.gravestone.prev"), button -> {
            --this.page;
            if (this.page < 0) {
                this.page = 0;
            }
            this.checkButtons();
        }).bounds(left, 190, 75, 20).build());
        this.buttonNext = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.gravestone.next"), button -> {
            ++this.page;
            if (this.page > this.pageList.getPages()) {
                this.page = this.pageList.getPages();
            }
            this.checkButtons();
        }).bounds(left + 163 - 75, 190, 75, 20).build());
        this.buttonPrev.active = false;
        if (this.pageList.getPages() <= 0) {
            this.buttonNext.active = false;
        }
    }

    protected void checkButtons() {
        this.buttonPrev.active = this.page > 0;
        this.buttonNext.active = this.page < this.pageList.getPages();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int left = (this.width - 163) / 2;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(GUI_TEXTURE, left, 20, 0, 0, 163, 165);
        if (this.page == 0) {
            this.drawFirstPage(guiGraphics, mouseX, mouseY);
        } else if (this.page > 0 && this.pageList.getPages() >= this.page - 1) {
            this.pageList.drawPage(guiGraphics, this.page - 1, mouseX, mouseY);
        }
    }

    public void drawFirstPage(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.drawCentered(guiGraphics, this.font, Component.translatable((String)"gui.obituary.title").withStyle(ChatFormatting.UNDERLINE), this.width / 2, 30, ChatFormatting.BLACK.getColor());
        int height = 50;
        if (this.minecraft.options.advancedItemTooltips) {
            this.drawLeft(guiGraphics, Component.translatable((String)"gui.obituary.id").append(":").withStyle(ChatFormatting.BLACK), height);
            this.drawRight(guiGraphics, Component.literal((String)this.death.getId().toString()).withStyle(ChatFormatting.DARK_GRAY), height, 0.5f);
            height += 13;
        }
        this.drawLeft(guiGraphics, Component.translatable((String)"gui.obituary.name").append(":").withStyle(ChatFormatting.BLACK), height);
        this.drawRight(guiGraphics, Component.literal((String)this.death.getPlayerName()).withStyle(ChatFormatting.DARK_GRAY), height);
        this.drawLeft(guiGraphics, Component.translatable((String)"gui.obituary.dimension").append(":").withStyle(ChatFormatting.BLACK), height += 13);
        this.drawRight(guiGraphics, Component.literal((String)this.death.getDimension().split(":")[1]).withStyle(ChatFormatting.DARK_GRAY), height);
        this.drawLeft(guiGraphics, Component.translatable((String)"gui.obituary.time").append(":").withStyle(ChatFormatting.BLACK), height += 13);
        MutableComponent date = GraveUtils.getDate(this.death.getTimestamp());
        if (date != null) {
            this.drawRight(guiGraphics, date.withStyle(ChatFormatting.DARK_GRAY), height);
        } else {
            this.drawRight(guiGraphics, Component.literal((String)"N/A").withStyle(ChatFormatting.DARK_GRAY), height);
        }
        this.drawLeft(guiGraphics, Component.translatable((String)"gui.obituary.location").append(":").withStyle(ChatFormatting.BLACK), height += 13);
        BlockPos pos = this.death.getBlockPos();
        this.drawRight(guiGraphics, Component.literal((String)("X: " + pos.getX())).withStyle(ChatFormatting.DARK_GRAY), height);
        this.drawRight(guiGraphics, Component.literal((String)("Y: " + pos.getY())).withStyle(ChatFormatting.DARK_GRAY), height += 13);
        this.drawRight(guiGraphics, Component.literal((String)("Z: " + pos.getZ())).withStyle(ChatFormatting.DARK_GRAY), height += 13);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.player == null) {
            this.player = new DummyPlayer(this.minecraft.level, new GameProfile(this.death.getPlayerUUID(), this.death.getPlayerName()), this.death.getEquipment(), this.death.getModel());
        }
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(this.guiLeft + 81 - 25), (int)(this.guiTop + 70), (int)(this.guiLeft + 81 + 25), (int)(this.guiTop + 140), (int)30, (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)this.player);
        if (this.minecraft.options.advancedItemTooltips && mouseX >= this.guiLeft + 7 && mouseX <= this.guiLeft + 163 - 7 && mouseY >= 50) {
            Objects.requireNonNull(this.font);
            if (mouseY <= 50 + 9) {
                guiGraphics.renderTooltip(this.font, Collections.singletonList(Component.translatable((String)"gui.obituary.copy_id").getVisualOrderText()), mouseX, mouseY);
            }
        }
    }

    public boolean mouseClicked(double x, double y, int clickType) {
        if (this.minecraft.options.advancedItemTooltips && this.page == 0 && x >= (double)(this.guiLeft + 7) && x <= (double)(this.guiLeft + 163 - 7) && y >= 50.0) {
            Objects.requireNonNull(this.font);
            if (y <= (double)(50 + 9)) {
                this.minecraft.keyboardHandler.setClipboard(this.death.getId().toString());
                MutableComponent deathID = ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"message.gravestone.death_id")).withStyle(style -> style.applyFormat(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/restore @s " + this.death.getId().toString() + " replace")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)this.death.getId().toString()))));
                this.minecraft.player.sendSystemMessage((Component)Component.translatable((String)"message.gravestone.copied", (Object[])new Object[]{deathID}));
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                this.minecraft.setScreen(null);
            }
        }
        return super.mouseClicked(x, y, clickType);
    }

    public void drawCentered(GuiGraphics guiGraphics, Font fontRenderer, MutableComponent text, int x, int y, int color) {
        guiGraphics.drawString(fontRenderer, text.getVisualOrderText(), (float)(x - fontRenderer.width((FormattedText)text) / 2), (float)y, color, false);
    }

    public void drawItem(GuiGraphics guiGraphics, MutableComponent string, int height) {
        guiGraphics.drawString(this.font, string.getVisualOrderText(), this.guiLeft + 40, height, ChatFormatting.BLACK.getColor().intValue(), false);
    }

    public void drawItemSize(GuiGraphics guiGraphics, MutableComponent string, int height) {
        guiGraphics.drawString(this.font, string.getVisualOrderText(), this.guiLeft + 15, height, ChatFormatting.BLACK.getColor().intValue(), false);
    }

    public void drawLeft(GuiGraphics guiGraphics, MutableComponent string, int height) {
        guiGraphics.drawString(this.font, string.getVisualOrderText(), this.guiLeft + 7, height, ChatFormatting.BLACK.getColor().intValue(), false);
    }

    public void drawRight(GuiGraphics guiGraphics, MutableComponent string, int height) {
        this.drawRight(guiGraphics, string, height, 1.0f);
    }

    public void drawRight(GuiGraphics guiGraphics, MutableComponent string, int height, float scale) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(scale, scale, 1.0f);
        float f = 1.0f / scale;
        int strWidth = this.font.width((FormattedText)string);
        Objects.requireNonNull(this.font);
        Objects.requireNonNull(this.font);
        float spacing = (9.0f * f - 9.0f) / 2.0f;
        guiGraphics.drawString(this.font, string.getVisualOrderText(), ((float)(this.guiLeft + 163) - (float)strWidth * scale - 14.0f) * f, (float)height * f + spacing, ChatFormatting.BLACK.getColor().intValue(), false);
        guiGraphics.pose().popPose();
    }

    public Font getFontRenderer() {
        return this.font;
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }
}

