/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.mixin.profiler;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.WeakHashMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockEntityRenderDispatcher.class})
public class MixinBlockEntityRenderDispatcher {
    @Unique
    private static final WeakHashMap<Class<?>, String> names = new WeakHashMap();

    @Inject(at={@At(value="HEAD")}, method={"setupAndRender"})
    private static <T extends BlockEntity> void onRender(BlockEntityRenderer<T> renderer, T blockEntity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, CallbackInfo info) {
        String name;
        Level level = blockEntity.getLevel();
        if (level != null && !(name = names.computeIfAbsent(renderer.getClass(), Class::getSimpleName)).isEmpty()) {
            level.getProfiler().push(name);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"setupAndRender"})
    private static <T extends BlockEntity> void afterRender(BlockEntityRenderer<T> renderer, T blockEntity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, CallbackInfo info) {
        String name;
        Level level = blockEntity.getLevel();
        if (level != null && !(name = names.computeIfAbsent(renderer.getClass(), Class::getSimpleName)).isEmpty()) {
            level.getProfiler().pop();
        }
    }
}

