/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DynamicOps;
import io.wispforest.lavender.book.Book;
import io.wispforest.lavender.book.BookLoader;
import io.wispforest.lavender.book.LavenderBookItem;
import io.wispforest.lavender.client.StructureOverlayRenderer;
import io.wispforest.lavender.structure.LavenderStructures;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1799;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_6903;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import net.minecraft.class_9336;

public class LavenderCommands {
    private static final SimpleCommandExceptionType NO_SUCH_BOOK = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"No such book is loaded"));
    private static final SuggestionProvider<FabricClientCommandSource> LOADED_BOOKS = (context, builder) -> class_2172.method_9257(BookLoader.loadedBooks().stream().map(Book::id), (SuggestionsBuilder)builder);

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        private static final SimpleCommandExceptionType NO_SUCH_STRUCTURE = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"No such structure is loaded"));
        private static final SuggestionProvider<FabricClientCommandSource> STRUCTURE_INFO = (context, builder) -> class_2172.method_9264(LavenderStructures.loadedStructures().stream().map(class_2960::toString), (SuggestionsBuilder)builder);

        private static int executeGetLavenderBook(CommandContext<FabricClientCommandSource> context, boolean forceDynamicBook) throws CommandSyntaxException {
            Book book = BookLoader.get((class_2960)context.getArgument("book_id", class_2960.class));
            if (book == null) {
                throw NO_SUCH_BOOK.create();
            }
            class_1799 stack = forceDynamicBook ? LavenderBookItem.createDynamic(book) : LavenderBookItem.itemOf(book);
            String command = "/give @s " + String.valueOf(class_7923.field_41178.method_10221((Object)stack.method_7909()));
            class_6903 ops = ((FabricClientCommandSource)context.getSource()).getWorld().method_30349().method_57093((DynamicOps)class_2509.field_11560);
            String components = stack.method_57380().method_57846().stream().flatMap(entry -> {
                class_9331 componentType = (class_9331)entry.getKey();
                class_2960 typeId = class_7923.field_49658.method_10221((Object)componentType);
                if (typeId == null) {
                    return Stream.empty();
                }
                Optional componentOptional = (Optional)entry.getValue();
                if (componentOptional.isPresent()) {
                    class_9336 component = class_9336.method_57945((class_9331)componentType, componentOptional.get());
                    return component.method_57943((DynamicOps)ops).result().stream().map(value -> String.valueOf(typeId) + "=" + String.valueOf(value));
                }
                return Stream.of("!" + String.valueOf(typeId));
            }).collect(Collectors.joining(String.valueOf(',')));
            if (!components.isEmpty()) {
                command = command + "[" + components + "]";
            }
            if (stack.method_7947() > 1) {
                command = command + " " + stack.method_7947();
            }
            String jAvAsE = command;
            ((FabricClientCommandSource)context.getSource()).getClient().method_18858(() -> ((FabricClientCommandSource)context.getSource()).getClient().method_1507((class_437)new class_408(jAvAsE)));
            return 0;
        }

        public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 access) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"get-lavender-book").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"book_id", (ArgumentType)class_2232.method_9441()).suggests(LOADED_BOOKS).executes(context -> Client.executeGetLavenderBook((CommandContext<FabricClientCommandSource>)context, false))).then(ClientCommandManager.argument((String)"force_dynamic_book", (ArgumentType)BoolArgumentType.bool()).executes(context -> Client.executeGetLavenderBook((CommandContext<FabricClientCommandSource>)context, BoolArgumentType.getBool((CommandContext)context, (String)"force_dynamic_book"))))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"structure-overlay").then(ClientCommandManager.literal((String)"clear-all").executes(context -> {
                StructureOverlayRenderer.clearOverlays();
                return 0;
            }))).then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"structure", (ArgumentType)class_2232.method_9441()).suggests(STRUCTURE_INFO).executes(context -> {
                class_2960 structureId = (class_2960)context.getArgument("structure", class_2960.class);
                if (LavenderStructures.get(structureId) == null) {
                    throw NO_SUCH_STRUCTURE.create();
                }
                StructureOverlayRenderer.addPendingOverlay(structureId);
                return 0;
            }))));
        }
    }
}

