/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FluidOffer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

class PowderSnowCauldronInteraction
implements FaucetTarget.BlState,
FaucetSource.BlState {
    PowderSnowCauldronInteraction() {
    }

    @Override
    public FluidOffer getProvidedFluid(Level level, BlockPos pos, Direction dir, BlockState source) {
        if (source.is(Blocks.POWDER_SNOW_CAULDRON)) {
            return FluidOffer.of((Holder<SoftFluid>)MLBuiltinSoftFluids.POWDERED_SNOW.getHolder(level), (int)((Integer)source.getValue((Property)LayeredCauldronBlock.LEVEL)));
        }
        return null;
    }

    @Override
    public void drain(Level level, BlockPos pos, Direction dir, BlockState source, int amount) {
        int am = (Integer)source.getValue((Property)LayeredCauldronBlock.LEVEL) - amount;
        if (am <= 0) {
            level.setBlock(pos, Blocks.CAULDRON.defaultBlockState(), 3);
        } else {
            level.setBlockAndUpdate(pos, (BlockState)source.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(am)));
        }
    }

    @Override
    public Integer fill(Level level, BlockPos pos, BlockState state, FluidOffer fluidOffer) {
        if (state.is(Blocks.CAULDRON) && fluidOffer.fluid().is(MLBuiltinSoftFluids.POWDERED_SNOW)) {
            int minAmount = fluidOffer.minAmount();
            int am = Math.min(minAmount, 3);
            level.setBlockAndUpdate(pos, (BlockState)Blocks.POWDER_SNOW_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(am)));
            return minAmount;
        }
        if (state.is(Blocks.POWDER_SNOW_CAULDRON)) {
            SoftFluidStack fluid = fluidOffer.fluid();
            int minAmount = fluidOffer.minAmount();
            if (fluid.is(MLBuiltinSoftFluids.POWDERED_SNOW) && (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) < 3) {
                int space = 3 - (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL);
                int amount = fluid.getCount();
                int am = Math.min(amount, space);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf((Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) + am)));
                return Math.max(minAmount, am);
            }
            if (fluid.is(MLBuiltinSoftFluids.WATER)) {
                level.setBlockAndUpdate(pos, Blocks.WATER_CAULDRON.withPropertiesOf(state));
                return minAmount;
            }
            return 0;
        }
        return null;
    }
}

