/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.ClockBlock;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ClockBlockTile
extends BlockEntity {
    private int power = 0;
    private float roll = 0.0f;
    private float prevRoll = 0.0f;
    private float targetRoll = 0.0f;
    private float sRoll = 0.0f;
    private float sPrevRoll = 0.0f;
    private float sTargetRoll = 0.0f;
    private float rota;
    private float sRota;

    public ClockBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.CLOCK_BLOCK_TILE.get(), pos, state);
    }

    public int getPower() {
        return this.power;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.power = tag.getInt("Power");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("Power", this.power);
    }

    public void updateInitialTime(Level level, BlockState state, BlockPos pos) {
        int time = (int)(level.getDayTime() % 24000L);
        this.updateTargetTime(time, level, state, pos);
        this.roll = this.targetRoll;
        this.prevRoll = this.targetRoll;
        this.sRoll = this.sTargetRoll;
        this.sPrevRoll = this.sTargetRoll;
    }

    public static int calculateHour(int time) {
        return Mth.clamp((int)(time / 1000), (int)0, (int)24);
    }

    private static int calculateMinute(int time) {
        return Mth.clamp((int)(time % 1000 / 20), (int)0, (int)50);
    }

    protected void updateTargetTime(int time, Level level, BlockState state, BlockPos pos) {
        int minute = ClockBlockTile.calculateMinute(time);
        int hour = ClockBlockTile.calculateHour(time);
        if (!level.isClientSide) {
            if (level.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)) {
                int p;
                if (hour != (Integer)state.getValue((Property)ClockBlock.HOUR)) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)ClockBlock.HOUR, (Comparable)Integer.valueOf(hour)), 3);
                }
                if ((p = Mth.clamp((int)(time / 1500), (int)0, (int)15)) != this.power) {
                    this.power = p;
                    level.updateNeighbourForOutputSignal(pos, this.getBlockState().getBlock());
                }
                this.level.playSound(null, this.worldPosition, (minute % 2 == 0 ? ModSounds.CLOCK_TICK_1 : ModSounds.CLOCK_TICK_2).get(), SoundSource.BLOCKS, 0.08f, MthUtils.nextWeighted((RandomSource)level.random, (float)0.1f) + 0.95f);
            }
        } else {
            this.targetRoll = hour * 30 % 360;
            this.sTargetRoll = ((float)minute * 7.2f + 180.0f) % 360.0f;
        }
    }

    public static void tick(Level level, BlockPos pPos, BlockState pState, ClockBlockTile tile) {
        int dayTime = (int)(level.getDayTime() % 24000L);
        int time = level.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT) ? dayTime : (int)(level.getGameTime() % 24000L);
        boolean canReadTime = ClockBlock.canReadTime(level);
        if (canReadTime && time % 20 == 0) {
            tile.updateTargetTime(dayTime, level, pState, pPos);
        }
        if (!level.isClientSide) {
            return;
        }
        tile.prevRoll = tile.roll;
        if (canReadTime) {
            float r;
            if (tile.roll != tile.targetRoll) {
                r = (tile.roll + 8.0f) % 360.0f;
                if (r >= tile.targetRoll && r <= tile.targetRoll + 8.0f) {
                    r = tile.targetRoll;
                }
                tile.roll = r;
            }
            tile.sPrevRoll = tile.sRoll;
            if (tile.sRoll != tile.sTargetRoll) {
                r = (tile.sRoll + 8.0f) % 360.0f;
                if (r >= tile.sTargetRoll && r <= tile.sTargetRoll + 8.0f) {
                    r = tile.sTargetRoll;
                }
                tile.sRoll = r;
            }
        } else {
            if (time % 5 == 0) {
                float d = level.random.nextFloat() * 360.0f;
                float d0 = d - tile.roll;
                tile.targetRoll = d0 = Mth.positiveModulo((float)(d0 + 180.0f), (float)360.0f) - 180.0f;
                d = level.random.nextFloat() * 360.0f;
                d0 = d - tile.sRoll;
                tile.sTargetRoll = d0 = Mth.positiveModulo((float)(d0 + 180.0f), (float)360.0f) - 180.0f;
            }
            tile.rota += (float)((double)tile.targetRoll * 0.1);
            tile.rota *= 0.8f;
            tile.roll = Mth.positiveModulo((float)(tile.roll + tile.rota), (float)360.0f);
            tile.sPrevRoll = tile.sRoll;
            tile.sRota += (float)((double)tile.sTargetRoll * 0.1);
            tile.sRota *= 0.8f;
            tile.sRoll = Mth.positiveModulo((float)(tile.sRoll + tile.sRota), (float)360.0f);
        }
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)ClockBlock.FACING);
    }

    public float getRollS(float partialTicks) {
        return Mth.rotLerp((float)partialTicks, (float)this.sPrevRoll, (float)this.sRoll);
    }

    public float getRoll(float partialTicks) {
        return Mth.rotLerp((float)partialTicks, (float)this.prevRoll, (float)this.roll);
    }
}

