/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import net.mehvahdjukaar.moonlight.api.entity.ImprovedFallingBlockEntity;
import net.mehvahdjukaar.supplementaries.common.block.blocks.UrnBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.UrnBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FallingUrnEntity
extends ImprovedFallingBlockEntity {
    public FallingUrnEntity(EntityType<FallingUrnEntity> type, Level level) {
        super(type, level);
    }

    public FallingUrnEntity(Level level, BlockPos pos, BlockState blockState) {
        super(ModEntities.FALLING_URN.get(), level, pos, blockState, false);
        this.setHurtsEntities(1.0f, 20);
    }

    public static FallingUrnEntity fall(Level level, BlockPos pos, BlockState state) {
        FallingUrnEntity entity = new FallingUrnEntity(level, pos, state);
        level.setBlock(pos, state.getFluidState().createLegacyBlock(), 3);
        level.addFreshEntity((Entity)entity);
        return entity;
    }

    public boolean isAttackable() {
        return true;
    }

    @Nullable
    public ItemEntity spawnAtLocation(ItemLike pItem) {
        this.shatter();
        return null;
    }

    public boolean causeFallDamage(float height, float amount, DamageSource source) {
        boolean r = super.causeFallDamage(height, amount, source);
        if (this.getDeltaMovement().lengthSqr() > 0.25) {
            this.shatter();
            this.setCancelDrop(true);
            this.discard();
        } else if (!this.isSilent()) {
            this.level().levelEvent(1045, this.blockPosition(), 0);
        }
        return r;
    }

    private void shatter() {
        BlockState state = this.getBlockState();
        CompoundTag tag = this.blockData;
        UrnBlockTile tile = null;
        BlockPos pos = this.blockPosition();
        if (tag != null && !tag.isEmpty()) {
            tile = new UrnBlockTile(pos, state);
            tile.loadWithComponents(tag, (HolderLookup.Provider)this.level().registryAccess());
        }
        Level level = this.level();
        Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)tile, null, (ItemStack)ItemStack.EMPTY);
        level.levelEvent(null, 2001, pos, Block.getId((BlockState)state));
        UrnBlock.spawnExtraBrokenParticles(state, pos, level);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        this.shatter();
        this.discard();
        return true;
    }
}

