/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.blocks.entity.BasePedestalBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5575;
import net.minecraft.class_5819;

public abstract class DualPedestalBlockEntity
extends BasePedestalBlockEntity {
    private static final class_5819 RANDOM = class_5819.method_43047();
    private static final double SHINY_CHANCE = 0.02;
    protected static final int SEARCH_RADIUS = 10;
    protected final class_1792 firstItem;
    protected final class_1792 secondItem;
    protected final String summonName;
    protected final String regularMessagePrefix;
    protected final String shinyMessagePrefix;
    protected final class_124 regularPrefixFormatting;
    protected final class_124 regularMessageFormatting;
    protected final class_124 shinyFormatting;

    public DualPedestalBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, class_1792 firstItem, class_1792 secondItem, String summonName, String regularMessagePrefix, String shinyMessagePrefix, class_124 regularPrefixFormatting, class_124 regularMessageFormatting) {
        super(type, pos, state);
        this.firstItem = firstItem;
        this.secondItem = secondItem;
        this.summonName = summonName;
        this.regularMessagePrefix = regularMessagePrefix;
        this.shinyMessagePrefix = shinyMessagePrefix;
        this.regularPrefixFormatting = regularPrefixFormatting;
        this.regularMessageFormatting = regularMessageFormatting;
        this.shinyFormatting = class_124.field_1065;
    }

    @Override
    public boolean handleSpecialAction(class_1657 player, class_1799 stack) {
        if (stack.method_31574(this.firstItem) || stack.method_31574(this.secondItem)) {
            class_1937 class_19372;
            if (this.hasPlayerUsed(player)) {
                if (!this.field_11863.field_9236) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"This pedestal has already been used by you.").method_27692(class_124.field_1061), true);
                }
                return false;
            }
            if (!this.field_11863.field_9236 && (class_19372 = this.field_11863) instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                List<DualPedestalBlockEntity> otherPedestals = this.findOtherPedestals(serverWorld);
                for (DualPedestalBlockEntity otherPedestal : otherPedestals) {
                    class_1799 otherStack = otherPedestal.method_5438(0);
                    if (!this.areComplementaryItems(stack, otherStack)) continue;
                    return this.activateDualPedestals(player, serverWorld, otherPedestal);
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"You sense that another pedestal must be activated nearby...").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
            }
            return false;
        }
        return false;
    }

    protected boolean areComplementaryItems(class_1799 firstStack, class_1799 secondStack) {
        return firstStack.method_31574(this.firstItem) && secondStack.method_31574(this.secondItem) || firstStack.method_31574(this.secondItem) && secondStack.method_31574(this.firstItem);
    }

    protected List<DualPedestalBlockEntity> findOtherPedestals(class_3218 world) {
        class_238 searchBox = new class_238((double)(this.field_11867.method_10263() - 10), (double)(this.field_11867.method_10264() - 10), (double)(this.field_11867.method_10260() - 10), (double)(this.field_11867.method_10263() + 10), (double)(this.field_11867.method_10264() + 10), (double)(this.field_11867.method_10260() + 10));
        ArrayList<DualPedestalBlockEntity> foundPedestals = new ArrayList<DualPedestalBlockEntity>();
        for (int x = this.field_11867.method_10263() - 10; x <= this.field_11867.method_10263() + 10; ++x) {
            for (int y = this.field_11867.method_10264() - 10; y <= this.field_11867.method_10264() + 10; ++y) {
                for (int z = this.field_11867.method_10260() - 10; z <= this.field_11867.method_10260() + 10; ++z) {
                    class_2586 be;
                    class_2338 checkPos = new class_2338(x, y, z);
                    if (checkPos.equals((Object)this.field_11867) || (be = world.method_8321(checkPos)) == null || !(be instanceof DualPedestalBlockEntity) || be.getClass() != this.getClass()) continue;
                    foundPedestals.add((DualPedestalBlockEntity)be);
                }
            }
        }
        return foundPedestals;
    }

    protected boolean activateDualPedestals(class_1657 player, class_3218 world, DualPedestalBlockEntity otherPedestal) {
        try {
            this.markPlayerUsed(player);
            otherPedestal.markPlayerUsed(player);
            this.method_5448();
            otherPedestal.method_5448();
            class_2338 thisPos = this.field_11867.method_10084();
            class_2338 otherPos = otherPedestal.field_11867.method_10084();
            class_2338 spawnPos = new class_2338((thisPos.method_10263() + otherPos.method_10263()) / 2, Math.max(thisPos.method_10264(), otherPos.method_10264()), (thisPos.method_10260() + otherPos.method_10260()) / 2);
            boolean isShiny = RANDOM.method_43058() < 0.02;
            this.createSummonArmorStand(world, spawnPos, isShiny);
            this.spawnEffects(world, spawnPos);
            if (isShiny) {
                player.method_7353((class_2561)class_2561.method_43470((String)this.shinyMessagePrefix).method_27695(new class_124[]{this.shinyFormatting, class_124.field_1067}).method_10852((class_2561)class_2561.method_43470((String)("A SHINY " + this.getPokemonName() + " appears!")).method_27695(new class_124[]{this.shinyFormatting, class_124.field_1067})), false);
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)this.regularMessagePrefix).method_27695(new class_124[]{this.regularPrefixFormatting, class_124.field_1067}).method_10852((class_2561)class_2561.method_43470((String)(this.getPokemonName() + " appears!")).method_27695(new class_124[]{this.regularMessageFormatting, class_124.field_1067})), false);
            }
            this.giveReward(player);
            return true;
        }
        catch (Exception e) {
            System.err.println("Error activating dual pedestals: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    protected void createSummonArmorStand(class_3218 world, class_2338 pos, boolean isShiny) {
        class_1531 stand = new class_1531(class_1299.field_6131, (class_1937)world);
        stand.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, 0.0f, 0.0f);
        stand.method_5665((class_2561)class_2561.method_43470((String)(this.summonName + (isShiny ? "_shiny" : ""))));
        stand.method_5880(false);
        stand.method_5648(true);
        stand.method_5875(true);
        world.method_8649((class_1297)stand);
        world.method_8503().execute(() -> this.spawnPokemon(world, pos, isShiny));
    }

    protected abstract void spawnEffects(class_3218 var1, class_2338 var2);

    protected abstract String getPokemonName();

    protected void giveReward(class_1657 player) {
    }

    protected void spawnPokemon(class_3218 world, class_2338 pos, boolean isShiny) {
        try {
            String armorStandName = this.summonName + (isShiny ? "_shiny" : "");
            List armorStands = world.method_18023((class_5575)class_1299.field_6131, new class_238((double)(pos.method_10263() - 30), (double)(pos.method_10264() - 30), (double)(pos.method_10260() - 30), (double)(pos.method_10263() + 30), (double)(pos.method_10264() + 30), (double)(pos.method_10260() + 30)), entity -> entity.method_16914() && entity.method_5797() != null && entity.method_5797().getString().equals(armorStandName));
            if (armorStands.isEmpty()) {
                System.err.println("Could not find armor stand with name: " + armorStandName);
                return;
            }
            class_1531 stand = (class_1531)armorStands.get(0);
            class_2338 spawnPos = stand.method_24515();
            PokemonProperties properties = new PokemonProperties();
            properties.setSpecies(this.getPokemonName().toLowerCase());
            properties.setLevel(Integer.valueOf(60));
            if (isShiny) {
                properties.setShiny(Boolean.valueOf(true));
            }
            Pokemon pokemon = properties.create();
            PokemonEntity entity2 = new PokemonEntity((class_1937)world, pokemon, CobblemonEntities.POKEMON);
            entity2.method_5808((double)spawnPos.method_10263(), (double)spawnPos.method_10264(), (double)spawnPos.method_10260(), 0.0f, 0.0f);
            world.method_8649((class_1297)entity2);
        }
        catch (Exception e) {
            System.err.println("Error spawning " + this.getPokemonName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }
}

