/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.data;

import github.jorgaomc.LegendaryMonuments;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_7225;

public class KeyItemsDataManager
extends class_18 {
    private static final String KEY_ITEMS_DATA_KEY = "legendarymonuments_key_items";
    private static final int STORAGE_SIZE = 63;
    private final Map<UUID, class_1277> playerKeyItems = new HashMap<UUID, class_1277>();

    public static boolean hasKeyItem(class_1657 player, class_1792 item) {
        try {
            if (player == null || item == null) {
                return false;
            }
            class_1937 class_19372 = player.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                KeyItemsDataManager mgr = KeyItemsDataManager.getOrCreate(serverWorld);
                class_1277 inv = mgr.getKeyItemsInventory(player);
                for (int i = 0; i < inv.method_5439(); ++i) {
                    class_1799 s = inv.method_5438(i);
                    if (s.method_7960() || s.method_7909() != item) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.debug("hasKeyItem(PlayerEntity, Item) failed: {}", (Object)e.getMessage());
        }
        return false;
    }

    public static boolean hasKeyItem(UUID uuid, class_1792 item, class_3218 world) {
        if (uuid == null || item == null || world == null) {
            return false;
        }
        try {
            KeyItemsDataManager mgr = KeyItemsDataManager.getOrCreate(world);
            Field field = KeyItemsDataManager.class.getDeclaredField("playerKeyItems");
            field.setAccessible(true);
            Map map = (Map)field.get((Object)mgr);
            class_1277 inv = (class_1277)map.get(uuid);
            if (inv == null) {
                return false;
            }
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1799 s = inv.method_5438(i);
                if (s.method_7960() || s.method_7909() != item) continue;
                return true;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.debug("hasKeyItem(UUID, Item, World) failed: {}", (Object)e.getMessage());
        }
        return false;
    }

    public class_1277 getKeyItemsInventory(class_1657 player) {
        UUID playerUuid = player.method_5667();
        return this.playerKeyItems.computeIfAbsent(playerUuid, uuid -> new class_1277(63));
    }

    public void savePlayerKeyItems(class_1657 player, class_1263 inventory) {
        if (player == null || inventory == null) {
            LegendaryMonuments.LOGGER.error("SAVE FAILED: player or inventory is null");
            return;
        }
        UUID playerUuid = player.method_5667();
        class_1277 playerInventory = new class_1277(63);
        int copiedItems = 0;
        for (int i = 0; i < Math.min(inventory.method_5439(), 63); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            try {
                class_1799 copy = stack.method_7972();
                playerInventory.method_5447(i, copy);
                ++copiedItems;
                continue;
            }
            catch (Exception e) {
                LegendaryMonuments.LOGGER.error("Error copying item at slot {}: {}", (Object)i, (Object)e.getMessage());
            }
        }
        this.playerKeyItems.put(playerUuid, playerInventory);
        this.method_80();
        class_1277 verified = this.playerKeyItems.get(playerUuid);
        if (verified != null) {
            int verifiedCount = this.countNonEmptySlots(verified);
            if (verifiedCount != copiedItems) {
                LegendaryMonuments.LOGGER.error("VERIFICATION FAILED: Expected {}, but found {}", (Object)copiedItems, (Object)verifiedCount);
            }
        } else {
            LegendaryMonuments.LOGGER.error("VERIFICATION FAILED: Could not retrieve stored inventory!");
        }
    }

    private int countNonEmptySlots(class_1277 inventory) {
        int count = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (inventory.method_5438(i).method_7960()) continue;
            ++count;
        }
        return count;
    }

    public static KeyItemsDataManager getOrCreate(class_3218 world) {
        try {
            class_26 stateManager = world.method_17983();
            Supplier<KeyItemsDataManager> supplier = KeyItemsDataManager::new;
            class_18.class_8645 factory = new class_18.class_8645(supplier, KeyItemsDataManager::fromNbt, null);
            return (KeyItemsDataManager)stateManager.method_17924(factory, KEY_ITEMS_DATA_KEY);
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error in getOrCreate: {}", (Object)e.getMessage(), (Object)e);
            return new KeyItemsDataManager();
        }
    }

    public static KeyItemsDataManager fromNbt(class_2487 nbt, class_7225.class_7874 wrapperLookup) {
        KeyItemsDataManager manager = new KeyItemsDataManager();
        if (!nbt.method_10573("players", 10)) {
            return manager;
        }
        class_2487 playersData = nbt.method_10562("players");
        for (String uuidString : playersData.method_10541()) {
            try {
                UUID playerUuid = UUID.fromString(uuidString);
                if (!playersData.method_10573(uuidString, 9)) continue;
                class_2499 inventoryData = playersData.method_10554(uuidString, 10);
                class_1277 inventory = new class_1277(63);
                for (int i = 0; i < inventoryData.size(); ++i) {
                    class_2487 itemNbt = inventoryData.method_10602(i);
                    try {
                        int slot;
                        if (!itemNbt.method_10573("Slot", 3) || (slot = itemNbt.method_10550("Slot")) < 0 || slot >= 63) continue;
                        class_2487 cleanItemNbt = itemNbt.method_10553();
                        cleanItemNbt.method_10551("Slot");
                        class_1799 stack = class_1799.method_57360((class_7225.class_7874)wrapperLookup, (class_2520)cleanItemNbt).orElse(class_1799.field_8037);
                        if (stack.method_7960()) continue;
                        inventory.method_5447(slot, stack);
                        continue;
                    }
                    catch (Exception e) {
                        LegendaryMonuments.LOGGER.error("Error parsing item NBT at index {}: {}", (Object)i, (Object)e.getMessage());
                    }
                }
                manager.playerKeyItems.put(playerUuid, inventory);
            }
            catch (Exception e) {
                LegendaryMonuments.LOGGER.error("Error loading data for player {}: {}", (Object)uuidString, (Object)e.getMessage());
            }
        }
        return manager;
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 wrapperLookup) {
        class_2487 playersData = new class_2487();
        for (Map.Entry<UUID, class_1277> entry : this.playerKeyItems.entrySet()) {
            String uuid = entry.getKey().toString();
            class_1277 inventory = entry.getValue();
            class_2499 list = new class_2499();
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 stack = inventory.method_5438(i);
                if (stack.method_7960()) continue;
                try {
                    if (stack.method_7909() == null) continue;
                    class_2487 itemNbt = new class_2487();
                    boolean encoded = false;
                    try {
                        stack.method_57376(wrapperLookup, (class_2520)itemNbt);
                        if (!itemNbt.method_33133() && itemNbt.method_10545("id")) {
                            encoded = true;
                        }
                    }
                    catch (Exception e) {
                        LegendaryMonuments.LOGGER.error("Encode method failed for slot {}: {}", (Object)i, (Object)e.getMessage());
                    }
                    if (!encoded) {
                        try {
                            String itemId = stack.method_41409().method_40230().map(key -> key.method_29177().toString()).orElse("minecraft:air");
                            itemNbt.method_10582("id", itemId);
                            itemNbt.method_10569("count", stack.method_7947());
                            encoded = true;
                        }
                        catch (Exception e) {
                            LegendaryMonuments.LOGGER.error("Manual encoding also failed for slot {}: {}", (Object)i, (Object)e.getMessage());
                        }
                    }
                    if (!encoded || itemNbt.method_33133()) continue;
                    itemNbt.method_10569("Slot", i);
                    list.add((Object)itemNbt);
                    continue;
                }
                catch (Exception e) {
                    LegendaryMonuments.LOGGER.error("Error encoding item at slot {} for player {}: {}", new Object[]{i, uuid, e.getMessage()});
                }
            }
            if (list.isEmpty()) continue;
            playersData.method_10566(uuid, (class_2520)list);
        }
        nbt.method_10566("players", (class_2520)playersData);
        return nbt;
    }
}

