/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.mixin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5575;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public class HoopaPyramidMixin {
    private static final Map<UUID, Integer> playerCooldowns = new HashMap<UUID, Integer>();
    private static final Map<UUID, Long> lastExecutionTimes = new HashMap<UUID, Long>();
    private static final int FUNCTION_COOLDOWN = 40;
    private static final String TEMPLELOCK1_MARKER_NAME = "templelock1";
    private static final String TEMPLELOCK2_MARKER_NAME = "templelock2";
    private static final String TEMPLELOCK3_MARKER_NAME = "templelock3";
    private static final String UNBREAKABLE_TEMPLE_MARKER_NAME = "unbreakabletemple";
    private static final String HOOPA_BOSS_MARKER_NAME = "hoopaboss";
    private static final String HOOPA_QUESTIONS_MARKER_NAME = "question1";

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onPlayerTick(CallbackInfo info) {
        class_3222 player = (class_3222)this;
        UUID playerId = player.method_5667();
        class_3218 world = player.method_51469();
        if (playerCooldowns.containsKey(playerId)) {
            int cooldown = playerCooldowns.get(playerId);
            if (cooldown > 0) {
                playerCooldowns.put(playerId, cooldown - 1);
            } else {
                playerCooldowns.remove(playerId);
            }
        }
        if (!this.isOnCooldown(playerId)) {
            boolean functionExecuted = false;
            if (this.hasNamedArmorStandWithinDistance(world, player, TEMPLELOCK1_MARKER_NAME, 8.0)) {
                this.executeFunction(player, "legendarymonuments:templelock1");
                functionExecuted = true;
            } else if (this.hasNamedArmorStandWithinDistance(world, player, TEMPLELOCK2_MARKER_NAME, 8.0)) {
                this.executeFunction(player, "legendarymonuments:templelock2");
                functionExecuted = true;
            } else if (this.hasNamedArmorStandWithinDistance(world, player, TEMPLELOCK3_MARKER_NAME, 20.0)) {
                this.executeFunction(player, "legendarymonuments:templelock3");
                functionExecuted = true;
            } else if (this.hasNamedArmorStandWithinDistance(world, player, HOOPA_QUESTIONS_MARKER_NAME, 15.0)) {
                this.executeFunction(player, "legendarymonuments:hoopaquestions");
                functionExecuted = true;
            } else if (this.hasNamedArmorStandWithinDistance(world, player, HOOPA_BOSS_MARKER_NAME, 15.0)) {
                this.executeHoopaBossCommands(player);
                functionExecuted = true;
            }
            if (this.hasNamedArmorStandWithinDistance(world, player, UNBREAKABLE_TEMPLE_MARKER_NAME, 50.0)) {
                this.executeFunction(player, "legendarymonuments:unbreakabletemple");
            }
            if (functionExecuted) {
                playerCooldowns.put(playerId, 40);
            }
        }
    }

    private boolean isOnCooldown(UUID playerId) {
        return playerCooldowns.containsKey(playerId) && playerCooldowns.get(playerId) > 0;
    }

    private boolean hasNamedArmorStandWithinDistance(class_3218 world, class_3222 player, String name, double distance) {
        try {
            class_2338 playerPos = player.method_24515();
            class_238 searchBox = new class_238((double)playerPos.method_10263() - distance, (double)playerPos.method_10264() - distance, (double)playerPos.method_10260() - distance, (double)playerPos.method_10263() + distance, (double)playerPos.method_10264() + distance, (double)playerPos.method_10260() + distance);
            List armorStands = world.method_18023((class_5575)class_1299.field_6131, searchBox, entity -> entity.method_16914() && entity.method_5797() != null && entity.method_5797().getString().equals(name));
            return !armorStands.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void executeHoopaBossCommands(class_3222 player) {
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return;
        }
        class_2168 source = new class_2168((class_2165)server, player.method_19538(), player.method_5802(), player.method_51469(), 4, "Server", player.method_5476(), server, (class_1297)player).method_9217();
        try {
            String[] commands = new String[]{"execute at @e[name=hoopaboss,type=armor_stand] run pokespawn hoopa djinn_state=unbound shiny lvl=70 uncatchable held_item=legendarymonuments:temple_key no_ai", "execute at @e[name=hoopaboss,type=armor_stand] run attribute @e[type=cobblemon:pokemon,distance=..5,limit=1,nbt={Pokemon:{Species:\"cobblemon:hoopa\"}}] minecraft:generic.scale base set 0.64", "execute at @e[name=hoopaboss,type=armor_stand] run effect give @e[type=cobblemon:pokemon,sort=nearest,limit=1] minecraft:resistance infinite 99 true", "execute at @e[name=hoopaboss,type=armor_stand] run data modify entity @e[type=cobblemon:pokemon,limit=1,sort=nearest] PersistenceRequired set value 1b", "execute at @e[name=hoopaboss,type=armor_stand] run tp @e[type=cobblemon:pokemon,distance=..20,nbt={Pokemon:{Species:\"cobblemon:hoopa\"}}] @e[type=armor_stand,name=\"hoopaboss\",limit=1]", "execute at @e[name=hoopaboss,type=armor_stand] if entity @e[type=cobblemon:pokemon,distance=..3,nbt={Pokemon:{Species:\"cobblemon:hoopa\"}}] run kill @e[type=armor_stand,name=hoopaboss,distance=..10]"};
            this.scheduleCommandSequence(server, source, commands, 0);
        }
        catch (Exception e) {
            System.err.println("Failed to execute Hoopa boss commands: " + e.getMessage());
        }
    }

    private void scheduleCommandSequence(MinecraftServer server, class_2168 source, String[] commands, int index) {
        if (index >= commands.length) {
            return;
        }
        try {
            server.method_3734().method_44252(source, commands[index]);
            if (index + 1 < commands.length) {
                server.execute(() -> {
                    try {
                        Thread.sleep(500L);
                        this.scheduleCommandSequence(server, source, commands, index + 1);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
            }
        }
        catch (Exception e) {
            System.err.println("Failed to execute Hoopa boss command " + index + ": " + e.getMessage());
        }
    }

    private void executeFunction(class_3222 player, String functionId) {
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return;
        }
        class_2168 source = new class_2168((class_2165)server, player.method_19538(), player.method_5802(), player.method_51469(), 4, "Server", player.method_5476(), server, (class_1297)player).method_9217();
        try {
            server.method_3734().method_44252(source, "function " + functionId);
        }
        catch (Exception e) {
            System.err.println("Failed to execute function " + functionId + ": " + e.getMessage());
        }
    }
}

