/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import snownee.jade.JadeClient;
import snownee.jade.gui.MultilineTooltip;
import snownee.jade.gui.config.BelowOrAboveListEntryTooltipPositioner;
import snownee.jade.gui.config.NotUglyEditBox;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.gui.config.OptionsNav;
import snownee.jade.gui.config.value.OptionValue;

public abstract class BaseOptionsScreen
extends Screen {
    protected final Screen parent;
    private final Set<GuiEventListener> entryWidgets = Sets.newIdentityHashSet();
    public Button saveButton;
    protected Runnable saver;
    protected Runnable canceller;
    protected OptionsList options;
    protected OptionsNav optionsNav;
    private NotUglyEditBox searchBox;

    public BaseOptionsScreen(Screen parent, Component title) {
        super(title);
        this.parent = parent;
    }

    protected void init() {
        Objects.requireNonNull(this.minecraft);
        double scroll = this.options == null ? 0.0 : this.options.getScrollAmount();
        super.init();
        this.entryWidgets.clear();
        if (this.options != null) {
            this.options.removed();
        }
        this.options = this.createOptions();
        this.options.setX(120);
        this.optionsNav = new OptionsNav(this.options, 120, this.height - 32 - 18, 18, 18);
        this.searchBox = new NotUglyEditBox(this, this.font, 0, 0, 120, 18, this.searchBox, (Component)Component.translatable((String)"gui.jade.search")){

            @Override
            @Nullable
            public ComponentPath nextFocusPath(FocusNavigationEvent event) {
                FocusNavigationEvent.ArrowNavigation arrow;
                if (event instanceof FocusNavigationEvent.ArrowNavigation && (arrow = (FocusNavigationEvent.ArrowNavigation)event).direction().getAxis() == ScreenAxis.HORIZONTAL) {
                    return null;
                }
                if (event instanceof FocusNavigationEvent.InitialFocus) {
                    return null;
                }
                return super.nextFocusPath(event);
            }
        };
        this.searchBox.setBordered(false);
        this.searchBox.setHint((Component)Component.translatable((String)"gui.jade.search.hint"));
        this.searchBox.responder = s -> {
            this.options.updateSearch((String)s);
            this.optionsNav.refresh();
        };
        this.searchBox.paddingLeft = 12;
        this.searchBox.paddingTop = 6;
        this.searchBox.paddingRight = 18;
        this.addRenderableWidget((GuiEventListener)this.optionsNav);
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        this.addRenderableWidget((GuiEventListener)this.options);
        this.searchBox.responder.accept(this.searchBox.getValue());
        this.options.forceSetScrollAmount(scroll);
        this.saveButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.jade.save_and_quit").withStyle(style -> style.withColor(-4589878)), w -> {
            if (this.options.invalidEntry == null) {
                this.options.save();
                this.saver.run();
                this.minecraft.setScreen(this.parent);
            } else {
                this.changeFocus(ComponentPath.path((GuiEventListener)this.options.invalidEntry.getFirstWidget(), (ContainerEventHandler[])new ContainerEventHandler[]{this.options.invalidEntry, this.options, this}));
                this.options.ensureVisible(this.options.invalidEntry);
            }
        }).bounds(this.width - 100, this.height - 25, 90, 20).build());
        if (this.canceller != null) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, w -> this.onClose()).bounds(this.saveButton.getX() - 95, this.height - 25, 90, 20).build());
        }
        this.options.updateSaveState();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        OptionsList.Entry entry;
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        OptionsList.Entry entry2 = entry = this.options.isMouseOver(mouseX, mouseY) ? this.options.getEntryAt(mouseX, mouseY) : null;
        if (entry != null) {
            int valueX = entry.getTextX(this.options.getRowWidth());
            if (mouseX >= valueX && mouseX < valueX + entry.getTextWidth()) {
                ArrayList descs = Lists.newArrayListWithExpectedSize((int)3);
                descs.addAll(entry.getDescription());
                if (BaseOptionsScreen.hasShiftDown()) {
                    descs.addAll(entry.getDescriptionOnShift());
                }
                if (!descs.isEmpty()) {
                    descs.replaceAll(BaseOptionsScreen::processBuiltInVariables);
                    this.setTooltipForNextRenderPass(MultilineTooltip.create(descs), new BelowOrAboveListEntryTooltipPositioner(this.options, entry), false);
                }
            }
            if (entry instanceof OptionValue) {
                OptionValue optionValue = (OptionValue)entry;
                if (optionValue.serverFeature) {
                    int x = entry.getTextX(this.options.getRowWidth()) + entry.getTextWidth() + 1;
                    int y = this.options.getRowTop(this.options.children().indexOf((Object)entry)) + 7;
                    if (mouseX >= x && mouseX < x + 4 && mouseY >= y && mouseY < y + 4) {
                        this.setTooltipForNextRenderPass(Tooltip.create((Component)Component.translatable((String)"gui.jade.server_feature")), new BelowOrAboveListEntryTooltipPositioner(this.options, entry), false);
                    }
                }
            }
        }
    }

    public static Component processBuiltInVariables(Component component) {
        MutableComponent keyName;
        ArrayList objects;
        if (component.getString().contains("${SHOW_DETAILS}")) {
            objects = Lists.newArrayListWithExpectedSize((int)3);
            objects.add(Component.translatable((String)"key.jade.show_details"));
            if (JadeClient.showDetails.getName().contains("alternative")) {
                objects.add(InputConstants.getKey((String)"key.keyboard.left.shift").getDisplayName().copy().withStyle(ChatFormatting.AQUA));
            }
            if (!JadeClient.showDetails.isUnbound()) {
                objects.add(JadeClient.showDetails.getTranslatedKeyMessage().copy().withStyle(ChatFormatting.AQUA));
            }
            keyName = Component.translatable((String)("config.jade.key_name_n_bind_" + (objects.size() - 1)), (Object[])objects.toArray());
            component = BaseOptionsScreen.replaceVariables(component, "${SHOW_DETAILS}", (Component)keyName);
        }
        if (component.getString().contains("${SHOW_OVERLAY}")) {
            objects = Lists.newArrayListWithExpectedSize((int)3);
            objects.add(Component.translatable((String)JadeClient.showOverlay.getName()));
            if (!JadeClient.showOverlay.isUnbound()) {
                objects.add(JadeClient.showOverlay.getTranslatedKeyMessage().copy().withStyle(ChatFormatting.AQUA));
            }
            keyName = Component.translatable((String)("config.jade.key_name_n_bind_" + (objects.size() - 1)), (Object[])objects.toArray());
            component = BaseOptionsScreen.replaceVariables(component, "${SHOW_OVERLAY}", (Component)keyName);
        }
        return component;
    }

    private static Component replaceVariables(Component component, String source, Component replacement) {
        MutableComponent newComponent = Component.empty().withStyle(component.getStyle());
        for (Component part : component.toFlatList()) {
            String partString = part.getString();
            if (partString.contains(source)) {
                boolean first = true;
                for (String s : StringUtils.splitByWholeSeparatorPreserveAllTokens((String)partString, (String)source)) {
                    if (first) {
                        first = false;
                    } else {
                        newComponent.append(replacement);
                    }
                    if (s.isEmpty()) continue;
                    newComponent.append((Component)Component.literal((String)s));
                }
                continue;
            }
            newComponent.append(part);
        }
        return newComponent;
    }

    public abstract OptionsList createOptions();

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.optionsNav.isMouseOver(mouseX, mouseY)) {
            return this.optionsNav.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
        }
        return this.options.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public void onClose() {
        if (this.canceller != null) {
            this.canceller.run();
        }
        Objects.requireNonNull(this.minecraft).setScreen(this.parent);
    }

    public void removed() {
        this.options.removed();
    }

    public <T extends GuiEventListener & NarratableEntry> T addEntryWidget(T widget) {
        this.entryWidgets.add(widget);
        return (T)super.addWidget(widget);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int p_94697_) {
        boolean onList = this.options.isMouseOver(mouseX, mouseY);
        for (GuiEventListener guieventlistener : this.children()) {
            if (!onList && this.entryWidgets.contains(guieventlistener) || !guieventlistener.mouseClicked(mouseX, mouseY, p_94697_)) continue;
            this.setFocused(guieventlistener);
            if (p_94697_ == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    public boolean shouldCloseOnEsc() {
        return this.options.selectedKey == null;
    }

    public Optional<GuiEventListener> getChildAt(double mouseX, double mouseY) {
        boolean onList = this.options != null && this.options.isMouseOver(mouseX, mouseY);
        for (GuiEventListener guieventlistener : this.children()) {
            if (!onList && this.entryWidgets.contains(guieventlistener) || !guieventlistener.isMouseOver(mouseX, mouseY)) continue;
            return Optional.of(guieventlistener);
        }
        return Optional.empty();
    }

    public OptionsNav getOptionsNav() {
        return this.optionsNav;
    }
}

