/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.cobblemon.events;

import com.cobblemon.mod.common.api.events.pokemon.HeldItemEvent;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HeldItemUpdateEventListener {
    static ModConfigs MythsAndLegendsConfig = MythsAndLegends.getConfigManager().getConfig();

    public static void onHeldItemUpdate(HeldItemEvent event) {
        MythsAndLegends.getLogger().debug("Held item updated for event: {}", (Object)event);
    }

    public static void onHeldItemPost(HeldItemEvent event) {
        if (HeldItemUpdateEventListener.MythsAndLegendsConfig.form_changes) {
            MythsAndLegends.getLogger().debug("Form changes enabled, processing held item post for event: {}", (Object)event);
            Pokemon pokemon = event.getPokemon();
            if (pokemon == null || pokemon.getSpecies() == null || pokemon.getOwnerUUID() == null) {
                MythsAndLegends.getLogger().debug("pokemon, pokemon.getSpecies, or pokemon.getOwnerUUID is null. Aborting onHeldItemPost.");
                return;
            }
            String pokemonSpeciesName = pokemon.getSpecies().getName();
            ItemStack heldItemStack = event.getPokemon().heldItem();
            MythsAndLegends.getLogger().debug("Processing held item post for Pok\u00e9mon: {}, Held Item: {}", (Object)pokemonSpeciesName, (Object)heldItemStack.getItem());
            if (List.of("dialga", "palkia", "giratina", "zacian", "zamazenta").contains(pokemonSpeciesName.toLowerCase())) {
                List forms = pokemon.getSpecies().getForms();
                MythsAndLegends.getLogger().debug("Found relevant Pok\u00e9mon species: {}", (Object)pokemonSpeciesName);
                Item heldItem = heldItemStack.getItem();
                if (HeldItemUpdateEventListener.isMatchingHeldItem(heldItem, "adamant_orb") && pokemonSpeciesName.equalsIgnoreCase("dialga")) {
                    MythsAndLegends.getLogger().debug("Dialga holding Adamant Orb, changing form to Origin.");
                    HeldItemUpdateEventListener.changeForm(pokemon, forms, "Origin", Collections.singleton("origin"));
                } else if (HeldItemUpdateEventListener.isMatchingHeldItem(heldItem, "lustrous_orb") && pokemonSpeciesName.equalsIgnoreCase("palkia")) {
                    MythsAndLegends.getLogger().debug("Palkia holding Lustrous Orb, changing form to Origin.");
                    HeldItemUpdateEventListener.changeForm(pokemon, forms, "Origin", Collections.singleton("origin"));
                } else if (HeldItemUpdateEventListener.isMatchingHeldItem(heldItem, "griseous_orb") && pokemonSpeciesName.equalsIgnoreCase("giratina")) {
                    MythsAndLegends.getLogger().debug("Giratina holding Griseous Orb, changing form to Origin.");
                    HeldItemUpdateEventListener.changeForm(pokemon, forms, "Origin", Collections.singleton("origin"));
                } else if (HeldItemUpdateEventListener.isMatchingHeldItem(heldItem, "rusted_sword") && pokemonSpeciesName.equalsIgnoreCase("zacian")) {
                    MythsAndLegends.getLogger().debug("Zacian holding Rusted Sword, changing form to Crowned.");
                    HeldItemUpdateEventListener.changeForm(pokemon, forms, "Crowned", Collections.singleton("crowned"));
                } else if (HeldItemUpdateEventListener.isMatchingHeldItem(heldItem, "rusted_shield") && pokemonSpeciesName.equalsIgnoreCase("zamazenta")) {
                    MythsAndLegends.getLogger().debug("Zamazenta holding Rusted Shield, changing form to Crowned.");
                    HeldItemUpdateEventListener.changeForm(pokemon, forms, "Crowned", Collections.singleton("crowned"));
                } else {
                    MythsAndLegends.getLogger().debug("No relevant held item, reverting {} to Normal form.", (Object)pokemonSpeciesName);
                    HeldItemUpdateEventListener.changeForm(pokemon, forms, "Normal", Collections.emptySet());
                }
            }
        }
    }

    private static boolean isMatchingHeldItem(Item heldItem, String itemName) {
        ResourceLocation itemIdentifier = ResourceLocation.fromNamespaceAndPath((String)"myths_and_legends", (String)itemName);
        return ((Item)BuiltInRegistries.ITEM.get(itemIdentifier)).asItem() == heldItem;
    }

    private static void changeForm(Pokemon pokemon, List<FormData> forms, String formName, Set<String> tags) {
        for (FormData form : forms) {
            if (!form.getName().equalsIgnoreCase(formName)) continue;
            pokemon.setForm(form);
            MythsAndLegends.getLogger().debug("Changed Pok\u00e9mon form to: {}", (Object)formName);
            return;
        }
        MythsAndLegends.getLogger().debug("Form {} not found for species {}", (Object)formName, (Object)pokemon.getSpecies().getName());
    }
}

