/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.cobblemon.mixins;

import com.cobblemon.mod.common.api.spawning.condition.AppendageCondition;
import com.cobblemon.mod.common.api.spawning.condition.SpawningCondition;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.detail.EntitySpawnResult;
import com.cobblemon.mod.common.api.spawning.detail.SingleEntitySpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.cobblemon.mixins.SpawningConditionMixin;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.MythsAndLegendsConditions;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.items.ItemCondition;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.keyitem.KeyItemConditions;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.keyitem.custom.CustomKeyItemCondition;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.keyitem.custom.CustomSecondaryItemCondition;
import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import com.github.d0ctorleon.mythsandlegends.utils.DebtUtils;
import com.github.d0ctorleon.mythsandlegends.utils.InventoryUtils;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerDataUtils;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SingleEntitySpawnAction.class})
public abstract class SingleEntitySpawnActionMixin {
    @Unique
    ModConfigs MythsAndLegends$config = MythsAndLegends.getConfigManager().getConfig();
    @Unique
    SpawningContext MythsAndLegends$ctx;
    @Unique
    SpawnDetail MythsAndLegends$detail;

    @Inject(method={"<init>(Lcom/cobblemon/mod/common/api/spawning/context/SpawningContext;Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;)V"}, at={@At(value="RETURN")})
    private void onInit(SpawningContext ctx, SpawnDetail detail, CallbackInfo ci) {
        this.MythsAndLegends$ctx = ctx;
        this.MythsAndLegends$detail = detail;
        MythsAndLegends.getLogger().debug("SingleEntitySpawnActionMixin initialized");
    }

    @Inject(method={"run()Lcom/cobblemon/mod/common/api/spawning/detail/EntitySpawnResult;"}, at={@At(value="INVOKE", target="Lcom/cobblemon/mod/common/api/spawning/context/SpawningContext;getWorld()Lnet/minecraft/server/level/ServerLevel;", ordinal=0, shift=At.Shift.AFTER)})
    private void afterSpawnEntity(CallbackInfoReturnable<EntitySpawnResult> cir) {
        SpawningContext ctx = ((SingleEntitySpawnAction)this).getCtx();
        SpawnDetail detail = ((SingleEntitySpawnAction)this).getDetail();
        this.MythsAndLegends$processSpawnAction(ctx, detail);
        MythsAndLegends.getLogger().debug("SingleEntitySpawnActionMixin run");
    }

    @Unique
    private void MythsAndLegends$processSpawnAction(SpawningContext ctx, SpawnDetail detail) {
        MythsAndLegends.getLogger().debug("SingleEntitySpawnActionMixin processSpawnAction-Started");
        Spawner spawner = ctx.getSpawner();
        if (spawner instanceof PlayerSpawner) {
            PlayerSpawner playerSpawner = (PlayerSpawner)spawner;
            ServerPlayer player = MythsAndLegendsConditions.getPlayerFromUUID(ctx.getWorld(), playerSpawner.getUuid());
            for (SpawningCondition condition : detail.getConditions()) {
                if (!(condition instanceof SpawningConditionMixin)) continue;
                SpawningConditionMixin conditionMixin = (SpawningConditionMixin)condition;
                List<AppendageCondition> appendages = conditionMixin.getAppendages();
                this.MythsAndLegends$filterAppendageConditions(appendages, player);
            }
        }
        MythsAndLegends.getLogger().debug("SingleEntitySpawnActionMixin processSpawnAction-Ended");
    }

    @Unique
    private void MythsAndLegends$filterAppendageConditions(List<AppendageCondition> appendages, ServerPlayer player) {
        MythsAndLegends.getLogger().debug("SingleEntitySpawnActionMixin filterAppendageConditions-Started");
        boolean itemConditionMet = false;
        for (AppendageCondition appendage : appendages) {
            CustomSecondaryItemCondition customSecondaryItemCondition;
            if (appendage instanceof ItemCondition) {
                ItemCondition itemCondition = (ItemCondition)appendage;
                if (itemCondition.getItemConditionIdentifier() == null) continue;
                itemConditionMet = true;
                MythsAndLegends.getLogger().debug("SingleEntitySpawnActionMixin filterAppendageConditions-ItemConditionMet");
                continue;
            }
            if (!(appendage instanceof CustomSecondaryItemCondition) || (customSecondaryItemCondition = (CustomSecondaryItemCondition)appendage).getItemConditionIdentifier() == null) continue;
            itemConditionMet = true;
            MythsAndLegends.getLogger().debug("SingleEntitySpawnActionMixin filterAppendageConditions-CustomSecondaryItemConditionMet");
        }
        this.MythsAndLegends$processConditions(appendages, player, itemConditionMet);
        MythsAndLegends.getLogger().debug("SingleEntitySpawnActionMixin filterAppendageConditions-Ended");
    }

    @Unique
    private void MythsAndLegends$processConditions(List<AppendageCondition> appendages, ServerPlayer player, boolean itemConditionMet) {
        MythsAndLegends.getLogger().debug("SingleEntitySpawnActionMixin processConditions-Started");
        boolean configConsume = this.MythsAndLegends$config.consume_items_on_successful_spawn;
        boolean consumeOnlyItems = this.MythsAndLegends$config.ignore_key_items;
        for (AppendageCondition appendage : appendages) {
            if (appendage instanceof CustomKeyItemCondition) {
                CustomKeyItemCondition customKeyItemCondition = (CustomKeyItemCondition)appendage;
                List<CustomKeyItemCondition.CustomConditionItem> customItems = customKeyItemCondition.getItemConditions();
                if (customItems == null || customItems.isEmpty()) continue;
                for (CustomKeyItemCondition.CustomConditionItem item : customItems) {
                    if (item == null || !configConsume && !item.consume || consumeOnlyItems && itemConditionMet && !item.consume) continue;
                    this.MythsAndLegends$removeCustomItemFromPlayer(player, item.id, item.count);
                }
                continue;
            }
            if (appendage instanceof CustomSecondaryItemCondition) {
                CustomSecondaryItemCondition customStoneCondition = (CustomSecondaryItemCondition)appendage;
                CustomKeyItemCondition.CustomConditionItem item = customStoneCondition.getItemConditionIdentifier();
                if (item == null || !configConsume && !item.consume) continue;
                this.MythsAndLegends$removeCustomItemFromPlayer(player, item.id, item.count);
                continue;
            }
            if (appendage instanceof KeyItemConditions.KeyItem) {
                KeyItemConditions.KeyItem keyItem = (KeyItemConditions.KeyItem)appendage;
                if (!configConsume || keyItem.getItemCondtionIdentifier() == null || itemConditionMet && this.MythsAndLegends$config.ignore_key_items) continue;
                this.MythsAndLegends$removeKeyItemFromPlayer(player, keyItem.getItemCondtionIdentifier().getPath());
                continue;
            }
            if (!(appendage instanceof ItemCondition)) continue;
            ItemCondition itemCondition = (ItemCondition)appendage;
            if (!configConsume || itemCondition.getItemConditionIdentifier() == null) continue;
            this.MythsAndLegends$removeItemFromPlayer(player, itemCondition.getItemConditionIdentifier(), itemCondition.getItemNamespace(), itemCondition.getItemPath());
        }
    }

    @Unique
    private void MythsAndLegends$removeItemFromPlayer(ServerPlayer player, ResourceLocation ItemConditionIdentifier, String itemNamespace, String itemPath) {
        int requiredCount;
        if (ItemConditionIdentifier == null) {
            return;
        }
        ResourceLocation ItemIdentifier = ResourceLocation.fromNamespaceAndPath((String)itemNamespace, (String)itemPath);
        Supplier MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)"mythsandlegends"));
        Registrar items = ((RegistrarManager)MANAGER.get()).get(Registries.ITEM);
        Item item = Objects.requireNonNull((Item)items.get(ItemIdentifier)).asItem();
        if (!InventoryUtils.removeItemFromInventory(player, item, requiredCount = MythsAndLegendsConditions.parseRequiredCount(ItemConditionIdentifier.getPath()), this.MythsAndLegends$config.inventory_check_bundles, this.MythsAndLegends$config.inventory_check_shulker_boxes)) {
            DebtUtils debtUtils = new DebtUtils(Platform.getConfigFolder().resolve("MythsAndLegends"));
            debtUtils.addDebt(player.getUUID(), ItemIdentifier, requiredCount);
        }
        PlayerDataUtils.checkPlayerInventory((Player)player);
    }

    @Unique
    private void MythsAndLegends$removeCustomItemFromPlayer(ServerPlayer player, ResourceLocation customItemId, int count) {
        Supplier MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)"mythsandlegends"));
        Registrar items = ((RegistrarManager)MANAGER.get()).get(Registries.ITEM);
        Item customItem = Objects.requireNonNull((Item)items.get(customItemId)).asItem();
        if (!InventoryUtils.removeItemFromInventory(player, customItem, count, this.MythsAndLegends$config.inventory_check_bundles, this.MythsAndLegends$config.inventory_check_shulker_boxes)) {
            DebtUtils debtUtils = new DebtUtils(Platform.getConfigFolder().resolve("MythsAndLegends"));
            debtUtils.addDebt(player.getUUID(), customItemId, count);
        }
        PlayerDataUtils.checkPlayerInventory((Player)player);
    }

    @Unique
    private void MythsAndLegends$removeKeyItemFromPlayer(ServerPlayer player, String keyItemPath) {
        ResourceLocation keyItemId = ResourceLocation.fromNamespaceAndPath((String)"myths_and_legends", (String)keyItemPath);
        Supplier MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)"mythsandlegends"));
        Registrar items = ((RegistrarManager)MANAGER.get()).get(Registries.ITEM);
        Item keyItem = Objects.requireNonNull((Item)items.get(keyItemId)).asItem();
        if (!InventoryUtils.removeItemFromInventory(player, keyItem, 1, this.MythsAndLegends$config.inventory_check_bundles, this.MythsAndLegends$config.inventory_check_shulker_boxes)) {
            DebtUtils debtUtils = new DebtUtils(Platform.getConfigFolder().resolve("MythsAndLegends"));
            debtUtils.addDebt(player.getUUID(), keyItemId, 1);
        }
        PlayerDataUtils.checkPlayerInventory((Player)player);
    }
}

