/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.events;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import com.github.d0ctorleon.mythsandlegends.utils.FusionData;
import com.github.d0ctorleon.mythsandlegends.utils.FusionRegistry;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerPartyUtils;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.InteractionEvent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InteractionEvents {
    static ModConfigs MythsAndLegendsConfig = MythsAndLegends.getConfigManager().getConfig();

    public InteractionEvents() {
        InteractionEvent.INTERACT_ENTITY.register(this::interactEntity);
        MythsAndLegends.getLogger().info("Interaction Events Registered");
    }

    private EventResult interactEntity(Player player, Entity entity, InteractionHand hand) {
        block4: {
            block6: {
                CompoundTag persistentData;
                List<Pokemon> playerParty;
                Pokemon targetFusionPokemon;
                FusionData fusionData;
                ServerPlayer serverPlayer;
                block5: {
                    PokemonEntity pokemonEntity;
                    String speciesName;
                    if (!InteractionEvents.MythsAndLegendsConfig.form_changes || !(player instanceof ServerPlayer)) break block4;
                    serverPlayer = (ServerPlayer)player;
                    if (player.level().isClientSide || !(entity instanceof PokemonEntity) || (fusionData = FusionRegistry.getFusionData(speciesName = (targetFusionPokemon = (pokemonEntity = (PokemonEntity)entity).getPokemon()).getSpecies().getName())) == null) break block4;
                    ItemStack heldItem = serverPlayer.getItemInHand(hand);
                    if (((Item)BuiltInRegistries.ITEM.get(fusionData.getFusionItem())).asItem() != heldItem.getItem()) break block4;
                    playerParty = PlayerPartyUtils.getPokemonsInPlayerParty(serverPlayer);
                    persistentData = targetFusionPokemon.getPersistentData();
                    if (!persistentData.contains("StoredPokemon")) break block5;
                    if (playerParty.size() > 5) break block6;
                    CompoundTag storedPokemonNbt = persistentData.getCompound("StoredPokemon");
                    RegistryAccess.Frozen registryAccess = Objects.requireNonNull(serverPlayer.getServer()).registryAccess();
                    Pokemon storedPokemon = Pokemon.Companion.loadFromNBT((RegistryAccess)registryAccess, storedPokemonNbt);
                    Cobblemon.INSTANCE.getStorage().getParty(serverPlayer).add(storedPokemon);
                    persistentData.remove("StoredPokemon");
                    targetFusionPokemon.setForcedAspects(Collections.emptySet());
                    targetFusionPokemon.updateAspects();
                    targetFusionPokemon.updateForm();
                    persistentData.remove("CurrentForm");
                    persistentData.remove("Aspects");
                    break block6;
                }
                for (Pokemon partyPokemon : playerParty) {
                    if (!fusionData.getFirstFusionPartner().equalsIgnoreCase(partyPokemon.getSpecies().getName()) && !fusionData.getSecondFusionPartner().equalsIgnoreCase(partyPokemon.getSpecies().getName())) continue;
                    Cobblemon.INSTANCE.getStorage().getParty(serverPlayer).remove(partyPokemon);
                    RegistryAccess.Frozen registryAccess = Objects.requireNonNull(serverPlayer.getServer()).registryAccess();
                    CompoundTag storedPokemonNbt = partyPokemon.saveToNBT((RegistryAccess)registryAccess, new CompoundTag());
                    persistentData.put("StoredPokemon", (Tag)storedPokemonNbt);
                    if (fusionData.getFirstFusionPartner().equalsIgnoreCase(partyPokemon.getSpecies().getName())) {
                        targetFusionPokemon.setForcedAspects(Collections.singleton(fusionData.getFirstForm()));
                        this.setPokemonForm(targetFusionPokemon, fusionData.getFirstForm(), false);
                    } else if (fusionData.getSecondFusionPartner().equalsIgnoreCase(partyPokemon.getSpecies().getName())) {
                        targetFusionPokemon.setForcedAspects(Collections.singleton(fusionData.getSecondForm()));
                        this.setPokemonForm(targetFusionPokemon, fusionData.getSecondForm(), false);
                    }
                    persistentData.putString("CurrentForm", targetFusionPokemon.getForm().getName());
                    ListTag aspectList = new ListTag();
                    targetFusionPokemon.getAspects().forEach(aspect -> aspectList.add((Object)StringTag.valueOf((String)aspect)));
                    persistentData.put("Aspects", (Tag)aspectList);
                    break;
                }
            }
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    private void setPokemonForm(Pokemon pokemon, String formName, boolean isUnfusing) {
        for (FormData formData : pokemon.getSpecies().getForms()) {
            if (!formName.equalsIgnoreCase(formData.getName())) continue;
            pokemon.setForm(formData);
            break;
        }
        if (isUnfusing) {
            pokemon.updateForm();
            pokemon.updateAspects();
        }
    }
}

