/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.events;

import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import dev.architectury.event.events.common.PlayerEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public class PlayerEvents {
    public static final Map<UUID, Integer> playersToProcess = new HashMap<UUID, Integer>();

    public PlayerEvents() {
        PlayerEvent.PLAYER_JOIN.register(this::onPlayerJoin);
        MythsAndLegends.getLogger().info("Player Events Registered");
    }

    private void onPlayerJoin(ServerPlayer player) {
        ModConfigs config = MythsAndLegends.getConfigManager().getConfig();
        if (config.form_changes) {
            int delayTicks = config.join_form_aspect_delay;
            int delaySeconds = delayTicks / 20;
            MutableComponent prefix = Component.literal((String)"[").withStyle(style -> style.withColor(ChatFormatting.WHITE)).append((Component)Component.literal((String)"MythsAndLegends").withStyle(style -> style.withColor(ChatFormatting.DARK_PURPLE))).append((Component)Component.literal((String)"] ").withStyle(style -> style.withColor(ChatFormatting.WHITE)));
            MutableComponent message = Component.literal((String)("Forms and aspects will be applied in " + delaySeconds + " seconds.")).withStyle(style -> style.withColor(ChatFormatting.GRAY));
            MutableComponent finalMessage = prefix.copy().append((Component)message);
            player.sendSystemMessage((Component)finalMessage, false);
            playersToProcess.put(player.getUUID(), delayTicks);
        } else {
            MythsAndLegends.getLogger().debug("Form changes are disabled, no message sent to the player.");
        }
    }
}

