/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.gui;

import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import com.github.d0ctorleon.mythsandlegends.gui.ConfigGuiHandler;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;

public class ConfigGui {
    private static final int INVENTORY_SIZE = 54;

    public void openConfigGui(ServerPlayer player, ModConfigs config) {
        SimpleContainer inventory = new SimpleContainer(54);
        int slotIndex = 0;
        this.setupToggleSetting(inventory, 0, "consume_items_on_successful_spawn", config.consume_items_on_successful_spawn, "Determines if items are consumed on successful spawns. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 1, "ignore_key_items", config.ignore_key_items, "If true, only items are consumed. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 2, "inventory_check_shulker_boxes", config.inventory_check_shulker_boxes, "Scans Shulker Boxes for items. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 3, "inventory_check_bundles", config.inventory_check_bundles, "Scans Bundles for items. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 4, "enable_force_spawning", config.enable_force_spawning, "Force spawns Pokemon. Default: false.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 5, "server_only_mode", config.server_only_mode, "Server-only mode. Default: false.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupCycleSetting(inventory, 6, "force_spawning_spawn_pool", config.force_spawning_spawn_pool, "Spawn pool for force spawning. Default: ultra-rare.", Arrays.asList("common", "uncommon", "rare", "ultra-rare"));
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupCycleSetting(inventory, 7, "inventory_check_interval", Integer.toString(config.inventory_check_interval), "Interval in Minecraft ticks for checking player inventories. Default: 3600.", Arrays.asList("600", "1200", "1800", "3600", "7200", "14400"));
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupCycleSetting(inventory, 8, "force_spawn_item_cooldown", Integer.toString(config.force_spawn_item_cooldown), "Cooldown period (in seconds) after a key item is used for force spawning. Default: 20.", Arrays.asList("10", "20", "30", "60"));
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupCycleSetting(inventory, 18, "force_spawn_check_width", Integer.toString(config.force_spawn_check_width), "The width range for force spawning check. Default: 100.", Arrays.asList("50", "75", "100", "125", "150"));
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupCycleSetting(inventory, 19, "force_spawn_check_height", Integer.toString(config.force_spawn_check_height), "The height range for force spawning check. Default: 50.", Arrays.asList("25", "50", "75", "100"));
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupChatSetting(inventory, 20, "inventory_check_item_list", "List of items for inventory check. Click to add item.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 21, "Broadcast-Feature", config.isBroadcastEnabled, "Toggles broadcasting feature on and off. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 22, "Broadcast", config.broadcast_settings.get((int)0).settingValue, "Toggles Server-wide broadcasting on/off. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 23, "DisplayName", config.broadcast_settings.get((int)1).settingValue, "Displays the name of the Pokemon in the broadcast message. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 24, "Legendarys", config.broadcast_settings.get((int)2).settingValue, "Broadcasts a message when a legendary Pokemon spawns. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 25, "Mythicals", config.broadcast_settings.get((int)3).settingValue, "Broadcasts a message when a mythical Pokemon spawns. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 26, "UltraBeasts", config.broadcast_settings.get((int)4).settingValue, "Broadcasts a message when an Ultra Beast spawns. Default: false.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 36, "Location", config.broadcast_settings.get((int)5).settingValue, "Includes the location in broadcast messages. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 37, "Shiny", config.broadcast_settings.get((int)6).settingValue, "Enables broadcasts about Shiny Status of the Pokemon. Default: false.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 38, "Level", config.broadcast_settings.get((int)7).settingValue, "Includes the level of Pokemon in the broadcast. Default: true.");
        slotIndex = this.adjustSlotIndex(slotIndex + 1);
        this.setupToggleSetting(inventory, 39, "form_changes", config.form_changes, "Enables/Disables Form Changes. Default: true.");
        this.setupCycleSetting(inventory, 40, "join_form_aspect_delay", Integer.toString(config.join_form_aspect_delay), "The delay after a player joins the world till forms&apsects get applied. Default: 100.", Arrays.asList("60", "80", "100", "120", "140"));
        player.openMenu((MenuProvider)new SimpleMenuProvider((syncId, playerInventory, playerEntity) -> new ConfigGuiHandler(syncId, playerEntity, inventory, config), Component.nullToEmpty((String)"MythsAndLegends Settings")));
    }

    private int adjustSlotIndex(int slotIndex) {
        if (slotIndex % 9 == 0) {
            slotIndex += 9;
        }
        return slotIndex;
    }

    private void setupToggleSetting(SimpleContainer inventory, int slot, String settingName, boolean value, String description) {
        ItemStack paper = new ItemStack((ItemLike)Items.PAPER);
        paper.set(DataComponents.CUSTOM_NAME, (Object)Component.nullToEmpty((String)settingName));
        paper.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.nullToEmpty((String)description))));
        ItemStack wool = new ItemStack((ItemLike)(value ? Items.LIME_WOOL : Items.RED_WOOL));
        wool.set(DataComponents.CUSTOM_NAME, (Object)Component.nullToEmpty((String)(value ? "Enabled" : "Disabled")));
        inventory.setItem(slot, paper);
        inventory.setItem(slot + 9, wool);
    }

    private void setupCycleSetting(SimpleContainer inventory, int slot, String settingName, String currentValue, String description, List<String> possibleValues) {
        ItemStack paper = new ItemStack((ItemLike)Items.PAPER);
        paper.set(DataComponents.CUSTOM_NAME, (Object)Component.nullToEmpty((String)settingName));
        paper.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.nullToEmpty((String)description))));
        ItemStack wool = new ItemStack((ItemLike)Items.PURPLE_WOOL);
        wool.set(DataComponents.CUSTOM_NAME, (Object)Component.nullToEmpty((String)currentValue));
        inventory.setItem(slot, paper);
        inventory.setItem(slot + 9, wool);
    }

    private void setupChatSetting(SimpleContainer inventory, int slot, String settingName, String description) {
        ItemStack paper = new ItemStack((ItemLike)Items.PAPER);
        paper.set(DataComponents.CUSTOM_NAME, (Object)Component.nullToEmpty((String)settingName));
        paper.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.nullToEmpty((String)description))));
        ItemStack wool = new ItemStack((ItemLike)Items.ORANGE_WOOL);
        wool.set(DataComponents.CUSTOM_NAME, (Object)Component.nullToEmpty((String)"Click to Add Item"));
        inventory.setItem(slot, paper);
        inventory.setItem(slot + 9, wool);
    }
}

