/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.loot;

import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.items.Items;
import com.github.d0ctorleon.mythsandlegends.loot.LootTableEntry;
import com.github.d0ctorleon.mythsandlegends.loot.LootTableItemConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.event.events.common.LootEvent;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;

public class LootTableModifier {
    private static final Gson GSON = new GsonBuilder().create();
    private static final List<ResourceLocation> DEFAULT_LOOT_TABLES = Arrays.asList(ResourceLocation.parse((String)"minecraft:chests/abandoned_mineshaft"), ResourceLocation.parse((String)"minecraft:chests/ancient_city"), ResourceLocation.parse((String)"minecraft:chests/ancient_city_ice_box"), ResourceLocation.parse((String)"minecraft:chests/bastion_treasure"), ResourceLocation.parse((String)"minecraft:chests/bastion_bridge"), ResourceLocation.parse((String)"minecraft:chests/bastion_hoglin_stable"), ResourceLocation.parse((String)"minecraft:chests/bastion_other"), ResourceLocation.parse((String)"minecraft:chests/buried_treasure"), ResourceLocation.parse((String)"minecraft:chests/desert_pyramid"), ResourceLocation.parse((String)"minecraft:chests/end_city_treasure"), ResourceLocation.parse((String)"minecraft:chests/igloo_chest"), ResourceLocation.parse((String)"minecraft:chests/jungle_temple"), ResourceLocation.parse((String)"minecraft:chests/nether_bridge"), ResourceLocation.parse((String)"minecraft:chests/pillager_outpost"), ResourceLocation.parse((String)"minecraft:chests/ruined_portal"), ResourceLocation.parse((String)"minecraft:chests/simple_dungeon"), ResourceLocation.parse((String)"minecraft:chests/shipwreck_map"), ResourceLocation.parse((String)"minecraft:chests/shipwreck_supply"), ResourceLocation.parse((String)"minecraft:chests/shipwreck_treasure"), ResourceLocation.parse((String)"minecraft:chests/stronghold_corridor"), ResourceLocation.parse((String)"minecraft:chests/stronghold_crossing"), ResourceLocation.parse((String)"minecraft:chests/stronghold_library"), ResourceLocation.parse((String)"minecraft:chests/underwater_ruin_big"), ResourceLocation.parse((String)"minecraft:chests/underwater_ruin_small"), ResourceLocation.parse((String)"minecraft:chests/woodland_mansion"), ResourceLocation.parse((String)"minecraft:gameplay/cat_morning_gift"), ResourceLocation.parse((String)"minecraft:gameplay/hero_of_the_village/armorer_gift"), ResourceLocation.parse((String)"minecraft:gameplay/hero_of_the_village/butcher_gift"), ResourceLocation.parse((String)"minecraft:gameplay/hero_of_the_village/cartographer_gift"), ResourceLocation.parse((String)"minecraft:gameplay/hero_of_the_village/cleric_gift"), ResourceLocation.parse((String)"minecraft:gameplay/hero_of_the_village/farmer_gift"), ResourceLocation.parse((String)"minecraft:gameplay/hero_of_the_village/fisherman_gift"), ResourceLocation.parse((String)"minecraft:gameplay/hero_of_the_village/fletcher_gift"), ResourceLocation.parse((String)"minecraft:gameplay/hero_of_the_village/leatherworker_gift"), ResourceLocation.parse((String)"minecraft:gameplay/hero_of_the_village/librarian_gift"), ResourceLocation.parse((String)"minecraft:gameplay/hero_of_the_village/mason_gift"), ResourceLocation.parse((String)"minecraft:gameplay/hero_of_the_village/shepherd_gift"), ResourceLocation.parse((String)"minecraft:gameplay/hero_of_the_village/toolsmith_gift"), ResourceLocation.parse((String)"minecraft:gameplay/hero_of_the_village/weaponsmith_gift"), ResourceLocation.parse((String)"minecraft:archaeology/desert_pyramid"), ResourceLocation.parse((String)"minecraft:archaeology/desert_well"), ResourceLocation.parse((String)"minecraft:archaeology/ocean_ruin_cold"), ResourceLocation.parse((String)"minecraft:archaeology/ocean_ruin_warm"), ResourceLocation.parse((String)"minecraft:archaeology/trail_ruins_common"), ResourceLocation.parse((String)"minecraft:archaeology/trail_ruins_rare"), ResourceLocation.parse((String)"minecraft:pots/trial_chambers/corridor"), ResourceLocation.parse((String)"minecraft:chests/village/village_armorer"), ResourceLocation.parse((String)"minecraft:chests/village/village_butcher"), ResourceLocation.parse((String)"minecraft:chests/village/village_cartographer"), ResourceLocation.parse((String)"minecraft:chests/village/village_desert_house"), ResourceLocation.parse((String)"minecraft:chests/village/village_fisher"), ResourceLocation.parse((String)"minecraft:chests/village/village_fletcher"), ResourceLocation.parse((String)"minecraft:chests/village/village_mason"), ResourceLocation.parse((String)"minecraft:chests/village/village_plains_house"), ResourceLocation.parse((String)"minecraft:chests/village/village_savanna_house"), ResourceLocation.parse((String)"minecraft:chests/village/village_shepherd"), ResourceLocation.parse((String)"minecraft:chests/village/village_snowy_house"), ResourceLocation.parse((String)"minecraft:chests/village/village_taiga_house"), ResourceLocation.parse((String)"minecraft:chests/village/village_tannery"), ResourceLocation.parse((String)"minecraft:chests/village/village_temple"), ResourceLocation.parse((String)"minecraft:chests/village/village_toolsmith"), ResourceLocation.parse((String)"minecraft:chests/village/village_weaponsmith"), ResourceLocation.parse((String)"cobblemon:gilded_chest"), ResourceLocation.parse((String)"cobblemon:pink_gilded_chest"), ResourceLocation.parse((String)"cobblemon:black_gilded_chest"), ResourceLocation.parse((String)"cobblemon:green_gilded_chest"), ResourceLocation.parse((String)"cobblemon:blue_gilded_chest"), ResourceLocation.parse((String)"cobblemon:yellow_gilded_chest"), ResourceLocation.parse((String)"cobblemon:white_gilded_chest"));
    private static List<LootTableItemConfig> lootTableConfig;

    public static void registerLootModifications() {
        LootTableModifier.loadLootTableConfig();
        if (lootTableConfig == null) {
            return;
        }
        LootEvent.MODIFY_LOOT_TABLE.register((key, context, builtin) -> {
            for (LootTableItemConfig itemConfig : lootTableConfig) {
                if (!itemConfig.enabled) continue;
                for (LootTableEntry entry : itemConfig.lootTables) {
                    if (!builtin || !entry.id.equals((Object)key.location())) continue;
                    Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemConfig.itemId));
                    LootPool.Builder poolBuilder = LootPool.lootPool().add(LootItem.lootTableItem((ItemLike)item).when(LootItemRandomChanceCondition.randomChance((float)entry.weight)));
                    context.addPool(poolBuilder);
                }
            }
        });
    }

    public static void loadLootTableConfig() {
        File configFile = Platform.getConfigFolder().resolve("MythsAndLegends").resolve("loot_tables_config.json").toFile();
        try (FileReader reader = new FileReader(configFile);){
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            JsonArray itemsArray = json.getAsJsonArray("items");
            lootTableConfig = new ArrayList<LootTableItemConfig>();
            for (JsonElement itemElement : itemsArray) {
                JsonObject itemObject = itemElement.getAsJsonObject();
                LootTableItemConfig itemConfig = new LootTableItemConfig();
                itemConfig.itemId = itemObject.get("itemId").getAsString();
                itemConfig.enabled = itemObject.get("enabled").getAsBoolean();
                JsonArray lootTablesArray = itemObject.getAsJsonArray("lootTables");
                for (JsonElement lootTableElement : lootTablesArray) {
                    JsonObject lootTableObject = lootTableElement.getAsJsonObject();
                    String lootTableId = lootTableObject.get("id").getAsString();
                    float weight = lootTableObject.get("weight").getAsFloat();
                    LootTableEntry entry = new LootTableEntry(lootTableId, weight);
                    itemConfig.lootTables.add(entry);
                }
                lootTableConfig.add(itemConfig);
            }
        }
        catch (FileNotFoundException e) {
            MythsAndLegends.getLogger().info("Configuration file not found, creating default configuration file.");
            LootTableModifier.createDefaultConfigFile();
        }
        catch (IOException e) {
            MythsAndLegends.getLogger().error("Error loading configuration file: {}", (Object)e.getMessage());
        }
    }

    private static void createDefaultConfigFile() {
        lootTableConfig = new ArrayList<LootTableItemConfig>();
        for (ResourceLocation identifier : Items.MYTHS_AND_LEGENDS_ITEMS) {
            MythsAndLegends.getLogger().info("Adding item: " + String.valueOf(identifier));
            LootTableItemConfig itemConfig = new LootTableItemConfig();
            itemConfig.itemId = identifier.toString();
            itemConfig.enabled = true;
            for (ResourceLocation lootTableId : DEFAULT_LOOT_TABLES) {
                LootTableEntry entry = new LootTableEntry(lootTableId.toString(), 0.005f);
                itemConfig.lootTables.add(entry);
            }
            lootTableConfig.add(itemConfig);
        }
        LootTableModifier.saveConfigToFile();
    }

    private static void saveConfigToFile() {
        File configFile = Platform.getConfigFolder().resolve("MythsAndLegends").resolve("loot_tables_config.json").toFile();
        try (FileWriter writer = new FileWriter(configFile);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonObject json = new JsonObject();
            JsonArray itemsArray = new JsonArray();
            for (LootTableItemConfig itemConfig : lootTableConfig) {
                JsonObject itemObject = new JsonObject();
                itemObject.addProperty("itemId", itemConfig.itemId);
                itemObject.addProperty("enabled", Boolean.valueOf(itemConfig.enabled));
                JsonArray lootTablesArray = new JsonArray();
                for (LootTableEntry entry : itemConfig.lootTables) {
                    JsonObject entryObject = new JsonObject();
                    entryObject.addProperty("id", entry.id.toString());
                    entryObject.addProperty("weight", (Number)Float.valueOf(entry.weight));
                    lootTablesArray.add((JsonElement)entryObject);
                }
                itemObject.add("lootTables", (JsonElement)lootTablesArray);
                itemsArray.add((JsonElement)itemObject);
            }
            json.add("items", (JsonElement)itemsArray);
            gson.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            MythsAndLegends.getLogger().error("Error saving configuration file: " + e.getMessage());
        }
    }
}

