/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.utils;

import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.utils.gson.IdentifierTypeAdapter;
import com.github.d0ctorleon.mythsandlegends.utils.gson.UUIDTypeAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;

public class DebtUtils {
    private final String DEBT_FILE;
    private Map<UUID, Map<ResourceLocation, Integer>> playerDebts = new HashMap<UUID, Map<ResourceLocation, Integer>>();
    private Gson gson = new Gson();

    public DebtUtils(Path configDirectoryPath) {
        this.DEBT_FILE = configDirectoryPath.resolve("debts.json").toString();
        this.gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).registerTypeAdapter(ResourceLocation.class, (Object)new IdentifierTypeAdapter()).create();
        this.loadDebts();
    }

    public Map<UUID, Map<ResourceLocation, Integer>> getDebts() {
        return this.playerDebts;
    }

    public Map<ResourceLocation, Integer> getDebtsForPlayer(UUID playerId) {
        return this.playerDebts.getOrDefault(playerId, Collections.emptyMap());
    }

    public void addDebt(UUID playerId, ResourceLocation itemId, int count) {
        Map playerDebt = this.playerDebts.computeIfAbsent(playerId, k -> new HashMap());
        playerDebt.put(itemId, playerDebt.getOrDefault(itemId, 0) + count);
        this.saveDebts();
    }

    public void clearDebt(UUID playerId, ResourceLocation itemId) {
        Map<ResourceLocation, Integer> playerDebt = this.playerDebts.get(playerId);
        if (playerDebt != null) {
            playerDebt.remove(itemId);
            if (playerDebt.isEmpty()) {
                this.playerDebts.remove(playerId);
            }
        }
        this.saveDebts();
    }

    public Tuple<String, String> splitIdentifier(ResourceLocation identifier) {
        String namespace = identifier.getNamespace();
        String path = identifier.getPath();
        return new Tuple((Object)namespace, (Object)path);
    }

    public boolean isInDebt(UUID playerId, ResourceLocation itemId) {
        Map<ResourceLocation, Integer> playerDebt = this.playerDebts.get(playerId);
        return playerDebt != null && playerDebt.containsKey(itemId);
    }

    public int getDebtAmount(UUID playerId, ResourceLocation itemId) {
        Map<ResourceLocation, Integer> playerDebt = this.playerDebts.get(playerId);
        return playerDebt != null ? playerDebt.getOrDefault(itemId, 0) : 0;
    }

    private void saveDebts() {
        try (FileWriter writer = new FileWriter(this.DEBT_FILE);){
            this.gson.toJson(this.playerDebts, (Appendable)writer);
        }
        catch (IOException e) {
            MythsAndLegends.getLogger().error("Failed to save debts to file: " + this.DEBT_FILE);
        }
    }

    public void loadDebts() {
        File file = new File(this.DEBT_FILE);
        if (!file.exists()) {
            try {
                file.createNewFile();
                this.playerDebts = new HashMap<UUID, Map<ResourceLocation, Integer>>();
                this.saveDebts();
            }
            catch (IOException e) {
                MythsAndLegends.getLogger().error("Failed to create debts file: " + this.DEBT_FILE);
            }
        } else {
            try (FileReader reader = new FileReader(file);){
                this.playerDebts = (Map)this.gson.fromJson((Reader)reader, new TypeToken<HashMap<UUID, Map<ResourceLocation, Integer>>>(this){}.getType());
            }
            catch (IOException e) {
                MythsAndLegends.getLogger().error("Failed to load debts from file: " + this.DEBT_FILE);
            }
        }
    }
}

