/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.utils;

import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.ShulkerBoxBlock;

public class InventoryUtils {
    public static boolean hasItemInInventory(Player player, Item item) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.getItem() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean removeItemFromInventory(ServerPlayer player, Item item, int count, boolean checkBundles, boolean checkShulkerBoxes) {
        ItemStack stack;
        int i;
        int remainingCount = count;
        for (i = 0; i < player.getInventory().getContainerSize() && remainingCount > 0; ++i) {
            stack = player.getInventory().getItem(i);
            if (stack.getItem() != item) continue;
            int removeAmount = Math.min(remainingCount, stack.getCount());
            stack.shrink(removeAmount);
            remainingCount -= removeAmount;
            if (!stack.isEmpty()) continue;
            player.getInventory().setItem(i, ItemStack.EMPTY);
        }
        if (remainingCount > 0) {
            for (i = 0; i < player.getInventory().getContainerSize() && remainingCount > 0; ++i) {
                stack = player.getInventory().getItem(i);
                remainingCount = InventoryUtils.removeItemFromContainer(stack, item, remainingCount, checkBundles, checkShulkerBoxes);
            }
        }
        return remainingCount == 0;
    }

    public static int removeItemFromContainer(ItemStack containerStack, Item item, int count, boolean checkBundles, boolean checkShulkerBoxes) {
        int remainingCount;
        block4: {
            ItemContainerContents containerComponent;
            Item containerItem;
            block3: {
                remainingCount = count;
                containerItem = containerStack.getItem();
                if (!checkBundles || !(containerItem instanceof BundleItem)) break block3;
                BundleContents bundleContents = (BundleContents)containerStack.get(DataComponents.BUNDLE_CONTENTS);
                if (bundleContents == null) break block4;
                for (ItemStack bundleItem : bundleContents.itemsCopy()) {
                    if (bundleItem.getItem() != item) continue;
                    int removeAmount = Math.min(remainingCount, bundleItem.getCount());
                    bundleItem.shrink(removeAmount);
                    remainingCount -= removeAmount;
                    if (!bundleItem.isEmpty()) continue;
                }
                break block4;
            }
            if (checkShulkerBoxes && containerItem instanceof BlockItem && ((BlockItem)containerItem).getBlock() instanceof ShulkerBoxBlock && (containerComponent = (ItemContainerContents)containerStack.get(DataComponents.CONTAINER)) != null) {
                for (ItemStack shulkerItem : containerComponent.nonEmptyItems()) {
                    if (shulkerItem.getItem() != item) continue;
                    int removeAmount = Math.min(remainingCount, shulkerItem.getCount());
                    shulkerItem.shrink(removeAmount);
                    remainingCount -= removeAmount;
                    if (!shulkerItem.isEmpty()) continue;
                }
            }
        }
        return remainingCount;
    }
}

