/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc;

import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class AreaClearingLockBlock
extends HorizontalDirectionalBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty ACTIVATED = BooleanProperty.create((String)"activated");
    private final Set<Item> acceptedKeys = new HashSet<Item>();
    private final Set<ResourceLocation> breakableBlockIds;
    public static final MapCodec<AreaClearingLockBlock> CODEC = MapCodec.unit(() -> new AreaClearingLockBlock(new Item[0], new ResourceLocation[0]));

    public AreaClearingLockBlock(Item[] acceptedKeys, ResourceLocation[] breakableBlocks) {
        super((BlockBehaviour.Properties)FabricBlockSettings.create().strength(-1.0f, 3600000.0f).requiresTool().dropsNothing());
        for (Item item : acceptedKeys) {
            this.acceptedKeys.add(item);
        }
        this.breakableBlockIds = new HashSet<ResourceLocation>();
        for (Item item : breakableBlocks) {
            this.breakableBlockIds.add((ResourceLocation)item);
        }
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ACTIVATED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        ItemStack held = player.getMainHandItem();
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (!((Boolean)state.getValue((Property)ACTIVATED)).booleanValue() && this.acceptedKeys.contains(held.getItem())) {
            held.shrink(1);
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(true)));
            world.scheduleTick(pos, (Block)this, 40);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        int minY = Math.max(world.getMinBuildHeight(), pos.getY() - 7);
        int maxY = Math.min(world.getMaxBuildHeight() - 1, pos.getY() + 7);
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            int z = pos.getZ();
            for (int x = pos.getX() - 7; x <= pos.getX() + 7; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos target = new BlockPos(x, y, z);
                    BlockState bs = world.getBlockState(target);
                    ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)bs.getBlock());
                    if (!this.breakableBlockIds.contains(id)) continue;
                    world.destroyBlock(target, false);
                }
            }
        } else {
            int x = pos.getX();
            for (int z = pos.getZ() - 7; z <= pos.getZ() + 7; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos target = new BlockPos(x, y, z);
                    BlockState bs = world.getBlockState(target);
                    ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)bs.getBlock());
                    if (!this.breakableBlockIds.contains(id)) continue;
                    world.destroyBlock(target, false);
                }
            }
        }
        world.destroyBlock(pos, false);
    }
}

