/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc;

import github.jorgaomc.FootprintTracker;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CosmicBagItem
extends Item {
    public CosmicBagItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            this.displayFootprintProgress(player);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    private void displayFootprintProgress(Player player) {
        UUID playerUUID = player.getUUID();
        Map<FootprintTracker.FootprintType, Integer> playerProgress = FootprintTracker.getPlayerProgress(playerUUID, player.level());
        if (playerProgress == null || playerProgress.isEmpty()) {
            player.displayClientMessage((Component)Component.literal((String)"Your Cosmic Catalyst is empty. Find cosmic dust to fill it!").withStyle(ChatFormatting.LIGHT_PURPLE), false);
            return;
        }
        player.displayClientMessage((Component)Component.literal((String)"\u2727 Your Cosmic Dust / Footprint Collection Status \u2727").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), false);
        FootprintTracker.FootprintType cosmicType = FootprintTracker.FootprintType.COSMIC_DUST;
        int cosmicProgress = playerProgress.getOrDefault((Object)cosmicType, 0);
        player.displayClientMessage((Component)Component.literal((String)(" \u2022 " + cosmicType.getDisplayName() + ": " + cosmicProgress + "/50 particles")).withStyle(ChatFormatting.LIGHT_PURPLE), false);
        for (FootprintTracker.FootprintType type : FootprintTracker.FootprintType.values()) {
            if (type == FootprintTracker.FootprintType.COSMIC_DUST) continue;
            int progress = playerProgress.getOrDefault((Object)type, 0);
            player.displayClientMessage((Component)Component.literal((String)(" \u2022 " + type.getDisplayName() + ": " + progress + "/50 footprints")).withStyle(ChatFormatting.AQUA), false);
        }
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"item.legendarymonuments.cosmic_bag.tooltip.1").withStyle(ChatFormatting.LIGHT_PURPLE));
        super.appendHoverText(stack, context, tooltip, type);
    }
}

