/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc;

import github.jorgaomc.FootprintTracker;
import github.jorgaomc.LegendaryMonuments;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CosmicDustBlock
extends Block {
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final String REQUIRED_ITEM_ID = "legendarymonuments:cosmic_bag";

    public CosmicDustBlock() {
        super((BlockBehaviour.Properties)FabricBlockSettings.create().mapColor(DyeColor.PURPLE).strength(-1.0f, 3600000.0f).noCollision().nonOpaque().luminance(5));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean isSignalSource(BlockState state) {
        return false;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide()) {
            ItemStack heldItem = player.getItemInHand(InteractionHand.MAIN_HAND);
            if (!this.isHoldingCosmicBag(heldItem)) {
                player.displayClientMessage((Component)Component.literal((String)"You need a Cosmic Bag to collect this cosmic dust.").withStyle(ChatFormatting.LIGHT_PURPLE), true);
                return InteractionResult.FAIL;
            }
            this.handleCosmicDustInteraction(world, pos, player);
        }
        return InteractionResult.SUCCESS;
    }

    private boolean isHoldingCosmicBag(ItemStack stack) {
        Item item = stack.getItem();
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
        return REQUIRED_ITEM_ID.equals(id.toString());
    }

    private void handleCosmicDustInteraction(Level world, BlockPos pos, Player player) {
        LegendaryMonuments.LOGGER.info("Player {} is collecting cosmic dust at {}", (Object)player.getName().getString(), (Object)pos);
        FootprintTracker.FootprintType dustType = FootprintTracker.FootprintType.COSMIC_DUST;
        LegendaryMonuments.LOGGER.info("Recording cosmic dust found for player");
        boolean isComplete = FootprintTracker.recordFootprintFound(player, dustType);
        if (isComplete && player instanceof ServerPlayer) {
            LegendaryMonuments.LOGGER.info("Player completed collection! Executing command");
            FootprintTracker.executeCompletionCommand((ServerPlayer)player, dustType);
        }
        world.playSound(null, pos, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.BLOCKS, 0.7f, 1.2f);
        world.playSound(null, pos, SoundEvents.BEACON_ACTIVATE, SoundSource.BLOCKS, 0.4f, 1.5f);
        LegendaryMonuments.LOGGER.info("Removing cosmic dust block");
        world.removeBlock(pos, false);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }
}

