/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc;

import github.jorgaomc.FootprintTracker;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModBlocks;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FootprintBlock
extends Block {
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public FootprintBlock() {
        super((BlockBehaviour.Properties)FabricBlockSettings.create().mapColor(DyeColor.GRAY).strength(-1.0f, 3600000.0f).noCollision().nonOpaque());
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean isSignalSource(BlockState state) {
        return false;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide()) {
            this.handleFootprintInteraction(world, pos, state, player);
        }
        return InteractionResult.SUCCESS;
    }

    private void handleFootprintInteraction(Level world, BlockPos pos, BlockState state, Player player) {
        LegendaryMonuments.LOGGER.info("Player {} is interacting with footprint at {}", (Object)player.getName().getString(), (Object)pos);
        FootprintTracker.FootprintType footprintType = null;
        Block block = state.getBlock();
        if (block == ModBlocks.TERRAKION_FOOTPRINTS) {
            footprintType = FootprintTracker.FootprintType.TERRAKION;
            LegendaryMonuments.LOGGER.info("Found Terrakion footprint");
        } else if (block == ModBlocks.COBALION_FOOTPRINTS) {
            footprintType = FootprintTracker.FootprintType.COBALION;
            LegendaryMonuments.LOGGER.info("Found Cobalion footprint");
        } else if (block == ModBlocks.VIRIZION_FOOTPRINTS) {
            footprintType = FootprintTracker.FootprintType.VIRIZION;
            LegendaryMonuments.LOGGER.info("Found Virizion footprint");
        }
        if (footprintType == null) {
            LegendaryMonuments.LOGGER.warn("Could not determine footprint type for block: {}", (Object)block);
            return;
        }
        LegendaryMonuments.LOGGER.info("Recording footprint found for player");
        boolean isComplete = FootprintTracker.recordFootprintFound(player, footprintType);
        if (isComplete && player instanceof ServerPlayer) {
            LegendaryMonuments.LOGGER.info("Player completed collection! Executing command");
            FootprintTracker.executeCompletionCommand((ServerPlayer)player, footprintType);
        }
        world.playSound(null, pos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.5f, 1.5f);
        LegendaryMonuments.LOGGER.info("Removing footprint block");
        world.removeBlock(pos, false);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }
}

