/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.util.LegendaryEffects;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FootprintTracker {
    public static final int PROGRESS_MAX = 50;
    private static final Map<String, Map<UUID, Map<FootprintType, Integer>>> worldPlayerProgress = new HashMap<String, Map<UUID, Map<FootprintType, Integer>>>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type PROGRESS_TYPE = new TypeToken<Map<String, Map<UUID, Map<FootprintType, Integer>>>>(){}.getType();
    private static File progressDataFile;

    private static String getWorldId(ServerLevel world) {
        if (world == null) {
            LegendaryMonuments.LOGGER.error("World is null in getWorldId()");
            return "unknown";
        }
        try {
            MinecraftServer server = world.getServer();
            String levelName = server.getWorldData().getLevelName();
            if (levelName == null || levelName.isEmpty()) {
                LegendaryMonuments.LOGGER.error("Level name is null/empty, using fallback");
                return "unknown_world_" + System.currentTimeMillis();
            }
            long worldSeed = world.getSeed();
            int spawnX = world.getSharedSpawnPos().getX();
            int spawnZ = world.getSharedSpawnPos().getZ();
            String worldSpecificData = worldSeed + "_" + spawnX + "_" + spawnZ;
            int worldDataHash = worldSpecificData.hashCode();
            String uniqueWorldId = levelName + "_" + Math.abs(worldDataHash);
            return uniqueWorldId;
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Exception while generating world ID, using fallback", (Throwable)e);
            return "error_world_" + System.currentTimeMillis();
        }
    }

    private static File getServerDataDirectory(MinecraftServer server) {
        File serverDir = null;
        try {
            serverDir = server.getServerDirectory().toFile();
            if (serverDir != null && serverDir.exists() && serverDir.canWrite()) {
                return serverDir;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.warn("Failed to get server run directory", (Throwable)e);
        }
        try {
            serverDir = new File(System.getProperty("user.dir"));
            if (serverDir.exists() && serverDir.canWrite()) {
                return serverDir;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.warn("Failed to use current working directory", (Throwable)e);
        }
        try {
            serverDir = new File(System.getProperty("user.home"), "minecraft-footprint-data");
            if (!serverDir.exists()) {
                serverDir.mkdirs();
            }
            if (serverDir.exists() && serverDir.canWrite()) {
                return serverDir;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.warn("Failed to use user home directory", (Throwable)e);
        }
        try {
            serverDir = new File(System.getProperty("java.io.tmpdir"), "minecraft-footprint-data");
            if (!serverDir.exists()) {
                serverDir.mkdirs();
            }
            if (serverDir.exists() && serverDir.canWrite()) {
                LegendaryMonuments.LOGGER.warn("Using temp directory for footprint data - data will be lost on reboot!");
                return serverDir;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Failed to use temp directory", (Throwable)e);
        }
        LegendaryMonuments.LOGGER.error("CRITICAL: Could not find any writable directory for footprint data!");
        return null;
    }

    private static void ensureStorageInitialized(MinecraftServer server) {
        if (progressDataFile == null) {
            LegendaryMonuments.LOGGER.warn("progressDataFile is null, attempting lazy initialization...");
            LegendaryMonuments.LOGGER.info("Server instance available: {}", (Object)(server != null ? 1 : 0));
            if (server != null) {
                FootprintTracker.initializeStorage(server);
            } else {
                LegendaryMonuments.LOGGER.error("Cannot initialize storage: server is null");
            }
        }
    }

    public static void initializeStorage(MinecraftServer server) {
        try {
            boolean created;
            LegendaryMonuments.LOGGER.info("=== STARTING FOOTPRINT TRACKER INITIALIZATION ===");
            File serverDir = FootprintTracker.getServerDataDirectory(server);
            if (serverDir == null) {
                LegendaryMonuments.LOGGER.error("CRITICAL: Could not find any writable directory for footprint tracking");
                return;
            }
            File dataDir = new File(serverDir, "legendary-monuments-data");
            if (!dataDir.exists() && !(created = dataDir.mkdirs())) {
                LegendaryMonuments.LOGGER.error("CRITICAL: Failed to create data directory for footprint tracking");
                LegendaryMonuments.LOGGER.error("Data directory path: {}", (Object)dataDir.getAbsolutePath());
                if (dataDir.getParentFile() != null) {
                    LegendaryMonuments.LOGGER.error("Parent directory exists: {}", (Object)dataDir.getParentFile().exists());
                    LegendaryMonuments.LOGGER.error("Parent directory writable: {}", (Object)dataDir.getParentFile().canWrite());
                    LegendaryMonuments.LOGGER.error("Parent directory path: {}", (Object)dataDir.getParentFile().getAbsolutePath());
                }
                return;
            }
            if (!dataDir.canWrite()) {
                LegendaryMonuments.LOGGER.error("CRITICAL: Data directory exists but is not writable: {}", (Object)dataDir.getAbsolutePath());
                return;
            }
            progressDataFile = new File(dataDir, "footprint_progress.json");
            if (progressDataFile.exists()) {
                try (FileReader reader = new FileReader(progressDataFile);){
                    Map loadedData = (Map)GSON.fromJson((Reader)reader, PROGRESS_TYPE);
                    if (loadedData != null) {
                        worldPlayerProgress.putAll(loadedData);
                        int totalPlayers = 0;
                        for (Map<UUID, Map<FootprintType, Integer>> worldMap : worldPlayerProgress.values()) {
                            if (worldMap == null) continue;
                            totalPlayers += worldMap.size();
                        }
                        LegendaryMonuments.LOGGER.info("Successfully loaded footprint progress data for {} worlds and {} total players", (Object)loadedData.size(), (Object)totalPlayers);
                    } else {
                        LegendaryMonuments.LOGGER.warn("Progress file exists but contains no data (null)");
                    }
                }
                catch (IOException e) {
                    LegendaryMonuments.LOGGER.error("IOException while loading footprint progress data", (Throwable)e);
                }
                catch (Exception e) {
                    LegendaryMonuments.LOGGER.error("Exception processing progress data file, starting with empty data", (Throwable)e);
                    worldPlayerProgress.clear();
                }
            } else {
                LegendaryMonuments.LOGGER.info("No existing progress file found, creating new one...");
                try {
                    created = progressDataFile.createNewFile();
                    LegendaryMonuments.LOGGER.info("Created new footprint progress data file: {}", (Object)created);
                    if (!created) {
                        LegendaryMonuments.LOGGER.error("Failed to create new progress file!");
                        return;
                    }
                }
                catch (IOException e) {
                    LegendaryMonuments.LOGGER.error("IOException creating footprint progress data file", (Throwable)e);
                    return;
                }
            }
            if (progressDataFile != null && progressDataFile.exists() && progressDataFile.getParentFile().canWrite()) {
                LegendaryMonuments.LOGGER.info("=== FOOTPRINT TRACKER INITIALIZATION SUCCESSFUL ===");
            } else {
                LegendaryMonuments.LOGGER.error("=== FOOTPRINT TRACKER INITIALIZATION FAILED ===");
                LegendaryMonuments.LOGGER.error("progressDataFile is null: {}", (Object)(progressDataFile == null ? 1 : 0));
                if (progressDataFile != null) {
                    LegendaryMonuments.LOGGER.error("progressDataFile exists: {}", (Object)progressDataFile.exists());
                    LegendaryMonuments.LOGGER.error("progressDataFile parent writable: {}", (Object)(progressDataFile.getParentFile() != null && progressDataFile.getParentFile().canWrite() ? 1 : 0));
                }
                progressDataFile = null;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("=== CRITICAL ERROR DURING FOOTPRINT TRACKER INITIALIZATION ===", (Throwable)e);
            progressDataFile = null;
        }
    }

    public static void loadPlayerProgress(ServerPlayer player) {
        try {
            if (player == null) {
                LegendaryMonuments.LOGGER.error("Cannot load player progress: player is null");
                return;
            }
            FootprintTracker.ensureStorageInitialized(player.getServer());
            UUID playerUUID = player.getUUID();
            String worldId = FootprintTracker.getWorldId((ServerLevel)player.level());
            worldPlayerProgress.putIfAbsent(worldId, new HashMap());
            Map<UUID, Map<FootprintType, Integer>> worldProgress = worldPlayerProgress.get(worldId);
            if (worldProgress.containsKey(playerUUID)) {
                return;
            }
            worldProgress.putIfAbsent(playerUUID, new HashMap());
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Unexpected error loading player progress", (Throwable)e);
        }
    }

    public static void saveAllPlayerData() {
        if (progressDataFile == null) {
            LegendaryMonuments.LOGGER.error("Cannot save player footprint data: progressDataFile is null");
            return;
        }
        try (FileWriter writer = new FileWriter(progressDataFile);){
            GSON.toJson(worldPlayerProgress, (Appendable)writer);
            int n = worldPlayerProgress.values().stream().mapToInt(Map::size).sum();
        }
        catch (IOException e) {
            LegendaryMonuments.LOGGER.error("Failed to save player footprint data", (Throwable)e);
        }
    }

    public static void savePlayerData(ServerPlayer player) {
        if (player == null) {
            LegendaryMonuments.LOGGER.warn("Cannot save player footprint data: player is null");
            return;
        }
        FootprintTracker.ensureStorageInitialized(player.getServer());
        if (progressDataFile == null) {
            LegendaryMonuments.LOGGER.error("Cannot save player footprint data: file not initialized (even after lazy init attempt)");
            return;
        }
        String worldId = FootprintTracker.getWorldId((ServerLevel)player.level());
        UUID playerUUID = player.getUUID();
        Map<UUID, Map<FootprintType, Integer>> worldProgress = worldPlayerProgress.get(worldId);
        if (worldProgress == null || !worldProgress.containsKey(playerUUID)) {
            LegendaryMonuments.LOGGER.info("No data to save for player {} in world {}", (Object)player.getName().getString(), (Object)worldId);
            return;
        }
        FootprintTracker.saveAllPlayerData();
        LegendaryMonuments.LOGGER.info("Saved footprint progress for player {} in world {}", (Object)player.getName().getString(), (Object)worldId);
    }

    public static Map<FootprintType, Integer> getPlayerProgress(UUID playerUUID, Level world) {
        try {
            if (!(world instanceof ServerLevel)) {
                LegendaryMonuments.LOGGER.warn("getPlayerProgress called with non-ServerWorld: {}", (Object)world.getClass().getSimpleName());
                return new HashMap<FootprintType, Integer>();
            }
            String worldId = FootprintTracker.getWorldId((ServerLevel)world);
            worldPlayerProgress.putIfAbsent(worldId, new HashMap());
            Map<UUID, Map<FootprintType, Integer>> worldProgress = worldPlayerProgress.get(worldId);
            worldProgress.putIfAbsent(playerUUID, new HashMap());
            Map<FootprintType, Integer> playerData = worldProgress.get(playerUUID);
            return playerData;
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error retrieving player progress", (Throwable)e);
            return new HashMap<FootprintType, Integer>();
        }
    }

    public static boolean recordFootprintFound(Player player, FootprintType type) {
        try {
            if (player == null) {
                LegendaryMonuments.LOGGER.error("Cannot record footprint: player is null");
                return false;
            }
            if (player.level().isClientSide) {
                LegendaryMonuments.LOGGER.info("Ignoring client-side footprint recording attempt");
                return false;
            }
            String worldId = FootprintTracker.getWorldId((ServerLevel)player.level());
            UUID playerUUID = player.getUUID();
            worldPlayerProgress.putIfAbsent(worldId, new HashMap());
            Map<UUID, Map<FootprintType, Integer>> worldProgress = worldPlayerProgress.get(worldId);
            worldProgress.putIfAbsent(playerUUID, new HashMap());
            Map<FootprintType, Integer> progress = worldProgress.get(playerUUID);
            int currentProgress = progress.getOrDefault((Object)type, 0);
            int newProgress = currentProgress + 1;
            progress.put(type, newProgress);
            if (player instanceof ServerPlayer) {
                try {
                    FootprintTracker.savePlayerData((ServerPlayer)player);
                }
                catch (Exception e) {
                    LegendaryMonuments.LOGGER.error("Failed to save player data after footprint update", (Throwable)e);
                }
            }
            if (type == FootprintType.COSMIC_DUST) {
                player.displayClientMessage((Component)Component.literal((String)(newProgress + "/50 " + type.getDisplayName() + " particles collected")).withStyle(ChatFormatting.LIGHT_PURPLE), true);
            } else {
                player.displayClientMessage((Component)Component.literal((String)(newProgress + "/50 " + type.getDisplayName() + " footprints found")).withStyle(ChatFormatting.GOLD), true);
            }
            if (newProgress >= 50) {
                LegendaryMonuments.LOGGER.info("Player {} has completed {} collection in world {}!", new Object[]{player.getName().getString(), type.getDisplayName(), worldId});
                progress.put(type, 0);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Unexpected error recording footprint", (Throwable)e);
            return false;
        }
    }

    public static void executeCompletionCommand(ServerPlayer player, FootprintType type) {
        boolean isShiny;
        String worldId = FootprintTracker.getWorldId((ServerLevel)player.level());
        LegendaryMonuments.LOGGER.info("Executing completion command for {} in world {}", (Object)type.getDisplayName(), (Object)worldId);
        boolean bl = isShiny = Math.random() < 0.02;
        if (type == FootprintType.COSMIC_DUST) {
            int x = (int)Math.floor(player.getX());
            int y = (int)Math.floor(player.getY());
            int z = (int)Math.floor(player.getZ());
            BlockPos spawnPos = new BlockPos(x, y, z);
            LegendaryEffects.spawnCosmogEffect((ServerLevel)player.level(), spawnPos);
            String pokemonName = "cosmog";
            String command = "pokespawnat " + x + " " + y + " " + z + " " + pokemonName + " lvl=5";
            if (isShiny) {
                command = command + " shiny";
            }
            CommandSourceStack commandSource = player.getServer().createCommandSourceStack().withLevel((ServerLevel)player.level()).withPosition(player.position()).withRotation(player.getRotationVector());
            LegendaryMonuments.LOGGER.info("Executing command: {}", (Object)command);
            player.getServer().getCommands().performPrefixedCommand(commandSource, command);
            MutableComponent message = Component.literal((String)("You have collected all " + type.getDisplayName() + " particles! ")).withStyle(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.BOLD});
            message = isShiny ? message.copy().append((Component)Component.literal((String)("A SHINY " + pokemonName + " has emerged from the void!")).withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})) : message.copy().append((Component)Component.literal((String)("A " + pokemonName + " has emerged from the void!")).withStyle(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.BOLD}));
            player.displayClientMessage((Component)message, false);
            return;
        }
        String pokemonName = "";
        String berryId = "";
        switch (type.ordinal()) {
            case 0: {
                pokemonName = "Terrakion";
                berryId = "legendarymonuments:special_spices";
                break;
            }
            case 1: {
                pokemonName = "Cobalion";
                berryId = "legendarymonuments:special_meat_chunks";
                break;
            }
            case 2: {
                pokemonName = "Virizion";
                berryId = "legendarymonuments:special_leafy_greens";
                break;
            }
            default: {
                pokemonName = "";
            }
        }
        int x = (int)Math.floor(player.getX());
        int y = (int)Math.floor(player.getY());
        int z = (int)Math.floor(player.getZ());
        BlockPos spawnPos = new BlockPos(x, y, z);
        switch (type.ordinal()) {
            case 0: {
                LegendaryEffects.spawnTerrakionEffect((ServerLevel)player.level(), spawnPos);
                break;
            }
            case 1: {
                LegendaryEffects.spawnCobalionEffect((ServerLevel)player.level(), spawnPos);
                break;
            }
            case 2: {
                LegendaryEffects.spawnVirizionEffect((ServerLevel)player.level(), spawnPos);
                break;
            }
        }
        String spawnCommand = "pokespawnat " + x + " " + y + " " + z + " " + pokemonName + " lvl=40";
        if (isShiny) {
            spawnCommand = spawnCommand + " shiny";
        }
        LegendaryMonuments.LOGGER.info("Executing command: {}", (Object)spawnCommand);
        player.getServer().getCommands().performPrefixedCommand(player.getServer().createCommandSourceStack(), spawnCommand);
        if (!berryId.isEmpty()) {
            ResourceLocation id = ResourceLocation.parse((String)berryId);
            Item berry = (Item)BuiltInRegistries.ITEM.get(id);
            if (berry != Items.AIR) {
                LegendaryMonuments.LOGGER.info("Giving special ingredient to player: {}", (Object)berryId);
                ItemStack stack = new ItemStack((ItemLike)berry, 1);
                if (!player.getInventory().add(stack)) {
                    player.drop(stack, false);
                }
            } else {
                LegendaryMonuments.LOGGER.error("Could not find ingredient item: {}", (Object)berryId);
            }
        }
        MutableComponent message = Component.literal((String)("You have collected all " + type.getDisplayName() + " footprints! ")).withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD});
        message = isShiny ? message.copy().append((Component)Component.literal((String)("A SHINY " + pokemonName + " has appeared!")).withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})) : message.copy().append((Component)Component.literal((String)("A " + pokemonName + " has appeared!")).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
        message = message.copy().append((Component)Component.literal((String)("\nYou received a special ingredient from " + pokemonName + "!")).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        player.displayClientMessage((Component)message, false);
    }

    public static enum FootprintType {
        TERRAKION("Terrakion"),
        COBALION("Cobalion"),
        VIRIZION("Virizion"),
        COSMIC_DUST("Cosmic Dust");

        private final String displayName;

        private FootprintType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

