/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc;

import github.jorgaomc.FootprintTracker;
import github.jorgaomc.LMStructures;
import github.jorgaomc.ModBlockEntitiesSign;
import github.jorgaomc.ModBlocks;
import github.jorgaomc.ModFeatures;
import github.jorgaomc.ModItems;
import github.jorgaomc.blocks.entity.ModBlockEntities;
import github.jorgaomc.client.screen.KeyItemsScreenHandler;
import github.jorgaomc.component.ModDataComponentTypes;
import github.jorgaomc.config.PedestalConfig;
import github.jorgaomc.data.KeyItemsDataManager;
import github.jorgaomc.data.PlayerAppData;
import github.jorgaomc.effect.ModEffects;
import github.jorgaomc.entities.ModEntities;
import github.jorgaomc.event.ArceusEventHandler;
import github.jorgaomc.event.DreamStringEventHandler;
import github.jorgaomc.event.KeyItemsEventHandler;
import github.jorgaomc.event.SacredAshEventHandler;
import github.jorgaomc.event.UrnEventHandler;
import github.jorgaomc.item.AzureFluteTeleporter;
import github.jorgaomc.network.EnderChestOpenPacket;
import github.jorgaomc.network.HealPacket;
import github.jorgaomc.network.KeyItemsOpenPacket;
import github.jorgaomc.network.LegendaryTrackingPayloads;
import github.jorgaomc.network.PCOpenPacket;
import github.jorgaomc.network.RegiStatueUpdatePacket;
import github.jorgaomc.network.SanctuaryOpenScreenS2CPacket;
import github.jorgaomc.network.SanctuaryUpdateC2SPacket;
import github.jorgaomc.particles.ModParticles;
import github.jorgaomc.screen.ModScreenHandlers;
import github.jorgaomc.screen.SanctuaryScreenHandler;
import github.jorgaomc.util.ModLootTableModifiers;
import github.jorgaomc.villager.ModVillagers;
import github.jorgaomc.world.CosmicDustFeature;
import github.jorgaomc.world.CosmicDustPlacement;
import github.jorgaomc.world.FootprintFeature;
import github.jorgaomc.world.FootprintPlacement;
import github.jorgaomc.world.IlexShrineFeature;
import github.jorgaomc.world.IlexShrinePlacement;
import github.jorgaomc.world.ModDimensions;
import github.jorgaomc.world.ModPlacedFeatures;
import github.jorgaomc.world.StakeFeature;
import github.jorgaomc.world.StakePlacement;
import github.jorgaomc.world.dimension.DistortionWorld;
import github.jorgaomc.world.dimension.HallOfOriginWorld;
import github.jorgaomc.world.feature.DistortionTreeFeature;
import github.jorgaomc.world.feature.MiniMountainFeature;
import github.jorgaomc.world.gen.ModOreGeneration;
import github.jorgaomc.world.processor.NetherOpenAreaProcessor;
import github.jorgaomc.world.worldgen.NetherOpenAreaPlacementModifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegendaryMonuments
implements ModInitializer {
    private static final Map<UUID, Map<String, BlockPos>> LAST_LOCATED = new HashMap<UUID, Map<String, BlockPos>>();
    private static final Map<UUID, Map<String, Set<BlockPos>>> COMPLETED_LOCATIONS = new HashMap<UUID, Map<String, Set<BlockPos>>>();
    public static final String MOD_ID = "legendarymonuments";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"legendarymonuments");
    public static final MenuType<KeyItemsScreenHandler> KEY_ITEMS_SCREEN_HANDLER = (MenuType)Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"key_items"), (Object)new MenuType(KeyItemsScreenHandler::new, FeatureFlags.VANILLA_SET));

    public void onInitialize() {
        LOGGER.info("Initializing Legendary Monuments mod!");
        ModEntities.register();
        ModDimensions.initialize();
        DistortionWorld.register();
        HallOfOriginWorld.register();
        AzureFluteTeleporter.register();
        SanctuaryScreenHandler.SANCTUARY_SCREEN_HANDLER = (MenuType)Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jorgaomc", (String)"sanctuary"), (Object)new MenuType(SanctuaryScreenHandler::new, null));
        PCOpenPacket.registerPayload();
        PCOpenPacket.registerServerReceiver();
        HealPacket.registerPayload();
        HealPacket.registerServerReceiver();
        EnderChestOpenPacket.registerPayload();
        EnderChestOpenPacket.registerServerReceiver();
        KeyItemsOpenPacket.registerPayload();
        KeyItemsOpenPacket.registerServer();
        RegiStatueUpdatePacket.registerPayloadType();
        RegiStatueUpdatePacket.registerServerReceiver();
        SanctuaryUpdateC2SPacket.register();
        SanctuaryOpenScreenS2CPacket.registerPayloadType();
        PayloadTypeRegistry.playC2S().register(LegendaryTrackingPayloads.LocateRequestPayload.ID, LegendaryTrackingPayloads.LocateRequestPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(LegendaryTrackingPayloads.LocateResponsePayload.ID, LegendaryTrackingPayloads.LocateResponsePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(LegendaryTrackingPayloads.KeyItemCheckRequestPayload.ID, LegendaryTrackingPayloads.KeyItemCheckRequestPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(LegendaryTrackingPayloads.KeyItemCheckResponsePayload.ID, LegendaryTrackingPayloads.KeyItemCheckResponsePayload.CODEC);
        this.registerServerPacketHandlers();
        ModScreenHandlers.registerScreenHandlers();
        LMStructures.registerStructureTypes();
        ModVillagers.registerVillagers();
        ModVillagers.registerTrades();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            LOGGER.info("Server started event triggered, initializing FootprintTracker...");
            FootprintTracker.initializeStorage(server);
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            LOGGER.info("Player {} disconnected, saving their progress data", (Object)handler.player.getName().getString());
            FootprintTracker.savePlayerData(handler.player);
        });
        ModDataComponentTypes.registerComponentTypes();
        ModBlocks.registerBlocks();
        ModBlockEntitiesSign.registerBlockEntities();
        ModBlockEntities.registerBlockEntities();
        ModItems.registerItems();
        ModEffects.registerEffects();
        PedestalConfig.loadConfig();
        ModParticles.registerParticles();
        KeyItemsEventHandler.register();
        UrnEventHandler.register();
        DreamStringEventHandler.register();
        SacredAshEventHandler.register();
        ArceusEventHandler.register();
        FuelRegistry.INSTANCE.add((ItemLike)ModItems.GALAR_PARTICLE, (Object)1600);
        FuelRegistry.INSTANCE.add((ItemLike)ModBlocks.GALAR_PARTICLE_BLOCK.asItem(), (Object)16000);
        FuelRegistry.INSTANCE.add((ItemLike)ModBlocks.DISTORTION_LOG, (Object)300);
        FuelRegistry.INSTANCE.add((ItemLike)ModBlocks.DISTORTION_LOG, (Object)300);
        FuelRegistry.INSTANCE.add((ItemLike)ModBlocks.DISTORTION_PLANKS, (Object)300);
        FuelRegistry.INSTANCE.add((ItemLike)ModBlocks.DISTORTION_SLAB, (Object)150);
        FuelRegistry.INSTANCE.add((ItemLike)ModBlocks.DISTORTION_STAIRS, (Object)300);
        FuelRegistry.INSTANCE.add((ItemLike)ModBlocks.DISTORTION_FENCE, (Object)300);
        FuelRegistry.INSTANCE.add((ItemLike)ModBlocks.DISTORTION_FENCE_GATE, (Object)300);
        FuelRegistry.INSTANCE.add((ItemLike)ModBlocks.DISTORTION_SIGN, (Object)200);
        FuelRegistry.INSTANCE.add((ItemLike)ModBlocks.DISTORTION_PRESSURE_PLATE, (Object)300);
        FuelRegistry.INSTANCE.add((ItemLike)ModBlocks.DISTORTION_BUTTON, (Object)100);
        LOGGER.info("Registering world generation features...");
        ModFeatures.registerFeatures();
        NetherOpenAreaPlacementModifier.register();
        NetherOpenAreaProcessor.register();
        ModBlockEntities.registerBlockEntities();
        FootprintFeature.register();
        FootprintPlacement.registerPlacements();
        IlexShrineFeature.register();
        IlexShrinePlacement.registerPlacements();
        StakeFeature.register();
        StakePlacement.registerPlacements();
        CosmicDustFeature.register();
        CosmicDustPlacement.registerPlacements();
        DistortionTreeFeature.register();
        MiniMountainFeature.register();
        LOGGER.info("Registering ore generation...");
        ModPlacedFeatures.registerPlacedFeatures();
        LOGGER.info("Applying ore generation to biomes...");
        ModOreGeneration.generateOres();
        ModLootTableModifiers.modifyLootTables();
        this.registerPlayerEvents();
        LOGGER.info("Footprint tracking system initialized. Players will need to find {} of each footprint type.", (Object)50);
        LOGGER.info("Legendary Monuments mod initialization complete!");
    }

    private void registerServerPacketHandlers() {
        ServerPlayNetworking.registerGlobalReceiver(LegendaryTrackingPayloads.LocateRequestPayload.ID, (payload, context) -> context.server().execute(() -> {
            try {
                this.handleLocateRequest((LegendaryTrackingPayloads.LocateRequestPayload)payload, context);
            }
            catch (Exception e) {
                LOGGER.error("Error handling locate request for {}: {}", (Object)payload.structureId(), (Object)e.getMessage());
                this.sendNotFoundResponse(payload.structureId(), context);
            }
        }));
        LOGGER.info("Registered server locate request handler");
        ServerPlayNetworking.registerGlobalReceiver(LegendaryTrackingPayloads.KeyItemCheckRequestPayload.ID, (payload, context) -> context.server().execute(() -> {
            try {
                ServerPlayer player = context.player();
                String itemId = payload.itemId();
                ResourceLocation iid = ResourceLocation.tryParse((String)itemId);
                Item item = iid == null ? null : (Item)BuiltInRegistries.ITEM.get(iid);
                boolean has = false;
                if (item != null) {
                    try {
                        has = KeyItemsDataManager.hasKeyItem((Player)player, item);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                LegendaryTrackingPayloads.KeyItemCheckResponsePayload resp = new LegendaryTrackingPayloads.KeyItemCheckResponsePayload(itemId, has);
                ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)resp);
            }
            catch (Exception e) {
                LOGGER.error("Error handling key item check: {}", (Object)e.getMessage(), (Object)e);
            }
        }));
    }

    private void handleLocateRequest(LegendaryTrackingPayloads.LocateRequestPayload payload, ServerPlayNetworking.Context context) {
        ServerPlayer player = context.player();
        ServerLevel world = player.serverLevel();
        LOGGER.info("Processing locate request for: {} from player: {} at: {}", new Object[]{payload.structureId(), player.getName().getString(), payload.playerPos()});
        try {
            Map lastMap;
            BlockPos last;
            BlockPos playerPos = payload.playerPos();
            BlockPos structurePos = null;
            String structureId = payload.structureId();
            UUID uuid = context.player().getUUID();
            if (payload.isCompleted() && (last = (BlockPos)(lastMap = LAST_LOCATED.computeIfAbsent(uuid, u -> new HashMap())).get(structureId)) != null) {
                Map compMap = COMPLETED_LOCATIONS.computeIfAbsent(uuid, u -> new HashMap());
                Set set = compMap.computeIfAbsent(structureId, s -> new HashSet());
                set.add(last);
            }
            Item required = LegendaryMonuments.getRequiredItemFor(structureId);
            boolean hasInInventory = false;
            if (required != null) {
                for (ItemStack stack : player.getInventory().items) {
                    if (stack.isEmpty() || stack.getItem() != required) continue;
                    hasInInventory = true;
                    break;
                }
            }
            boolean hasInKeyItems = false;
            try {
                hasInKeyItems = KeyItemsDataManager.hasKeyItem((Player)player, required);
            }
            catch (Throwable stack) {
                // empty catch block
            }
            if (required != null && !hasInInventory && !hasInKeyItems) {
                LOGGER.info("Player {} missing required item {} for {}", new Object[]{player.getName().getString(), required == null ? "<none>" : BuiltInRegistries.ITEM.getKey((Object)required), structureId});
                this.sendNotFoundResponse(structureId, context);
                return;
            }
            ResourceKey directKey = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.tryParse((String)structureId));
            TagKey tag = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.tryParse((String)structureId));
            ResourceLocation setId = LegendaryMonuments.getStructureSetIdFor(structureId);
            if (setId != null) {
                tag = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)setId);
            }
            int searchRadius = 20000;
            try {
                structurePos = world.findNearestMapStructure(tag, playerPos, searchRadius, false);
                LOGGER.info("Locate result (skipReferenced=false) for {}: {}", (Object)structureId, (Object)structurePos);
            }
            catch (Exception e) {
                LOGGER.warn("Primary locate failed for {}: {}", (Object)structureId, (Object)e.getMessage());
            }
            if (structurePos == null) {
                try {
                    structurePos = world.findNearestMapStructure(tag, playerPos, searchRadius, true);
                    LOGGER.info("Locate result (skipReferenced=true) for {}: {}", (Object)structureId, (Object)structurePos);
                }
                catch (Exception e) {
                    LOGGER.warn("Secondary locate failed for {}: {}", (Object)structureId, (Object)e.getMessage());
                }
            }
            Set completedSet = COMPLETED_LOCATIONS.computeIfAbsent(uuid, u -> new HashMap()).getOrDefault(structureId, Collections.emptySet());
            boolean isCompletedPos = false;
            if (structurePos != null) {
                for (BlockPos p : completedSet) {
                    if (!p.closerThan((Vec3i)structurePos, 8.0)) continue;
                    isCompletedPos = true;
                    break;
                }
            }
            if (isCompletedPos) {
                BlockPos candidate = structurePos;
                int[] distances = new int[]{4000, 8000, 12000, 16000};
                boolean foundDifferent = false;
                for (int dist : distances) {
                    for (int i = 0; i < 8; ++i) {
                        double ang = Math.PI * 2 * (double)i / 8.0;
                        BlockPos altCenter = playerPos.offset((int)(Math.cos(ang) * (double)dist), 0, (int)(Math.sin(ang) * (double)dist));
                        try {
                            candidate = world.findNearestMapStructure(tag, altCenter, searchRadius, false);
                            if (candidate == null) {
                                candidate = world.findNearestMapStructure(tag, altCenter, searchRadius, true);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        boolean candidateCompleted = false;
                        if (candidate != null) {
                            for (BlockPos p : completedSet) {
                                if (!p.closerThan((Vec3i)candidate, 8.0)) continue;
                                candidateCompleted = true;
                                break;
                            }
                        }
                        if (candidate == null || candidateCompleted) continue;
                        structurePos = candidate;
                        foundDifferent = true;
                        break;
                    }
                    if (foundDifferent) break;
                }
            }
            if (structurePos != null) {
                LAST_LOCATED.computeIfAbsent(uuid, u -> new HashMap()).put(structureId, structurePos);
                LegendaryTrackingPayloads.LocateResponsePayload response = new LegendaryTrackingPayloads.LocateResponsePayload(payload.structureId(), true, structurePos);
                ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)response);
                LOGGER.info("Sent locate response for {}: {}", (Object)payload.structureId(), (Object)structurePos);
            } else {
                LOGGER.info("Structure {} not found", (Object)payload.structureId());
                this.sendNotFoundResponse(payload.structureId(), context);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error locating structure {}: {}", new Object[]{payload.structureId(), e.getMessage(), e});
            this.sendNotFoundResponse(payload.structureId(), context);
        }
    }

    private static Item getRequiredItemFor(String structureId) {
        String path;
        if (structureId == null) {
            return null;
        }
        return switch (path = structureId.contains(":") ? structureId.substring(structureId.indexOf(58) + 1) : structureId) {
            case "dragonspiraltower" -> ModItems.LIGHTSTONE_SHARD;
            case "turnback_cave" -> Items.TRIAL_KEY;
            case "bell_tower" -> ModItems.RAINBOW_FEATHER;
            case "burned_tower" -> Items.FIRE_CHARGE;
            case "heatran_cave" -> ModItems.MAGMA_STONE;
            case "firescourge_shrine" -> ModItems.FIRESCOURGE_SEAL;
            case "grasswither_shrine" -> ModItems.GRASSWITHER_SEAL;
            case "groundblight_shrine" -> ModItems.GROUNDBLIGHT_SEAL;
            case "icerend_shrine" -> ModItems.ICEREND_SEAL;
            case "outskirt_stand" -> Items.EMERALD;
            case "southern_island" -> Items.AXOLOTL_BUCKET;
            case "svpokecenter" -> Items.GOLDEN_APPLE;
            case "lugia_temple" -> ModItems.VORTEX_STONE;
            case "eternatus_cocoon" -> ModItems.GALAR_PARTICLE;
            case "sword" -> Items.IRON_SWORD;
            case "shield" -> Items.IRON_SWORD;
            case "kyuremcave" -> ModItems.IDEALS_BOTTLE;
            case "dyna_tree" -> Items.CHERRY_SAPLING;
            case "giratina_island" -> Items.NETHERITE_SCRAP;
            case "final_island" -> ModItems.OLD_SEA_MAP;
            case "snowpoint_temple" -> ModItems.GOLEM_SCRAP;
            case "spear_pillar" -> ModItems.RED_CHAIN;
            case "lake_valor" -> Items.FERMENTED_SPIDER_EYE;
            case "lake_acuity" -> Items.SWEET_BERRIES;
            case "lake_verity" -> Items.GLOW_BERRIES;
            default -> null;
        };
    }

    private static ResourceLocation getStructureSetIdFor(String structureId) {
        String path;
        if (structureId == null) {
            return null;
        }
        switch (path = structureId.contains(":") ? structureId.substring(structureId.indexOf(58) + 1) : structureId) {
            case "bell_tower": {
                return ModItems.BELL_TOWER_STRUCTURE_SET.location();
            }
            case "hoopa_pyramid": {
                return ModItems.HOOPA_PYRAMID_STRUCTURE_SET.location();
            }
            case "eternatus_cocoon": {
                return ModItems.ETERNATUS_COCOON_STRUCTURE_SET.location();
            }
            case "lugia_temple": {
                return ModItems.LUGIA_TEMPLE_STRUCTURE_SET.location();
            }
            case "kyuremcave": {
                return ModItems.KYUREM_CAVE_STRUCTURE_SET.location();
            }
            case "regice_temple": {
                return ModItems.REGICE_TEMPLE_STRUCTURE_SET.location();
            }
            case "regirock_temple": {
                return ModItems.REGIROCK_TEMPLE_STRUCTURE_SET.location();
            }
            case "registeel_temple": {
                return ModItems.REGISTEEL_TEMPLE_STRUCTURE_SET.location();
            }
            case "regigigas_temple": {
                return ModItems.REGIGIGAS_TEMPLE_STRUCTURE_SET.location();
            }
            case "dragonspiraltower": {
                return ModItems.DRAGONSPIRAL_TOWER_STRUCTURE_SET.location();
            }
            case "sword": {
                return ModItems.SWORD_STRUCTURE_SET.location();
            }
            case "shield": {
                return ModItems.SHIELD_STRUCTURE_SET.location();
            }
            case "dragoeleki_temple": {
                return ModItems.DRAGOELEKI_TEMPLE_STRUCTURE_SET.location();
            }
            case "dyna_tree": {
                return ModItems.DYNA_TREE_STRUCTURE_SET.location();
            }
            case "southern_island": {
                return ModItems.SOUTHERN_ISLAND_STRUCTURE_SET.location();
            }
            case "heatran_cave": {
                return ModItems.HEATRAN_CAVE_STRUCTURE_SET.location();
            }
            case "burned_tower": {
                return ModItems.BURNED_TOWER_STRUCTURE_SET.location();
            }
            case "giratina_island": {
                return ModItems.GIRATINA_ISLAND_STRUCTURE_SET.location();
            }
            case "final_island": {
                return ModItems.FINAL_ISLAND_STRUCTURE_SET.location();
            }
            case "snowpoint_temple": {
                return ModItems.SNOWPOINT_TEMPLE_STRUCTURE_SET.location();
            }
            case "spear_pillar": {
                return ModItems.SPEAR_PILLAR_STRUCTURE_SET.location();
            }
            case "turnback_cave": {
                return ModItems.TURNBACK_CAVE_STRUCTURE_SET.location();
            }
            case "grasswither_shrine": {
                return ModItems.GRASSWITHER_SHRINE_STRUCTURE_SET.location();
            }
            case "firescourge_shrine": {
                return ModItems.FIRESCOURGE_SHRINE_STRUCTURE_SET.location();
            }
            case "groundblight_shrine": {
                return ModItems.GROUNDBLIGHT_SHRINE_STRUCTURE_SET.location();
            }
            case "icerend_shrine": {
                return ModItems.ICEREND_SHRINE_STRUCTURE_SET.location();
            }
        }
        return null;
    }

    private void sendNotFoundResponse(String structureId, ServerPlayNetworking.Context context) {
        LegendaryTrackingPayloads.LocateResponsePayload response = new LegendaryTrackingPayloads.LocateResponsePayload(structureId, false, BlockPos.ZERO);
        ServerPlayNetworking.send((ServerPlayer)context.player(), (CustomPacketPayload)response);
        LOGGER.info("Sent 'not found' response for: {}", (Object)structureId);
    }

    private void registerPlayerEvents() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            try {
                LOGGER.info("Initializing progress storage systems");
                FootprintTracker.initializeStorage(server);
                PlayerAppData.initializeStorage(server);
            }
            catch (Exception e) {
                LOGGER.error("Failed to initialize storage systems", (Throwable)e);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            try {
                ServerPlayer player = handler.getPlayer();
                if (player != null) {
                    LOGGER.info("Player {} joined, loading progress data", (Object)player.getName().getString());
                    FootprintTracker.loadPlayerProgress(player);
                    PlayerAppData.loadPlayerData(player);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error loading player progress data on join", (Throwable)e);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            try {
                ServerPlayer player = handler.getPlayer();
                if (player != null) {
                    LOGGER.info("Player {} disconnected, saving their progress data", (Object)player.getName().getString());
                    FootprintTracker.savePlayerData(player);
                    PlayerAppData.savePlayerData(player);
                    if (!player.level().isClientSide()) {
                        ServerLevel serverWorld = (ServerLevel)player.level();
                        KeyItemsDataManager dataManager = KeyItemsDataManager.getOrCreate(serverWorld);
                        dataManager.setDirty();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error saving player progress data on disconnect", (Throwable)e);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            try {
                LOGGER.info("Server stopping, saving all player progress data");
                FootprintTracker.saveAllPlayerData();
                PlayerAppData.saveAllPlayerData();
                for (ServerLevel world : server.getAllLevels()) {
                    KeyItemsDataManager dataManager = KeyItemsDataManager.getOrCreate(world);
                    dataManager.setDirty();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error saving all player progress data on server stop", (Throwable)e);
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            Thread autosaveThread = new Thread(() -> {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(300000L);
                            server.execute(() -> {
                                try {
                                    FootprintTracker.saveAllPlayerData();
                                    for (ServerLevel world : server.getAllLevels()) {
                                        KeyItemsDataManager dataManager = KeyItemsDataManager.getOrCreate(world);
                                        dataManager.setDirty();
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.error("Error during periodic auto-save", (Throwable)e);
                                }
                            });
                        }
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Autosave thread interrupted", (Throwable)e);
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.error("Unexpected error in autosave thread", (Throwable)e);
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException ie) {
                            break;
                        }
                    }
                }
            });
            autosaveThread.setDaemon(true);
            autosaveThread.setName("LegendaryMonuments-Autosave");
            autosaveThread.start();
        });
    }

    public static void spawnLegendaryPokemon(ServerPlayer player, String pokemonName, boolean isShiny) {
        int x = (int)Math.floor(player.getX());
        int y = (int)Math.floor(player.getY());
        int z = (int)Math.floor(player.getZ());
        String command = "pokespawnat " + x + " " + y + " " + z + " " + pokemonName + " lvl=70";
        if (isShiny) {
            command = command + " shiny";
        }
        LOGGER.info("Executing command to spawn {}: {}", (Object)pokemonName, (Object)command);
        player.getServer().getCommands().performPrefixedCommand(player.getServer().createCommandSourceStack(), command);
    }
}

