/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks;

import com.mojang.serialization.MapCodec;
import github.jorgaomc.ModItems;
import github.jorgaomc.blocks.entity.BasePedestalBlockEntity;
import github.jorgaomc.blocks.entity.DialgaPedestalBlockEntity;
import github.jorgaomc.blocks.entity.PalkiaPedestalBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class BasePedestalBlock
extends BaseEntityBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);

    public BasePedestalBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected abstract MapCodec<? extends BaseEntityBlock> codec();

    @Nullable
    public abstract BlockEntity newBlockEntity(BlockPos var1, BlockState var2);

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof BasePedestalBlockEntity) {
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)((BasePedestalBlockEntity)blockEntity));
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BasePedestalBlockEntity) {
            ItemStack stackOnPedestal;
            BasePedestalBlockEntity pedestalBlockEntity = (BasePedestalBlockEntity)blockEntity;
            if (pedestalBlockEntity.isEmpty() && !stack.isEmpty()) {
                ItemStack stackCopy = stack.copyWithCount(1);
                pedestalBlockEntity.setItem(0, stackCopy);
                boolean specialActionPerformed = pedestalBlockEntity.handleSpecialAction(player, stackCopy);
                if (!specialActionPerformed) {
                    world.playSound(player, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 2.0f);
                }
                if (!player.isCreative()) {
                    boolean isPalkiaOrDialga;
                    boolean bl = isPalkiaOrDialga = pedestalBlockEntity instanceof PalkiaPedestalBlockEntity || pedestalBlockEntity instanceof DialgaPedestalBlockEntity;
                    if (specialActionPerformed && isPalkiaOrDialga && stack.is(ModItems.RED_CHAIN)) {
                        stack.shrink(1);
                        ItemStack fragmented = new ItemStack((ItemLike)ModItems.FRAGMENTED_RED_CHAIN);
                        fragmented.setDamageValue(fragmented.getMaxDamage());
                        if (!player.getInventory().add(fragmented)) {
                            player.drop(fragmented, false);
                        }
                    } else {
                        stack.shrink(1);
                    }
                }
                pedestalBlockEntity.setChanged();
                world.sendBlockUpdated(pos, state, state, 0);
                return ItemInteractionResult.SUCCESS;
            }
            if (stack.isEmpty() && !player.isShiftKeyDown() && !(stackOnPedestal = pedestalBlockEntity.getItem(0)).isEmpty()) {
                player.setItemInHand(InteractionHand.MAIN_HAND, stackOnPedestal);
                world.playSound(player, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
                pedestalBlockEntity.clearContent();
                pedestalBlockEntity.setChanged();
                world.sendBlockUpdated(pos, state, state, 3);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.SUCCESS;
    }
}

