/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks;

import github.jorgaomc.ModBlocks;
import github.jorgaomc.world.feature.DistortionTreeFeature;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DistortionTreeSaplingBlock
extends SaplingBlock {
    public DistortionTreeSaplingBlock(BlockBehaviour.Properties settings) {
        super(null, settings.noOcclusion());
    }

    protected boolean mayPlaceOn(BlockState floor, BlockGetter world, BlockPos pos) {
        return floor.is(ModBlocks.DISTORTION_COBBLESTONE);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (world.getMaxLocalRawBrightness(pos.above()) >= 9 && random.nextInt(200) == 0) {
            this.advanceTree(world, pos, state, random);
        }
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (random.nextInt(3) == 0) {
            this.advanceTree(world, pos, state, random);
        }
    }

    public void advanceTree(ServerLevel world, BlockPos pos, BlockState state, RandomSource random) {
        world.removeBlock(pos, false);
        FeaturePlaceContext context = new FeaturePlaceContext(Optional.empty(), (WorldGenLevel)world, world.getChunkSource().getGenerator(), random, pos, (FeatureConfiguration)NoneFeatureConfiguration.INSTANCE);
        if (!DistortionTreeFeature.DISTORTION_TREE_FEATURE.place(context)) {
            world.setBlock(pos, state, 3);
        }
    }
}

