/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks;

import github.jorgaomc.effect.ModEffects;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class DreamCatcherBlock
extends Block {
    public DreamCatcherBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public boolean skipRendering(BlockState state, BlockState adjacentState, Direction side) {
        return adjacentState.is((Block)this) || super.skipRendering(state, adjacentState, side);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockAbove = pos.above();
        return world.getBlockState(blockAbove).isSolid();
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!world.isClientSide()) {
            world.scheduleTick(pos, (Block)this, 20);
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!world.isClientSide()) {
            this.applyDreamCatcherEffect(world, pos);
            world.scheduleTick(pos, (Block)this, 100);
        }
    }

    private void applyDreamCatcherEffect(ServerLevel world, BlockPos pos) {
        AABB effectBox = new AABB(pos).inflate(8.0);
        List playersInRange = world.getEntitiesOfClass(Player.class, effectBox, player -> true);
        for (Player player2 : playersInRange) {
            Holder entry = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)ModEffects.LUCID_DREAMING);
            MobEffectInstance effect = new MobEffectInstance(entry, 240, 0, false, true, true);
            player2.addEffect(effect);
        }
    }
}

