/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks;

import com.mojang.serialization.MapCodec;
import github.jorgaomc.ModItems;
import github.jorgaomc.blocks.MultiBlockBase;
import github.jorgaomc.blocks.entity.EternatusCocoonBlockEntity;
import github.jorgaomc.particles.ModParticles;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EternatusCocoonBlock
extends MultiBlockBase
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final MapCodec<EternatusCocoonBlock> CODEC = MapCodec.unit(() -> null);
    private static final VoxelShape MAIN_SHAPE = Shapes.block();
    private static final VoxelShape INVISIBLE_SHAPE = Shapes.block();

    public MapCodec<? extends Block> codec() {
        return MapCodec.unit((Object)((Object)this));
    }

    public EternatusCocoonBlock(BlockBehaviour.Properties settings) {
        super(settings.noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)MAIN, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)MAIN, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    @Override
    public BlockPos[] getOccupiedPositions(BlockPos mainPos) {
        BlockState tempState = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH);
        return this.getOccupiedPositionsWithState(null, mainPos, tempState);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return MAIN_SHAPE;
    }

    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.getValue((Property)MAIN) == false;
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction direction) {
        if (!((Boolean)state.getValue((Property)MAIN)).booleanValue()) {
            return true;
        }
        if (adjacentBlockState.is((Block)this)) {
            return true;
        }
        return super.skipRendering(state, adjacentBlockState, direction);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)MAIN) != false ? new EternatusCocoonBlockEntity(pos, state) : null;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockPos mainPos;
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.getValue((Property)MAIN)).booleanValue()) {
            mainPos = pos;
        } else {
            Optional<BlockPos> optMainPos = this.findMainBlock(world, pos, state);
            if (optMainPos.isEmpty()) {
                return InteractionResult.FAIL;
            }
            mainPos = optMainPos.get();
        }
        BlockEntity blockEntity = world.getBlockEntity(mainPos);
        if (blockEntity instanceof EternatusCocoonBlockEntity) {
            EternatusCocoonBlockEntity blockEntity2 = (EternatusCocoonBlockEntity)blockEntity;
            if (blockEntity2.isReady()) {
                this.spawnEternatus((ServerLevel)world, mainPos, player);
                return InteractionResult.SUCCESS;
            }
            boolean hasParticles = player.getInventory().hasAnyMatching(stack -> stack.is(ModItems.GALAR_PARTICLE));
            if (!hasParticles) {
                player.displayClientMessage((Component)Component.literal((String)"You don't have any galar particles").withStyle(ChatFormatting.LIGHT_PURPLE), true);
                return InteractionResult.SUCCESS;
            }
            boolean readyToBreak = blockEntity2.consumeGalarParticles(player);
            if (!readyToBreak) {
                ((ServerLevel)world).playSound(null, (double)mainPos.getX() + 0.5, (double)mainPos.getY() + 0.5, (double)mainPos.getZ() + 0.5, SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 1.0f, 1.5f);
                player.displayClientMessage((Component)Component.literal((String)(blockEntity2.getParticlesConsumed() + "/500 galar particles consumed")).withStyle(ChatFormatting.LIGHT_PURPLE), true);
            } else {
                this.spawnEternatus((ServerLevel)world, mainPos, player);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BlockPos[] getOccupiedPositionsWithState(LevelReader world, BlockPos mainPos, BlockState state) {
        BlockPos[] positions = new BlockPos[27];
        int index = 0;
        for (int y = 0; y < 3; ++y) {
            for (int z = -1; z <= 1; ++z) {
                for (int x = -1; x <= 1; ++x) {
                    positions[index++] = mainPos.offset(x, y, z);
                }
            }
        }
        return positions;
    }

    private void spawnEternatus(ServerLevel world, BlockPos pos, Player player) {
        BlockPos middlePos = pos.above();
        this.createParticleExplosion(world, middlePos);
        world.playSound(null, (double)middlePos.getX(), (double)middlePos.getY(), (double)middlePos.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 1.0f, 0.8f);
        world.getServer().execute(() -> {
            BlockPos[] positions;
            System.out.println("Forcibly removing all cocoon blocks in the area");
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    for (int x = -2; x <= 2; ++x) {
                        BlockPos checkPos = middlePos.offset(x, y, z);
                        BlockState blockState = world.getBlockState(checkPos);
                        if (!blockState.is((Block)this)) continue;
                        world.removeBlock(checkPos, false);
                        System.out.println("Removed cocoon block at " + String.valueOf(checkPos));
                    }
                }
            }
            for (BlockPos blockPos : positions = this.getOccupiedPositionsWithState((LevelReader)world, pos, world.getBlockState(pos))) {
                if (!world.getBlockState(blockPos).is((Block)this)) continue;
                world.removeBlock(blockPos, false);
                System.out.println("Removed remaining block at " + String.valueOf(blockPos));
            }
            boolean isShiny = world.getRandom().nextFloat() < 0.02f;
            String dimensionId = world.dimension().location().toString();
            Object command = String.format("pokespawnat %d %d %d eternatus lvl=70", middlePos.getX(), middlePos.getY(), middlePos.getZ());
            if (isShiny) {
                command = (String)command + " shiny";
            }
            System.out.println("Executing command in dimension " + dimensionId + ": " + (String)command);
            CommandSourceStack commandSource = world.getServer().createCommandSourceStack().withLevel(world).withPosition(new Vec3((double)middlePos.getX(), (double)middlePos.getY(), (double)middlePos.getZ()));
            world.getServer().getCommands().performPrefixedCommand(commandSource, (String)command);
            MutableComponent message = isShiny ? Component.literal((String)"Shiny Eternatus is here, brace yourself for annihilation").withStyle(ChatFormatting.GOLD) : Component.literal((String)"Eternatus is here, brace yourself for annihilation").withStyle(ChatFormatting.LIGHT_PURPLE);
            player.displayClientMessage((Component)message, false);
        });
    }

    private void createParticleExplosion(ServerLevel world, BlockPos centerPos) {
        for (int i = 0; i < 500; ++i) {
            double offsetZ;
            double offsetY;
            double offsetX = world.random.nextDouble() * 6.0 - 3.0;
            if (offsetX * offsetX + (offsetY = world.random.nextDouble() * 6.0 - 3.0) * offsetY + (offsetZ = world.random.nextDouble() * 6.0 - 3.0) * offsetZ > 9.0) continue;
            double x = (double)centerPos.getX() + 0.5 + offsetX;
            double y = (double)centerPos.getY() + 0.5 + offsetY;
            double z = (double)centerPos.getZ() + 0.5 + offsetZ;
            double speed = 0.15 + world.random.nextDouble() * 0.3;
            double vx = offsetX * speed;
            double vy = offsetY * speed;
            double vz = offsetZ * speed;
            int particleType = world.random.nextInt(3);
            if (particleType == 0) {
                world.sendParticles((ParticleOptions)ModParticles.GROW1, x, y, z, 1, vx, vy, vz, 0.1);
                continue;
            }
            if (particleType == 1) {
                world.sendParticles((ParticleOptions)ModParticles.GROW2, x, y, z, 1, vx, vy, vz, 0.1);
                continue;
            }
            world.sendParticles((ParticleOptions)ModParticles.GROW3, x, y, z, 1, vx, vy, vz, 0.1);
        }
    }

    @Override
    public Optional<BlockPos> findMainBlock(Level world, BlockPos pos, BlockState state) {
        return super.findMainBlock(world, pos, state);
    }
}

