/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks;

import github.jorgaomc.blocks.CorrectRegiLightBlock;
import github.jorgaomc.blocks.RegiStatueBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FalseRegiLightBlock
extends Block {
    public static final BooleanProperty LIT = BooleanProperty.create((String)"lit");
    private static final Map<String, Boolean> wasPlayerOnBlock = new HashMap<String, Boolean>();
    private static final VoxelShape SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0);

    public FalseRegiLightBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (world.isClientSide || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        String key = pos.toString() + "-" + player.getUUID().toString();
        double playerBottomY = player.getY();
        double blockTopY = (double)pos.getY() + 0.0625;
        boolean playerOnBlock = Math.abs(playerBottomY - blockTopY) < 0.1 && player.getX() >= (double)pos.getX() && player.getX() < (double)(pos.getX() + 1) && player.getZ() >= (double)pos.getZ() && player.getZ() < (double)(pos.getZ() + 1);
        Boolean wasOnBlock = wasPlayerOnBlock.getOrDefault(key, false);
        if (playerOnBlock && !wasOnBlock.booleanValue()) {
            world.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)LIT));
            this.checkAndActivateStatues(world, pos);
            wasPlayerOnBlock.put(key, true);
        } else if (!playerOnBlock && wasOnBlock.booleanValue()) {
            wasPlayerOnBlock.put(key, false);
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        super.onRemove(state, world, pos, newState, moved);
        if (!world.isClientSide && !state.is(newState.getBlock())) {
            String posString = pos.toString();
            wasPlayerOnBlock.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(posString + "-"));
            this.checkAndActivateStatues(world, pos);
        }
    }

    private void checkAndActivateStatues(Level world, BlockPos pos) {
        if (world.isClientSide) {
            return;
        }
        for (int x = -10; x <= 10; ++x) {
            for (int y = -10; y <= 10; ++y) {
                for (int z = -10; z <= 10; ++z) {
                    BlockPos checkPos = pos.offset(x, y, z);
                    BlockState checkState = world.getBlockState(checkPos);
                    if (!(checkState.getBlock() instanceof RegiStatueBlock) || !this.areConditionsMet(world, checkPos)) continue;
                    ((RegiStatueBlock)checkState.getBlock()).activateStatue(world, checkPos, checkState);
                }
            }
        }
    }

    private boolean areConditionsMet(Level world, BlockPos statuePos) {
        for (int x = -10; x <= 10; ++x) {
            for (int y = -10; y <= 10; ++y) {
                for (int z = -10; z <= 10; ++z) {
                    BlockPos checkPos = statuePos.offset(x, y, z);
                    BlockState checkState = world.getBlockState(checkPos);
                    if (checkState.getBlock() instanceof CorrectRegiLightBlock && !((Boolean)checkState.getValue((Property)CorrectRegiLightBlock.LIT)).booleanValue()) {
                        return false;
                    }
                    if (!(checkState.getBlock() instanceof FalseRegiLightBlock) || !((Boolean)checkState.getValue((Property)LIT)).booleanValue()) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

