/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks;

import github.jorgaomc.ModItems;
import github.jorgaomc.particles.ModParticles;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;

public class GalarianWallTorchBlock
extends WallTorchBlock {
    public GalarianWallTorchBlock(BlockBehaviour.Properties settings) {
        super(ParticleTypes.FLAME, settings);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (world.isClientSide) {
            Direction direction = (Direction)state.getValue((Property)FACING);
            double d = (double)pos.getX() + 0.5;
            double e = (double)pos.getY() + 0.7;
            double f = (double)pos.getZ() + 0.5;
            double g = 0.22;
            double h = 0.27;
            Direction direction2 = direction.getOpposite();
            double particleX = d + h * (double)direction2.getStepX();
            double particleY = e + g;
            double particleZ = f + h * (double)direction2.getStepZ();
            if (random.nextFloat() < 0.8f) {
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
            }
            if (random.nextFloat() < 0.8f) {
                world.addParticle((ParticleOptions)ModParticles.GALARIAN_FLAME, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
            }
        }
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return Collections.singletonList(new ItemStack((ItemLike)ModItems.GALARIAN_TORCH));
    }
}

