/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks;

import github.jorgaomc.ModItems;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IlexShrineBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    private static final VoxelShape SHAPE = Shapes.block();

    public boolean isTranslucent(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public IlexShrineBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.getClickedPos();
        Level world = ctx.getLevel();
        if (blockPos.getY() < world.getMaxBuildHeight() - 1 && world.getBlockState(blockPos.above()).canBeReplaced(ctx)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection())).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        BlockPos blockPos = pos.above();
        world.setBlock(blockPos, (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (state.getValue(HALF) != DoubleBlockHalf.LOWER) {
            BlockState blockState = world.getBlockState(pos.below());
            return blockState.is((Block)this) && blockState.getValue(HALF) == DoubleBlockHalf.LOWER;
        }
        return super.canSurvive(state, world, pos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        if (half == DoubleBlockHalf.LOWER) {
            return Shapes.or((VoxelShape)SHAPE, (VoxelShape)SHAPE.move(0.0, 1.0, 0.0));
        }
        return Shapes.or((VoxelShape)SHAPE, (VoxelShape)SHAPE.move(0.0, -1.0, 0.0));
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.getValue(HALF);
        BlockPos otherHalfPos = doubleBlockHalf == DoubleBlockHalf.LOWER ? pos.above() : pos.below();
        BlockState otherHalfState = world.getBlockState(otherHalfPos);
        if (otherHalfState.is((Block)this) && otherHalfState.getValue(HALF) != doubleBlockHalf) {
            world.setBlock(otherHalfPos, Blocks.AIR.defaultBlockState(), 35);
            world.levelEvent(player, 2001, otherHalfPos, Block.getId((BlockState)otherHalfState));
        }
        super.playerWillDestroy(world, pos, state, player);
        return otherHalfState;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack handStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (handStack.is(ModItems.GS_BALL)) {
            BlockPos spawnPos = state.getValue(HALF) == DoubleBlockHalf.LOWER ? pos.above() : pos;
            this.playEffectsAndSpawnCelebi((ServerLevel)world, spawnPos, player);
            BlockPos lowerPos = state.getValue(HALF) == DoubleBlockHalf.LOWER ? pos : pos.below();
            BlockPos upperPos = lowerPos.above();
            world.setBlock(lowerPos, Blocks.AIR.defaultBlockState(), 3);
            world.setBlock(upperPos, Blocks.AIR.defaultBlockState(), 3);
            if (!player.isCreative()) {
                handStack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        player.displayClientMessage((Component)Component.literal((String)"This ancient Ilex Shrine seems to be awaiting a special pokeball...").withStyle(ChatFormatting.GREEN), true);
        return InteractionResult.SUCCESS;
    }

    private void playEffectsAndSpawnCelebi(ServerLevel world, BlockPos pos, Player player) {
        world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.BEACON_ACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 50, 0.5, 0.5, 0.5, 0.1);
        boolean isShiny = world.getRandom().nextFloat() < 0.02f;
        Object command = String.format(Locale.US, "pokespawnat %d %.1f %d celebi lvl=40", pos.getX(), (double)pos.getY() + 1.2, pos.getZ());
        if (isShiny) {
            command = (String)command + " shiny";
        }
        world.getServer().getCommands().performPrefixedCommand(world.getServer().createCommandSourceStack().withLevel(world).withPosition(new Vec3((double)pos.getX(), (double)pos.getY() + 1.2, (double)pos.getZ())), (String)command);
        if (isShiny) {
            player.displayClientMessage((Component)Component.literal((String)"The Ilex Shrine crumbles as a SHINY Celebi emerges from the flow of time!").withStyle(ChatFormatting.GOLD), false);
        } else {
            player.displayClientMessage((Component)Component.literal((String)"The Ilex Shrine crumbles as Celebi emerges from the flow of time!").withStyle(ChatFormatting.GREEN), false);
        }
    }
}

