/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks;

import com.mojang.serialization.MapCodec;
import github.jorgaomc.blocks.entity.MeltanBoxBlockEntity;
import github.jorgaomc.util.LegendaryEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MeltanBoxBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final MapCodec<MeltanBoxBlock> CODEC = MapCodec.unit(() -> null);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)18.0, (double)6.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)18.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)6.0, (double)3.0, (double)6.0, (double)10.0), Block.box((double)1.0, (double)6.0, (double)6.0, (double)3.0, (double)18.0, (double)10.0), Block.box((double)13.0, (double)0.0, (double)6.0, (double)16.0, (double)6.0, (double)10.0), Block.box((double)13.0, (double)6.0, (double)6.0, (double)15.0, (double)18.0, (double)10.0), Block.box((double)3.0, (double)0.0, (double)6.0, (double)13.0, (double)18.0, (double)10.0)});

    public MapCodec<? extends Block> codec() {
        return MapCodec.unit((Object)((Object)this));
    }

    public MeltanBoxBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getShape(state, world, pos, context);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST -> this.rotateShape(Direction.NORTH, Direction.EAST, SHAPE);
            case Direction.SOUTH -> this.rotateShape(Direction.NORTH, Direction.SOUTH, SHAPE);
            case Direction.WEST -> this.rotateShape(Direction.NORTH, Direction.WEST, SHAPE);
            default -> SHAPE;
        };
    }

    private VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        if (from == to) {
            return shape;
        }
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (to.get2DDataValue() - from.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MeltanBoxBlockEntity(pos, state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack handStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof MeltanBoxBlockEntity) {
            MeltanBoxBlockEntity blockEntity2 = (MeltanBoxBlockEntity)blockEntity;
            if (blockEntity2.isReady()) {
                this.spawnMeltan((ServerLevel)world, pos, player);
                blockEntity2.reset();
                return InteractionResult.SUCCESS;
            }
            if (handStack.isEmpty()) {
                player.displayClientMessage((Component)Component.literal((String)"You need to fill the box with metals to summon Meltan!").withStyle(ChatFormatting.GRAY), true);
                return InteractionResult.SUCCESS;
            }
            int pointsToAdd = 0;
            if (handStack.is(Items.COPPER_INGOT)) {
                pointsToAdd = 1;
            } else if (handStack.is(Items.IRON_INGOT)) {
                pointsToAdd = 2;
            } else if (handStack.is(Items.GOLD_INGOT)) {
                pointsToAdd = 3;
            } else if (handStack.is(Items.NETHERITE_INGOT)) {
                pointsToAdd = 50;
            } else {
                player.displayClientMessage((Component)Component.literal((String)"This box only accepts metal ingots").withStyle(ChatFormatting.GRAY), true);
                return InteractionResult.SUCCESS;
            }
            int pointsNeeded = 50 - blockEntity2.getPointsCollected();
            int itemsToConsume = Math.min(handStack.getCount(), (pointsNeeded + pointsToAdd - 1) / pointsToAdd);
            if (itemsToConsume <= 0) {
                return InteractionResult.SUCCESS;
            }
            ((ServerLevel)world).playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.ANVIL_LAND, SoundSource.BLOCKS, 0.3f, 1.5f);
            handStack.shrink(itemsToConsume);
            boolean ready = blockEntity2.addPoints(pointsToAdd * itemsToConsume);
            if (!ready) {
                player.displayClientMessage((Component)Component.literal((String)(blockEntity2.getPointsCollected() + "/50 metal value stored")).withStyle(ChatFormatting.GRAY), true);
            } else {
                player.displayClientMessage((Component)Component.literal((String)"The Meltan Box is ready to summon Meltan!").withStyle(ChatFormatting.GRAY), true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void spawnMeltan(ServerLevel world, BlockPos pos, Player player) {
        LegendaryEffects.spawnMeltanEffect(world, pos);
        boolean isShiny = world.getRandom().nextFloat() < 0.02f;
        Object command = String.format("pokespawnat %d %f %d meltan lvl=5", pos.getX(), (double)pos.getY() + 1.2, pos.getZ());
        if (isShiny) {
            command = (String)command + " shiny";
        }
        world.getServer().getCommands().performPrefixedCommand(world.getServer().createCommandSourceStack().withLevel(world).withPosition(new Vec3((double)pos.getX(), (double)pos.getY() + 1.2, (double)pos.getZ())), (String)command);
        MutableComponent message = isShiny ? Component.literal((String)"A SHINY Meltan has appeared from the box!").withStyle(ChatFormatting.GOLD) : Component.literal((String)"A Meltan has appeared from the box!").withStyle(ChatFormatting.GRAY);
        player.displayClientMessage((Component)message, false);
    }
}

