/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks;

import github.jorgaomc.blocks.EternatusCocoonBlock;
import github.jorgaomc.blocks.ShrineBlock;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class MultiBlockBase
extends Block {
    public static final BooleanProperty MAIN = BooleanProperty.create((String)"main");

    public MultiBlockBase(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)MAIN, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{MAIN});
    }

    public abstract BlockPos[] getOccupiedPositions(BlockPos var1);

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (((Boolean)state.getValue((Property)MAIN)).booleanValue()) {
            BlockPos[] positions;
            MultiBlockBase multiBlockBase = this;
            if (multiBlockBase instanceof ShrineBlock) {
                ShrineBlock shrineBlock = (ShrineBlock)multiBlockBase;
                BlockState stateWithFacing = state;
                if (!state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    stateWithFacing = (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH);
                }
                positions = shrineBlock.getOccupiedPositionsWithState(world, pos, stateWithFacing);
            } else {
                positions = this.getOccupiedPositions(pos);
            }
            for (BlockPos blockPos : positions) {
                if (world.getBlockState(blockPos).canBeReplaced()) continue;
                return false;
            }
        }
        return true;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.isClientSide && ((Boolean)state.getValue((Property)MAIN)).booleanValue()) {
            BlockPos[] positions;
            MultiBlockBase multiBlockBase;
            Direction facing = Direction.NORTH;
            if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            }
            if ((multiBlockBase = this) instanceof ShrineBlock) {
                ShrineBlock shrineBlock = (ShrineBlock)multiBlockBase;
                positions = shrineBlock.getOccupiedPositionsWithState((LevelReader)world, pos, state);
            } else {
                multiBlockBase = this;
                if (multiBlockBase instanceof EternatusCocoonBlock) {
                    BlockPos[] cocoonBlock = (BlockPos[])multiBlockBase;
                    positions = cocoonBlock.getOccupiedPositionsWithState((LevelReader)world, pos, state);
                } else {
                    positions = this.getOccupiedPositions(pos);
                }
            }
            BlockPos visiblePos = null;
            if (this instanceof EternatusCocoonBlock) {
                visiblePos = pos.above();
            }
            for (BlockPos blockPos : positions) {
                BlockState newState;
                if (blockPos.equals((Object)pos) || !world.getBlockState(blockPos).canBeReplaced()) continue;
                boolean isMain = false;
                if (visiblePos != null && blockPos.equals((Object)visiblePos)) {
                    isMain = true;
                }
                if ((newState = (BlockState)this.defaultBlockState().setValue((Property)MAIN, (Comparable)Boolean.valueOf(isMain))).hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
                }
                world.setBlockAndUpdate(blockPos, newState);
            }
            if (visiblePos != null) {
                BlockState newState = (BlockState)world.getBlockState(pos).setValue((Property)MAIN, (Comparable)Boolean.valueOf(false));
                if (newState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
                }
                world.setBlockAndUpdate(pos, newState);
            }
        }
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide) {
            BlockPos[] positions;
            BlockPos referencePos;
            if (this instanceof EternatusCocoonBlock) {
                BlockPos mainVisiblePos;
                if (((Boolean)state.getValue((Property)MAIN)).booleanValue()) {
                    mainVisiblePos = pos;
                } else {
                    Optional<BlockPos> optMainPos = this.findMainBlock(world, pos, state);
                    if (optMainPos.isEmpty()) {
                        return super.playerWillDestroy(world, pos, state, player);
                    }
                    mainVisiblePos = optMainPos.get();
                }
                referencePos = mainVisiblePos.below();
                if (!world.getBlockState(referencePos).is((Block)this)) {
                    boolean found = false;
                    for (int x = -1; x <= 1 && !found; ++x) {
                        for (int z = -1; z <= 1 && !found; ++z) {
                            BlockPos checkPos = mainVisiblePos.below().offset(x, 0, z);
                            if (!world.getBlockState(checkPos).is((Block)this)) continue;
                            referencePos = checkPos;
                            found = true;
                        }
                    }
                    if (!found) {
                        referencePos = mainVisiblePos;
                    }
                }
            } else if (((Boolean)state.getValue((Property)MAIN)).booleanValue()) {
                referencePos = pos;
            } else {
                Optional<BlockPos> optMainPos = this.findMainBlock(world, pos, state);
                if (optMainPos.isEmpty()) {
                    return super.playerWillDestroy(world, pos, state, player);
                }
                referencePos = optMainPos.get();
            }
            BlockState referenceState = world.getBlockState(referencePos);
            MultiBlockBase multiBlockBase = this;
            if (multiBlockBase instanceof ShrineBlock) {
                ShrineBlock shrineBlock = (ShrineBlock)multiBlockBase;
                positions = shrineBlock.getOccupiedPositionsWithState((LevelReader)world, referencePos, referenceState);
            } else {
                multiBlockBase = this;
                if (multiBlockBase instanceof EternatusCocoonBlock) {
                    EternatusCocoonBlock cocoonBlock = (EternatusCocoonBlock)multiBlockBase;
                    positions = cocoonBlock.getOccupiedPositionsWithState((LevelReader)world, referencePos, referenceState);
                } else {
                    positions = this.getOccupiedPositions(referencePos);
                }
            }
            BlockPos mainBlockPos = null;
            for (BlockPos blockPos : positions) {
                BlockState blockState = world.getBlockState(blockPos);
                if (!blockState.is((Block)this) || !((Boolean)blockState.getValue((Property)MAIN)).booleanValue()) continue;
                mainBlockPos = blockPos;
                break;
            }
            for (BlockPos blockPos : positions) {
                boolean dropItems;
                if (!world.getBlockState(blockPos).is((Block)this)) continue;
                boolean bl = dropItems = blockPos.equals((Object)mainBlockPos) && blockPos.equals((Object)pos);
                if (blockPos.equals((Object)pos)) continue;
                world.removeBlock(blockPos, dropItems);
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public Optional<BlockPos> findMainBlock(Level world, BlockPos pos, BlockState state) {
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    BlockPos checkPos = pos.offset(x, y, z);
                    BlockState checkState = world.getBlockState(checkPos);
                    if (!checkState.is((Block)this) || !((Boolean)checkState.getValue((Property)MAIN)).booleanValue()) continue;
                    return Optional.of(checkPos);
                }
            }
        }
        return Optional.empty();
    }
}

