/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks;

import com.mojang.serialization.MapCodec;
import github.jorgaomc.blocks.entity.PokemonTrialSpawnerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class PokemonTrialSpawnerBlock
extends BaseEntityBlock {
    public static final MapCodec<PokemonTrialSpawnerBlock> CODEC = PokemonTrialSpawnerBlock.simpleCodec(PokemonTrialSpawnerBlock::new);
    public static final BooleanProperty OMINOUS = BlockStateProperties.OMINOUS;
    public static final EnumProperty<TrialSpawnerState> TRIAL_SPAWNER_STATE = BlockStateProperties.TRIAL_SPAWNER_STATE;

    public PokemonTrialSpawnerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)OMINOUS, (Comparable)Boolean.valueOf(false))).setValue(TRIAL_SPAWNER_STATE, (Comparable)TrialSpawnerState.INACTIVE));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{OMINOUS, TRIAL_SPAWNER_STATE});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (state.getBlock() == this && !state.hasProperty(TRIAL_SPAWNER_STATE)) {
            return this.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PokemonTrialSpawnerBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        if (world.isClientSide) {
            return null;
        }
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof PokemonTrialSpawnerBlockEntity) {
                PokemonTrialSpawnerBlockEntity spawner = (PokemonTrialSpawnerBlockEntity)blockEntity;
                spawner.serverTick((ServerLevel)world1, pos, state1);
            }
        };
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof PokemonTrialSpawnerBlockEntity) {
            PokemonTrialSpawnerBlockEntity spawner = (PokemonTrialSpawnerBlockEntity)blockEntity;
            ItemStack heldItem = player.getMainHandItem();
            if (heldItem.is(Items.OMINOUS_TRIAL_KEY) && !((Boolean)state.getValue((Property)OMINOUS)).booleanValue()) {
                if (!player.getAbilities().instabuild) {
                    heldItem.shrink(1);
                }
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OMINOUS, (Comparable)Boolean.valueOf(true)));
                world.playSound(null, pos, SoundEvents.TRIAL_SPAWNER_OMINOUS_ACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (heldItem.is(Items.TRIAL_KEY) && state.getValue(TRIAL_SPAWNER_STATE) == TrialSpawnerState.INACTIVE) {
                if (!player.getAbilities().instabuild) {
                    heldItem.shrink(1);
                }
                spawner.startTrial(player);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

