/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks;

import github.jorgaomc.ModItems;
import github.jorgaomc.screen.RegiStatueScreen;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RegiStatueBlock
extends Block {
    public static final EnumProperty<RegiType> REGI_TYPE = EnumProperty.create((String)"regi_type", RegiType.class);
    public static final EnumProperty<ActivationState> ACTIVATION = EnumProperty.create((String)"activation", ActivationState.class);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape STATUE_SHAPE;

    public RegiStatueBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(REGI_TYPE, (Comparable)((Object)RegiType.REGIROCK))).setValue(ACTIVATION, (Comparable)((Object)ActivationState.INACTIVE))).setValue(FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{REGI_TYPE, ACTIVATION, FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return STATUE_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return STATUE_SHAPE;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide && player.isCreative() && state.getValue(ACTIVATION) == ActivationState.INACTIVE) {
            this.openRegiStatueScreen(pos, state);
        }
        return InteractionResult.SUCCESS;
    }

    @Environment(value=EnvType.CLIENT)
    private void openRegiStatueScreen(BlockPos pos, BlockState state) {
        Minecraft.getInstance().setScreen((Screen)new RegiStatueScreen(pos, (RegiType)((Object)state.getValue(REGI_TYPE))));
    }

    public void activateStatue(Level world, BlockPos pos, BlockState state) {
        if (state.getValue(ACTIVATION) == ActivationState.INACTIVE) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue(ACTIVATION, (Comparable)((Object)ActivationState.ACTIVATED)));
            world.scheduleTick(pos, (Block)this, 60);
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (state.getValue(ACTIVATION) == ActivationState.ACTIVATED) {
            this.spawnRegiAndBreak(world, pos, (RegiType)((Object)state.getValue(REGI_TYPE)));
        }
    }

    private void spawnRegiAndBreak(ServerLevel world, BlockPos pos, RegiType regiType) {
        boolean isShiny = world.getRandom().nextFloat() < 0.02f;
        String dimensionId = world.dimension().location().toString();
        String pokemonName = regiType.getPokemonName();
        Object command = String.format("pokespawnat %d %d %d %s lvl=70", pos.getX(), pos.getY(), pos.getZ(), pokemonName);
        if (isShiny) {
            command = (String)command + " shiny";
        }
        System.out.println("Executing command in dimension " + dimensionId + ": " + (String)command);
        CommandSourceStack commandSource = world.getServer().createCommandSourceStack().withLevel(world).withPosition(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()));
        world.getServer().getCommands().performPrefixedCommand(commandSource, (String)command);
        this.giveTabletToNearestPlayerOrDrop(world, pos, regiType);
        world.destroyBlock(pos, false);
        world.players().forEach(player -> {
            if (player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) <= 100.0) {
                MutableComponent message = isShiny ? Component.literal((String)("A shiny " + regiType.getDisplayName() + " has awakened!")).withStyle(ChatFormatting.GOLD) : Component.literal((String)(regiType.getDisplayName() + " has awakened!")).withStyle(ChatFormatting.LIGHT_PURPLE);
                player.displayClientMessage((Component)message, false);
            }
        });
    }

    private void giveTabletToNearestPlayerOrDrop(ServerLevel world, BlockPos pos, RegiType regiType) {
        ItemStack tablet = this.getTabletForRegi(regiType);
        if (tablet == null || tablet.isEmpty()) {
            return;
        }
        Player nearest = null;
        double nearestDistSq = Double.MAX_VALUE;
        double radiusSq = 256.0;
        for (Player p : world.players()) {
            double dSq = p.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
            if (!(dSq <= radiusSq) || !(dSq < nearestDistSq)) continue;
            nearestDistSq = dSq;
            nearest = p;
        }
        if (nearest != null) {
            nearest.addItem(tablet);
        } else {
            ItemEntity drop = new ItemEntity((Level)world, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, tablet);
            world.addFreshEntity((Entity)drop);
        }
    }

    private ItemStack getTabletForRegi(RegiType regiType) {
        switch (regiType.ordinal()) {
            case 1: {
                return new ItemStack((ItemLike)ModItems.REGISTEEL_TABLET);
            }
            case 0: {
                return new ItemStack((ItemLike)ModItems.REGIROCK_TABLET);
            }
            case 2: {
                return new ItemStack((ItemLike)ModItems.REGICE_TABLET);
            }
            case 3: {
                return new ItemStack((ItemLike)ModItems.REGIELEKI_TABLET);
            }
            case 4: {
                return new ItemStack((ItemLike)ModItems.REGIDRAGO_TABLET);
            }
        }
        return new ItemStack((ItemLike)ModItems.TITAN_CORE);
    }

    static {
        VoxelShape head = Shapes.box((double)-0.25, (double)0.625, (double)-0.25, (double)1.25, (double)2.0, (double)1.25);
        VoxelShape neck = Shapes.box((double)-0.1875, (double)0.375, (double)-0.1875, (double)1.1875, (double)0.625, (double)1.1875);
        VoxelShape body = Shapes.box((double)-0.25, (double)-1.0, (double)-0.25, (double)1.25, (double)0.375, (double)1.25);
        VoxelShape rightArmUpper = Shapes.box((double)-0.750625, (double)-0.188125, (double)-0.313125, (double)0.500625, (double)0.313125, (double)0.188125);
        VoxelShape rightArmLower = Shapes.box((double)-0.75, (double)-0.0625, (double)-0.3125, (double)-0.25, (double)1.0, (double)0.1875);
        VoxelShape leftArmUpper = Shapes.box((double)0.499375, (double)-0.188125, (double)-0.313125, (double)1.750625, (double)0.313125, (double)0.188125);
        VoxelShape leftArmLower = Shapes.box((double)1.25, (double)-0.0625, (double)-0.3125, (double)1.75, (double)1.0, (double)0.1875);
        STATUE_SHAPE = Shapes.or((VoxelShape)head, (VoxelShape[])new VoxelShape[]{neck, body, rightArmUpper, rightArmLower, leftArmUpper, leftArmLower});
    }

    public static enum RegiType implements StringRepresentable
    {
        REGIROCK("regirock", "Regirock", "regirock"),
        REGISTEEL("registeel", "Registeel", "registeel"),
        REGICE("regice", "Regice", "regice"),
        REGIELEKI("regieleki", "Regieleki", "regieleki"),
        REGIDRAGO("regidrago", "Regidrago", "regidrago"),
        REGIGIGAS("regigigas", "Regigigas", "regigigas");

        private final String name;
        private final String displayName;
        private final String pokemonName;

        private RegiType(String name, String displayName, String pokemonName) {
            this.name = name;
            this.displayName = displayName;
            this.pokemonName = pokemonName;
        }

        public String getSerializedName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getPokemonName() {
            return this.pokemonName;
        }
    }

    public static enum ActivationState implements StringRepresentable
    {
        INACTIVE("inactive"),
        ACTIVATED("activated");

        private final String name;

        private ActivationState(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

