/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks;

import com.mojang.serialization.MapCodec;
import github.jorgaomc.blocks.entity.SanctuaryBlockEntity;
import github.jorgaomc.network.SanctuaryOpenScreenS2CPacket;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SanctuaryBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    private static final int DEFAULT_RADIUS = 50;
    private static final Map<BlockPos, SanctuaryData> SANCTUARY_DATA = new HashMap<BlockPos, SanctuaryData>();
    private static final VoxelShape SHAPE = Shapes.block();
    public static final MapCodec<SanctuaryBlock> CODEC = SanctuaryBlock.simpleCodec(SanctuaryBlock::new);

    public boolean isTranslucent(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public SanctuaryBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, FACING, ACTIVE});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return new SanctuaryBlockEntity(pos, state);
        }
        return null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.getClickedPos();
        Level world = ctx.getLevel();
        if (blockPos.getY() < world.getMaxBuildHeight() - 1 && world.getBlockState(blockPos.above()).canBeReplaced(ctx)) {
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection())).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true));
        }
        return null;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        BlockPos blockPos = pos.above();
        world.setBlock(blockPos, (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        if (!world.isClientSide && state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockEntity be = world.getBlockEntity(pos);
            if (be instanceof SanctuaryBlockEntity) {
                SanctuaryBlockEntity sbe = (SanctuaryBlockEntity)be;
                SanctuaryData init = new SanctuaryData();
                sbe.fromData(init);
                SANCTUARY_DATA.put(pos, init);
                sbe.setChanged();
            } else {
                SANCTUARY_DATA.putIfAbsent(pos, new SanctuaryData());
            }
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                SanctuaryData data = SANCTUARY_DATA.get(pos);
                serverWorld.sendParticles((ParticleOptions)ParticleTypes.END_ROD, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, 50, (double)data.horizontalRadius / 2.0, 0.5, (double)data.horizontalRadius / 2.0, 0.02);
            }
        }
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (state.getValue(HALF) != DoubleBlockHalf.LOWER) {
            BlockState blockState = world.getBlockState(pos.below());
            return blockState.is((Block)this) && blockState.getValue(HALF) == DoubleBlockHalf.LOWER;
        }
        return super.canSurvive(state, world, pos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        if (half == DoubleBlockHalf.LOWER) {
            return Shapes.or((VoxelShape)SHAPE, (VoxelShape)SHAPE.move(0.0, 1.0, 0.0));
        }
        return Shapes.or((VoxelShape)SHAPE, (VoxelShape)SHAPE.move(0.0, -1.0, 0.0));
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.getValue(HALF);
        BlockPos otherHalfPos = doubleBlockHalf == DoubleBlockHalf.LOWER ? pos.above() : pos.below();
        BlockState otherHalfState = world.getBlockState(otherHalfPos);
        if (otherHalfState.is((Block)this) && otherHalfState.getValue(HALF) != doubleBlockHalf) {
            world.setBlock(otherHalfPos, Blocks.AIR.defaultBlockState(), 35);
            world.levelEvent(player, 2001, otherHalfPos, Block.getId((BlockState)otherHalfState));
        }
        if (!world.isClientSide) {
            BlockPos lowerPos = doubleBlockHalf == DoubleBlockHalf.LOWER ? pos : pos.below();
            SANCTUARY_DATA.remove(lowerPos);
        }
        super.playerWillDestroy(world, pos, state, player);
        return otherHalfState;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos lowerPos = state.getValue(HALF) == DoubleBlockHalf.LOWER ? pos : pos.below();
        BlockState lowerState = world.getBlockState(lowerPos);
        BlockPos upperPos = lowerPos.above();
        if (player.isCreative()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SanctuaryOpenScreenS2CPacket.send(serverPlayer, lowerPos);
            }
        } else {
            boolean newActive;
            SanctuaryData data = SANCTUARY_DATA.get(lowerPos);
            if (data == null) {
                data = new SanctuaryData();
                SANCTUARY_DATA.put(lowerPos, data);
            }
            data.active = newActive = !data.active;
            BlockEntity be = world.getBlockEntity(lowerPos);
            if (be instanceof SanctuaryBlockEntity) {
                SanctuaryBlockEntity sbe = (SanctuaryBlockEntity)be;
                sbe.fromData(data);
                sbe.setChanged();
            }
            world.setBlock(lowerPos, (BlockState)lowerState.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(newActive)), 3);
            world.setBlock(upperPos, (BlockState)world.getBlockState(upperPos).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(newActive)), 3);
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                if (newActive) {
                    serverWorld.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.BEACON_ACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    serverWorld.sendParticles((ParticleOptions)ParticleTypes.END_ROD, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 50, (double)data.horizontalRadius / 2.0, 1.0, (double)data.horizontalRadius / 2.0, 0.02);
                    player.displayClientMessage((Component)Component.literal((String)"The Sanctuary has been activated. Area is now protected.").withStyle(ChatFormatting.GREEN), true);
                } else {
                    serverWorld.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.BEACON_DEACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    serverWorld.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 25, (double)data.horizontalRadius / 4.0, 0.5, (double)data.horizontalRadius / 4.0, 0.05);
                    player.displayClientMessage((Component)Component.literal((String)"The Sanctuary has been deactivated. Area protection removed.").withStyle(ChatFormatting.YELLOW), true);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public static SanctuaryData getSanctuaryData(BlockPos pos) {
        SanctuaryData data = SANCTUARY_DATA.get(pos);
        if (data == null) {
            data = new SanctuaryData();
            SANCTUARY_DATA.put(pos, data);
            System.out.println("Created new sanctuary data for pos: " + String.valueOf(pos));
        } else {
            System.out.println("Retrieved sanctuary data for pos: " + String.valueOf(pos) + " - Active: " + data.active + " - Explosion: " + data.explosionProtection);
        }
        return data;
    }

    public static void updateSanctuaryData(BlockPos pos, boolean active, boolean explosionProtection, boolean blockPlacement, boolean blockBreaking, boolean mobSpawning, int horizontalRadius, int verticalRadius) {
        SanctuaryData data = SANCTUARY_DATA.get(pos);
        if (data != null) {
            data.active = active;
            data.explosionProtection = explosionProtection;
            data.blockPlacement = blockPlacement;
            data.blockBreaking = blockBreaking;
            data.mobSpawning = mobSpawning;
            data.horizontalRadius = Math.max(1, Math.min(100, horizontalRadius));
            data.verticalRadius = Math.max(1, Math.min(100, verticalRadius));
        }
    }

    public static void updateSanctuaryDataWithWorld(Level world, BlockPos pos, boolean active, boolean explosionProtection, boolean blockPlacement, boolean blockBreaking, boolean mobSpawning, int horizontalRadius, int verticalRadius) {
        System.out.println("Updating sanctuary data for pos: " + String.valueOf(pos) + " - Active: " + active + " - Explosion: " + explosionProtection);
        SanctuaryData data = SANCTUARY_DATA.get(pos);
        if (data == null) {
            data = new SanctuaryData();
            SANCTUARY_DATA.put(pos, data);
            System.out.println("Created new sanctuary data during update for pos: " + String.valueOf(pos));
        }
        data.active = active;
        data.explosionProtection = explosionProtection;
        data.blockPlacement = blockPlacement;
        data.blockBreaking = blockBreaking;
        data.mobSpawning = mobSpawning;
        data.horizontalRadius = Math.max(1, Math.min(100, horizontalRadius));
        data.verticalRadius = Math.max(1, Math.min(100, verticalRadius));
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof SanctuaryBlockEntity) {
            SanctuaryBlockEntity sbe = (SanctuaryBlockEntity)be;
            sbe.fromData(data);
            sbe.setChanged();
        }
        System.out.println("Updated data - Active: " + data.active + " - Explosion: " + data.explosionProtection);
        if (!world.isClientSide) {
            BlockState lowerState = world.getBlockState(pos);
            BlockState upperState = world.getBlockState(pos.above());
            if (lowerState.getBlock() instanceof SanctuaryBlock && lowerState.getValue(HALF) == DoubleBlockHalf.LOWER) {
                world.setBlock(pos, (BlockState)lowerState.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
            }
            if (upperState.getBlock() instanceof SanctuaryBlock && upperState.getValue(HALF) == DoubleBlockHalf.UPPER) {
                world.setBlock(pos.above(), (BlockState)upperState.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
            }
        }
    }

    public static boolean isPositionProtected(Level world, BlockPos pos) {
        if (world.isClientSide) {
            return false;
        }
        for (Map.Entry<BlockPos, SanctuaryData> entry : SANCTUARY_DATA.entrySet()) {
            BlockPos sanctuaryPos;
            SanctuaryData data = entry.getValue();
            if (!data.active || !SanctuaryBlock.isWithinRadius(pos, sanctuaryPos = entry.getKey(), data.horizontalRadius, data.verticalRadius)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockPlacementBlocked(Level world, BlockPos pos) {
        if (world.isClientSide) {
            return false;
        }
        for (Map.Entry<BlockPos, SanctuaryData> entry : SANCTUARY_DATA.entrySet()) {
            BlockPos sanctuaryPos;
            SanctuaryData data = entry.getValue();
            if (!data.active || !data.blockPlacement || !SanctuaryBlock.isWithinRadius(pos, sanctuaryPos = entry.getKey(), data.horizontalRadius, data.verticalRadius)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockBreakingBlocked(Level world, BlockPos pos) {
        if (world.isClientSide) {
            return false;
        }
        for (Map.Entry<BlockPos, SanctuaryData> entry : SANCTUARY_DATA.entrySet()) {
            BlockPos sanctuaryPos;
            SanctuaryData data = entry.getValue();
            if (!data.active || !data.blockBreaking || !SanctuaryBlock.isWithinRadius(pos, sanctuaryPos = entry.getKey(), data.horizontalRadius, data.verticalRadius)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExplosionBlocked(Level world, BlockPos pos) {
        if (world.isClientSide) {
            return false;
        }
        for (Map.Entry<BlockPos, SanctuaryData> entry : SANCTUARY_DATA.entrySet()) {
            BlockPos sanctuaryPos;
            SanctuaryData data = entry.getValue();
            if (!data.active || !data.explosionProtection || !SanctuaryBlock.isWithinRadius(pos, sanctuaryPos = entry.getKey(), data.horizontalRadius, data.verticalRadius)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMobSpawningBlocked(Level world, BlockPos pos) {
        if (world.isClientSide) {
            return false;
        }
        for (Map.Entry<BlockPos, SanctuaryData> entry : SANCTUARY_DATA.entrySet()) {
            BlockPos sanctuaryPos;
            SanctuaryData data = entry.getValue();
            if (!data.active || !data.mobSpawning || !SanctuaryBlock.isWithinRadius(pos, sanctuaryPos = entry.getKey(), data.horizontalRadius, data.verticalRadius)) continue;
            return true;
        }
        return false;
    }

    private static boolean isWithinRadius(BlockPos pos, BlockPos sanctuaryPos, int horizontalRadius, int verticalRadius) {
        int dx = pos.getX() - sanctuaryPos.getX();
        int dy = pos.getY() - sanctuaryPos.getY();
        int dz = pos.getZ() - sanctuaryPos.getZ();
        int horizontalDistanceSquared = dx * dx + dz * dz;
        int verticalDistance = Math.abs(dy);
        return horizontalDistanceSquared <= horizontalRadius * horizontalRadius && verticalDistance <= verticalRadius;
    }

    public static class SanctuaryData {
        public boolean active;
        public boolean explosionProtection;
        public boolean blockPlacement;
        public boolean blockBreaking;
        public boolean mobSpawning;
        public int horizontalRadius;
        public int verticalRadius;

        public SanctuaryData() {
            this.active = true;
            this.explosionProtection = true;
            this.blockPlacement = true;
            this.blockBreaking = true;
            this.mobSpawning = true;
            this.horizontalRadius = 50;
            this.verticalRadius = 50;
        }

        public SanctuaryData(boolean active, boolean explosionProtection, boolean blockPlacement, boolean blockBreaking, boolean mobSpawning, int horizontalRadius, int verticalRadius) {
            this.active = active;
            this.explosionProtection = explosionProtection;
            this.blockPlacement = blockPlacement;
            this.blockBreaking = blockBreaking;
            this.mobSpawning = mobSpawning;
            this.horizontalRadius = horizontalRadius;
            this.verticalRadius = verticalRadius;
        }
    }
}

