/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks;

import github.jorgaomc.blocks.MultiBlockBase;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class ShrineBlock
extends MultiBlockBase {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape SHAPE = Shapes.block();
    private final ShrineType shrineType;

    public ShrineBlock(BlockBehaviour.Properties settings, ShrineType shrineType) {
        super(settings.noOcclusion());
        this.shrineType = shrineType;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)MAIN, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public ShrineType getShrineType() {
        return this.shrineType;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction playerFacing = ctx.getHorizontalDirection();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)MAIN, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)playerFacing.getOpposite());
    }

    @Override
    public BlockPos[] getOccupiedPositions(BlockPos mainPos) {
        return this.getOccupiedPositionsWithState(null, mainPos, this.defaultBlockState());
    }

    public BlockPos[] getOccupiedPositionsWithState(LevelReader world, BlockPos mainPos, BlockState state) {
        Level worldInstance;
        BlockState worldState;
        BlockPos[] positions = new BlockPos[9];
        Direction facing = Direction.NORTH;
        if (state != null && state.hasProperty((Property)FACING)) {
            facing = (Direction)state.getValue((Property)FACING);
        } else if (world != null && world instanceof Level && (worldState = (worldInstance = (Level)world).getBlockState(mainPos)).hasProperty((Property)FACING)) {
            facing = (Direction)worldState.getValue((Property)FACING);
        }
        Direction upDown = Direction.UP;
        Direction leftRight = facing == Direction.NORTH || facing == Direction.SOUTH ? Direction.EAST : Direction.NORTH;
        positions[0] = mainPos;
        if (facing == Direction.NORTH) {
            positions[1] = mainPos.west();
            positions[2] = mainPos.east();
        } else if (facing == Direction.SOUTH) {
            positions[1] = mainPos.east();
            positions[2] = mainPos.west();
        } else if (facing == Direction.EAST) {
            positions[1] = mainPos.north();
            positions[2] = mainPos.south();
        } else {
            positions[1] = mainPos.south();
            positions[2] = mainPos.north();
        }
        positions[3] = mainPos.above();
        positions[4] = positions[1].above();
        positions[5] = positions[2].above();
        positions[6] = mainPos.below();
        positions[7] = positions[1].below();
        positions[8] = positions[2].below();
        return positions;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.getValue((Property)MAIN) == false;
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction direction) {
        if (!((Boolean)state.getValue((Property)MAIN)).booleanValue()) {
            return true;
        }
        if (adjacentBlockState.is((Block)this)) {
            return true;
        }
        return super.skipRendering(state, adjacentBlockState, direction);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockPos mainPos;
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.getValue((Property)MAIN)).booleanValue()) {
            mainPos = pos;
        } else {
            Optional<BlockPos> optMainPos = this.findMainBlock(world, pos, state);
            if (optMainPos.isEmpty()) {
                return InteractionResult.FAIL;
            }
            mainPos = optMainPos.get();
        }
        int progress = this.getPlayerProgress(player);
        if (progress >= 8) {
            BlockPos[] positions;
            this.spawnPokemon((ServerLevel)world, mainPos, player);
            this.setPlayerProgress(player, progress - 8);
            ServerLevel serverWorld = (ServerLevel)world;
            this.createParticleExplosion(serverWorld, mainPos);
            for (BlockPos blockPos : positions = this.getOccupiedPositions(mainPos)) {
                world.removeBlock(blockPos, false);
            }
            return InteractionResult.SUCCESS;
        }
        player.displayClientMessage((Component)Component.literal((String)("You need to collect more power from " + this.getShrineTypeName() + " stakes. Current progress: " + progress + "/8")).withStyle(ChatFormatting.GOLD), true);
        return InteractionResult.SUCCESS;
    }

    protected abstract int getPlayerProgress(Player var1);

    protected abstract void setPlayerProgress(Player var1, int var2);

    protected abstract String getShrineTypeName();

    protected abstract void spawnPokemon(ServerLevel var1, BlockPos var2, Player var3);

    protected void createParticleExplosion(ServerLevel world, BlockPos centerPos) {
        world.playSound(null, (double)centerPos.getX() + 0.5, (double)centerPos.getY() + 1.5, (double)centerPos.getZ() + 0.5, (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.getServer().getCommands().performPrefixedCommand(world.getServer().createCommandSourceStack().withLevel(world).withPosition(new Vec3((double)centerPos.getX() + 0.5, (double)centerPos.getY() + 1.5, (double)centerPos.getZ() + 0.5)).withSuppressedOutput(), "particle minecraft:explosion ~ ~ ~ 2 2 2 0.1 10 force");
        for (int i = 0; i < 50; ++i) {
            double offsetX = world.random.nextDouble() * 4.0 - 2.0;
            double offsetY = world.random.nextDouble() * 4.0;
            double offsetZ = world.random.nextDouble() * 4.0 - 2.0;
            world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)centerPos.getX() + 0.5 + offsetX, (double)centerPos.getY() + 1.0 + offsetY, (double)centerPos.getZ() + 0.5 + offsetZ, offsetX * 0.1, offsetY * 0.15, offsetZ * 0.1);
        }
    }

    public static enum ShrineType {
        FIRESCOURGE,
        GRASSWITHER,
        ICEREND,
        GROUNDBLIGHT;

    }
}

