/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class StakeBlock
extends Block {
    protected static final VoxelShape STAKE_SHAPE = Shapes.or((VoxelShape)Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)22.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)19.0, (double)10.0), Block.box((double)4.0, (double)17.0, (double)4.0, (double)12.0, (double)23.0, (double)12.0), Block.box((double)7.0, (double)22.0, (double)7.0, (double)9.0, (double)23.0, (double)9.0), Block.box((double)5.0, (double)18.0, (double)6.0, (double)6.0, (double)22.0, (double)10.0), Block.box((double)10.0, (double)18.0, (double)6.0, (double)11.0, (double)22.0, (double)10.0), Block.box((double)5.0, (double)18.0, (double)5.0, (double)11.0, (double)22.0, (double)6.0), Block.box((double)5.0, (double)18.0, (double)10.0, (double)11.0, (double)22.0, (double)11.0), Block.box((double)4.75, (double)17.75, (double)4.75, (double)11.25, (double)19.25, (double)11.25), Block.box((double)4.0, (double)23.0, (double)7.5, (double)12.0, (double)30.0, (double)8.5)});
    private final StakeType stakeType;

    public StakeBlock(BlockBehaviour.Properties settings, StakeType stakeType) {
        super(settings.noOcclusion().isValidSpawn((state, world, pos, type) -> false).isRedstoneConductor((state, world, pos) -> false).isSuffocating((state, world, pos) -> false).isViewBlocking((state, world, pos) -> false));
        this.stakeType = stakeType;
    }

    public StakeType getStakeType() {
        return this.stakeType;
    }

    public boolean isTranslucent(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return STAKE_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return STAKE_SHAPE;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        int progress = this.getPlayerProgress(player);
        this.setPlayerProgress(player, progress + 1);
        world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.5f, 1.5f);
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            world.getServer().getCommands().performPrefixedCommand(world.getServer().createCommandSourceStack().withLevel(serverWorld).withPosition(new Vec3((double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ())).withSuppressedOutput(), "particle minecraft:end_rod ~ ~0.5 ~ 0.5 0.5 0.5 0.05 20 force");
        }
        world.removeBlock(pos, false);
        player.displayClientMessage((Component)Component.literal((String)("The " + this.getStakeTypeName() + " Seal Weakens. Progress: " + (progress + 1) + "/8")).withStyle(ChatFormatting.GOLD), true);
        return InteractionResult.SUCCESS;
    }

    protected abstract int getPlayerProgress(Player var1);

    protected abstract void setPlayerProgress(Player var1, int var2);

    protected abstract String getStakeTypeName();

    public static enum StakeType {
        FIRESCOURGE,
        GRASSWITHER,
        ICEREND,
        GROUNDBLIGHT;

    }
}

