/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SuitcaseBlock
extends HorizontalDirectionalBlock {
    private static final VoxelShape SHAPE_NORTH = Block.box((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)12.0, (double)13.0);
    private static final VoxelShape SHAPE_EAST = Block.box((double)3.0, (double)0.0, (double)2.0, (double)15.0, (double)12.0, (double)14.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)12.0, (double)15.0);
    private static final VoxelShape SHAPE_WEST = Block.box((double)1.0, (double)0.0, (double)2.0, (double)13.0, (double)12.0, (double)14.0);

    public SuitcaseBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        switch (direction) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    public boolean isTranslucent(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return SuitcaseBlock.simpleCodec(SuitcaseBlock::new);
    }
}

