/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity;

import github.jorgaomc.blocks.entity.ImplementedInventory;
import github.jorgaomc.component.ModDataComponentTypes;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Unit;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class BasePedestalBlockEntity
extends BlockEntity
implements ImplementedInventory {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    protected Set<UUID> usedByPlayers = new HashSet<UUID>();

    public BasePedestalBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean hasPlayerUsed(Player player) {
        return this.usedByPlayers.contains(player.getUUID());
    }

    public void markPlayerUsed(Player player) {
        this.usedByPlayers.add(player.getUUID());
        this.setChanged();
    }

    @Override
    public void clearContent() {
        this.inventory.clear();
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public abstract boolean handleSpecialAction(Player var1, ItemStack var2);

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        NonNullList tempInventory = NonNullList.withSize((int)this.inventory.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            if (stack.isEmpty()) {
                ItemStack dummyItem = new ItemStack((ItemLike)Items.BARRIER);
                dummyItem = dummyItem.copyWithCount(1);
                dummyItem.set(ModDataComponentTypes.PEDESTAL_DUMMY_ITEM, (Object)Unit.INSTANCE);
                tempInventory.set(i, (Object)dummyItem);
                continue;
            }
            tempInventory.set(i, (Object)stack);
        }
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)tempInventory, (HolderLookup.Provider)registryLookup);
        CompoundTag usedPlayersNbt = new CompoundTag();
        int i = 0;
        for (UUID uuid : this.usedByPlayers) {
            usedPlayersNbt.putUUID("player_" + i, uuid);
            ++i;
        }
        usedPlayersNbt.putInt("count", i);
        nbt.put("used_players", (Tag)usedPlayersNbt);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)registryLookup);
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            if (stack.isEmpty() || !stack.is(Items.BARRIER) && !stack.has(ModDataComponentTypes.PEDESTAL_DUMMY_ITEM)) continue;
            this.inventory.set(i, (Object)ItemStack.EMPTY);
        }
        this.usedByPlayers.clear();
        if (nbt.contains("used_players")) {
            CompoundTag usedPlayersNbt = nbt.getCompound("used_players");
            int count = usedPlayersNbt.getInt("count");
            for (int i = 0; i < count; ++i) {
                this.usedByPlayers.add(usedPlayersNbt.getUUID("player_" + i));
            }
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveWithoutMetadata(registryLookup);
    }
}

