/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.blocks.entity.BasePedestalBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;

public abstract class DualPedestalBlockEntity
extends BasePedestalBlockEntity {
    private static final RandomSource RANDOM = RandomSource.create();
    private static final double SHINY_CHANCE = 0.02;
    protected static final int SEARCH_RADIUS = 10;
    protected final Item firstItem;
    protected final Item secondItem;
    protected final String summonName;
    protected final String regularMessagePrefix;
    protected final String shinyMessagePrefix;
    protected final ChatFormatting regularPrefixFormatting;
    protected final ChatFormatting regularMessageFormatting;
    protected final ChatFormatting shinyFormatting;

    public DualPedestalBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, Item firstItem, Item secondItem, String summonName, String regularMessagePrefix, String shinyMessagePrefix, ChatFormatting regularPrefixFormatting, ChatFormatting regularMessageFormatting) {
        super(type, pos, state);
        this.firstItem = firstItem;
        this.secondItem = secondItem;
        this.summonName = summonName;
        this.regularMessagePrefix = regularMessagePrefix;
        this.shinyMessagePrefix = shinyMessagePrefix;
        this.regularPrefixFormatting = regularPrefixFormatting;
        this.regularMessageFormatting = regularMessageFormatting;
        this.shinyFormatting = ChatFormatting.GOLD;
    }

    @Override
    public boolean handleSpecialAction(Player player, ItemStack stack) {
        if (stack.is(this.firstItem) || stack.is(this.secondItem)) {
            Level level;
            if (this.hasPlayerUsed(player)) {
                if (!this.level.isClientSide) {
                    player.displayClientMessage((Component)Component.literal((String)"This pedestal has already been used by you.").withStyle(ChatFormatting.RED), true);
                }
                return false;
            }
            if (!this.level.isClientSide && (level = this.level) instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                List<DualPedestalBlockEntity> otherPedestals = this.findOtherPedestals(serverWorld);
                for (DualPedestalBlockEntity otherPedestal : otherPedestals) {
                    ItemStack otherStack = otherPedestal.getItem(0);
                    if (!this.areComplementaryItems(stack, otherStack)) continue;
                    return this.activateDualPedestals(player, serverWorld, otherPedestal);
                }
                player.displayClientMessage((Component)Component.literal((String)"You sense that another pedestal must be activated nearby...").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}), true);
            }
            return false;
        }
        return false;
    }

    protected boolean areComplementaryItems(ItemStack firstStack, ItemStack secondStack) {
        return firstStack.is(this.firstItem) && secondStack.is(this.secondItem) || firstStack.is(this.secondItem) && secondStack.is(this.firstItem);
    }

    protected List<DualPedestalBlockEntity> findOtherPedestals(ServerLevel world) {
        AABB searchBox = new AABB((double)(this.worldPosition.getX() - 10), (double)(this.worldPosition.getY() - 10), (double)(this.worldPosition.getZ() - 10), (double)(this.worldPosition.getX() + 10), (double)(this.worldPosition.getY() + 10), (double)(this.worldPosition.getZ() + 10));
        ArrayList<DualPedestalBlockEntity> foundPedestals = new ArrayList<DualPedestalBlockEntity>();
        for (int x = this.worldPosition.getX() - 10; x <= this.worldPosition.getX() + 10; ++x) {
            for (int y = this.worldPosition.getY() - 10; y <= this.worldPosition.getY() + 10; ++y) {
                for (int z = this.worldPosition.getZ() - 10; z <= this.worldPosition.getZ() + 10; ++z) {
                    BlockEntity be;
                    BlockPos checkPos = new BlockPos(x, y, z);
                    if (checkPos.equals((Object)this.worldPosition) || (be = world.getBlockEntity(checkPos)) == null || !(be instanceof DualPedestalBlockEntity) || be.getClass() != this.getClass()) continue;
                    foundPedestals.add((DualPedestalBlockEntity)be);
                }
            }
        }
        return foundPedestals;
    }

    protected boolean activateDualPedestals(Player player, ServerLevel world, DualPedestalBlockEntity otherPedestal) {
        try {
            this.markPlayerUsed(player);
            otherPedestal.markPlayerUsed(player);
            this.clearContent();
            otherPedestal.clearContent();
            BlockPos thisPos = this.worldPosition.above();
            BlockPos otherPos = otherPedestal.worldPosition.above();
            BlockPos spawnPos = new BlockPos((thisPos.getX() + otherPos.getX()) / 2, Math.max(thisPos.getY(), otherPos.getY()), (thisPos.getZ() + otherPos.getZ()) / 2);
            boolean isShiny = RANDOM.nextDouble() < 0.02;
            this.createSummonArmorStand(world, spawnPos, isShiny);
            this.spawnEffects(world, spawnPos);
            if (isShiny) {
                player.displayClientMessage((Component)Component.literal((String)this.shinyMessagePrefix).withStyle(new ChatFormatting[]{this.shinyFormatting, ChatFormatting.BOLD}).append((Component)Component.literal((String)("A SHINY " + this.getPokemonName() + " appears!")).withStyle(new ChatFormatting[]{this.shinyFormatting, ChatFormatting.BOLD})), false);
            } else {
                player.displayClientMessage((Component)Component.literal((String)this.regularMessagePrefix).withStyle(new ChatFormatting[]{this.regularPrefixFormatting, ChatFormatting.BOLD}).append((Component)Component.literal((String)(this.getPokemonName() + " appears!")).withStyle(new ChatFormatting[]{this.regularMessageFormatting, ChatFormatting.BOLD})), false);
            }
            this.giveReward(player);
            return true;
        }
        catch (Exception e) {
            System.err.println("Error activating dual pedestals: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    protected void createSummonArmorStand(ServerLevel world, BlockPos pos, boolean isShiny) {
        ArmorStand stand = new ArmorStand(EntityType.ARMOR_STAND, (Level)world);
        stand.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
        stand.setCustomName((Component)Component.literal((String)(this.summonName + (isShiny ? "_shiny" : ""))));
        stand.setCustomNameVisible(false);
        stand.setInvisible(true);
        stand.setNoGravity(true);
        world.addFreshEntity((Entity)stand);
        world.getServer().execute(() -> this.spawnPokemon(world, pos, isShiny));
    }

    protected abstract void spawnEffects(ServerLevel var1, BlockPos var2);

    protected abstract String getPokemonName();

    protected void giveReward(Player player) {
    }

    protected void spawnPokemon(ServerLevel world, BlockPos pos, boolean isShiny) {
        try {
            String armorStandName = this.summonName + (isShiny ? "_shiny" : "");
            List armorStands = world.getEntities((EntityTypeTest)EntityType.ARMOR_STAND, new AABB((double)(pos.getX() - 30), (double)(pos.getY() - 30), (double)(pos.getZ() - 30), (double)(pos.getX() + 30), (double)(pos.getY() + 30), (double)(pos.getZ() + 30)), entity -> entity.hasCustomName() && entity.getCustomName() != null && entity.getCustomName().getString().equals(armorStandName));
            if (armorStands.isEmpty()) {
                System.err.println("Could not find armor stand with name: " + armorStandName);
                return;
            }
            ArmorStand stand = (ArmorStand)armorStands.get(0);
            BlockPos spawnPos = stand.blockPosition();
            PokemonProperties properties = new PokemonProperties();
            properties.setSpecies(this.getPokemonName().toLowerCase());
            properties.setLevel(Integer.valueOf(60));
            if (isShiny) {
                properties.setShiny(Boolean.valueOf(true));
            }
            Pokemon pokemon = properties.create();
            PokemonEntity entity2 = new PokemonEntity((Level)world, pokemon, CobblemonEntities.POKEMON);
            entity2.moveTo((double)spawnPos.getX(), (double)spawnPos.getY(), (double)spawnPos.getZ(), 0.0f, 0.0f);
            world.addFreshEntity((Entity)entity2);
        }
        catch (Exception e) {
            System.err.println("Error spawning " + this.getPokemonName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }
}

